/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.template;

import ca.infodata.ofys.client.modules.template.DDate;
import ca.infodata.ofys.client.modules.template.DField;
import ca.infodata.ofys.client.modules.template.DList;
import ca.infodata.ofys.client.modules.template.DNum;
import ca.infodata.ofys.client.modules.template.DRaw;
import ca.infodata.ofys.client.modules.template.DText;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplateDefinitionParser {
    private static Pattern formatMedoPattern = Pattern.compile("\\$\\{([^\\}]*)\\}");
    private static Pattern formatMedoNumberPattern = Pattern.compile("([0-9]+)([\\\\.,]([0-9]*))?");

    public String format(List<DField> fields) {
        StringBuilder s = new StringBuilder(500);
        for (DField f : fields) {
            s.append(f.format());
        }
        return s.toString();
    }

    public String formatMedo(List<DField> fields) {
        StringBuilder s = new StringBuilder(500);
        for (DField f : fields) {
            s.append(f.formatMedo());
        }
        return s.toString();
    }

    public boolean isFormatMedo(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        Matcher matcher = formatMedoPattern.matcher(s);
        return matcher.find();
    }

    public List<DField> parseMedo(String s) {
        ArrayList<DField> list = new ArrayList<DField>();
        Matcher matcher = formatMedoPattern.matcher(s);
        int start = 0;
        while (matcher.find(start)) {
            DField d = null;
            String temp = matcher.group(1);
            String[] split = temp.split(";");
            if (split.length > 0) {
                String name = split[0];
                if (split.length == 1) {
                    d = new DText(name, null, false, null, false);
                } else {
                    String content = split[1].trim();
                    if (content.contains("!")) {
                        d = new DText(name, content.length(), false, null, false);
                    } else if (content.contains("/")) {
                        d = new DList(name, " ", false, Boolean.TRUE, null, content.split("/"));
                    } else if (content.contains("9")) {
                        if ("9999-99-99".equals(content) || "9999/99/99".equals(content)) {
                            d = new DDate(name, true, true, false, false);
                        } else {
                            Matcher matcher2 = formatMedoNumberPattern.matcher(content);
                            if (matcher2.matches()) {
                                Integer max = null;
                                Integer digits = null;
                                if (StringUtils.isNotBlank((String)matcher2.group(1))) {
                                    max = Integer.parseInt(matcher2.group(1));
                                }
                                if (StringUtils.isNotBlank((String)matcher2.group(3))) {
                                    digits = matcher2.group(3).length();
                                }
                                d = new DNum(name, max, digits, null, false);
                            } else {
                                d = new DText(name, content.length(), false, null, false);
                            }
                        }
                    }
                }
            }
            if (d != null) {
                d.start = matcher.start();
                d.end = matcher.end();
                list.add(d);
            }
            start = matcher.end();
        }
        this.parseRaw(s, list);
        Collections.sort(list);
        return list;
    }

    public List<DField> parse(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return Collections.emptyList();
        }
        if (this.isFormatMedo(s)) {
            return this.parseMedo(s);
        }
        return this.parseNewFormat(s);
    }

    public List<DField> parseNewFormat(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return Collections.emptyList();
        }
        ArrayList<DField> list = new ArrayList<DField>();
        list.addAll(DText.parse(s));
        list.addAll(DDate.parse(s));
        list.addAll(DNum.parse(s));
        list.addAll(DList.parse(s));
        this.parseRaw(s, list);
        Collections.sort(list);
        return list;
    }

    private void parseRaw(String s, List<DField> list) {
        Collections.sort(list);
        ArrayList<DRaw> raws = new ArrayList<DRaw>(20);
        int start = 0;
        for (DField f : list) {
            if (start != f.start) {
                DRaw raw = new DRaw();
                raw.start = start;
                raw.end = f.start;
                raw.raw = s.substring(raw.start, raw.end);
                raws.add(raw);
            }
            start = f.end;
        }
        if (start != s.length()) {
            DRaw raw = new DRaw();
            raw.start = start;
            raw.end = s.length();
            raw.raw = s.substring(raw.start, raw.end);
            raws.add(raw);
        }
        list.addAll(raws);
    }
}

