/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.encounter;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.encounter.BaseEncounterFormatter;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.XUser;
import ca.infodata.ofys.data.middle.dataobjects.encounter.CPrescriptionFormatter;
import ca.infodata.ofys.data.middle.dataobjects.medication.XDrugStrength;
import ca.infodata.ofys.data.middle.dataobjects.medication.XDrugType;
import ca.infodata.ofys.data.middle.dataobjects.medication.XMyOrderableDrugForm;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescription;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescriptionDrugNameFormat;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.data.middle.dataobjects.preferences.XUserPreferences;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;

public final class XPrescriptionFormatter
extends BaseEncounterFormatter {
    private static final String nodata = "?";
    private static final String space = " ";

    public static String formatDrugNameWithComma(XPrescription prescription) {
        if (prescription != null) {
            return XPrescriptionFormatter.formatDrugNameWithComma(prescription.getStrength());
        }
        return nodata;
    }

    public static String formatDrugNameWithBrackets(XPrescription prescription) {
        if (prescription != null) {
            return XPrescriptionFormatter.formatDrugNameWithBrackets(prescription.getStrength());
        }
        return nodata;
    }

    public static String formatDrugNameWithBrackets(XDrugStrength drug) {
        String name = "";
        if (drug != null) {
            String commercialName = drug.getCommercialName();
            String genericName = drug.getGenericName();
            XPrescriptionDrugNameFormat format = XPrescriptionFormatter.getDrugNameFormat();
            switch (format) {
                case COMMERCIAL: {
                    name = drug.getCommercialName();
                    break;
                }
                case GENERIC: {
                    name = drug.getGenericName();
                    break;
                }
                case COMMERCIAL_AND_GENERIC: {
                    if (!StringUtils.isBlank((CharSequence)commercialName)) {
                        name = name + commercialName;
                    }
                    if (StringUtils.isBlank((CharSequence)genericName) || genericName.equalsIgnoreCase(commercialName)) break;
                    name = name + " ( " + genericName + " ) ";
                    break;
                }
                case GENERIC_AND_COMMERCIAL: {
                    if (!StringUtils.isBlank((CharSequence)genericName)) {
                        name = name + genericName;
                    }
                    if (StringUtils.isBlank((CharSequence)commercialName) || commercialName.equalsIgnoreCase(genericName)) break;
                    name = name + " ( " + commercialName + " ) ";
                    break;
                }
            }
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            name = nodata;
        }
        return name;
    }

    public static String formatDrugNameWithComma(XDrugStrength drug) {
        String name = nodata;
        if (drug != null) {
            XPrescriptionDrugNameFormat format = XPrescriptionFormatter.getDrugNameFormat();
            switch (format) {
                case COMMERCIAL: {
                    name = drug.getCommercialName();
                    break;
                }
                case GENERIC: {
                    name = drug.getGenericName();
                    break;
                }
                case COMMERCIAL_AND_GENERIC: {
                    name = new JoinList(", ", 2).setNoDuplicate(true).addUpperCase(drug.getCommercialName()).addUpperCase(drug.getGenericName()).toString();
                    break;
                }
                case GENERIC_AND_COMMERCIAL: {
                    name = new JoinList(", ", 2).setNoDuplicate(true).addUpperCase(drug.getGenericName()).addUpperCase(drug.getCommercialName()).toString();
                    break;
                }
            }
        }
        return name;
    }

    public static XPrescriptionDrugNameFormat getDrugNameFormat() {
        XUserPreferences userPreferences;
        XUser user;
        XPrescriptionDrugNameFormat format = null;
        XSession session = Application.get().getGlobalInstances().getSession();
        if (session != null && (user = session.getUser()) != null && (userPreferences = user.getUserPreferences()) != null) {
            format = userPreferences.getDrugNameFormatSummary();
        }
        if (format == null) {
            format = XPrescriptionDrugNameFormat.COMMERCIAL_AND_GENERIC;
        }
        return format;
    }

    public static String format(XPrescription prescription, CPrescriptionFormatter.ShowMedFileDetail detail) {
        String rxAddedBy;
        if (prescription == null) {
            throw new NullPointerException("prescription");
        }
        boolean isDrug = prescription.getStrength() != null && !XDrugType.FOURNITURE.equals((Object)prescription.getStrength().getDrugType());
        String strength = "";
        if (isDrug) {
            String drugName;
            strength = prescription.getStrength().getText();
            if (prescription.getStrength() != null && !StringUtils.isBlank((CharSequence)prescription.getStrength().getCommercialName()) && (drugName = prescription.getStrength().getCommercialName()).indexOf(strength) != -1) {
                strength = "";
            }
        }
        String posology = "";
        String format = "";
        String frequency = "";
        String quantity = "";
        if (detail.showMoreThan(CPrescriptionFormatter.ShowMedFileDetail.MOYEN)) {
            posology = prescription.getPosology() == null ? "" : prescription.getPosology();
            String string = frequency = prescription.getFrequency() == null ? "" : prescription.getFrequency();
            if (detail.showMoreThan(CPrescriptionFormatter.ShowMedFileDetail.SUPERIEUR)) {
                String string2 = format = prescription.getDevice() != null || prescription.getFormat() == null || prescription.getFormat() == XMyOrderableDrugForm.SO_NA ? "" : prescription.getFormat().description();
                if (prescription.getQuantity() == null || prescription.getQuantity() == 0) {
                    if (prescription.getTreatmentDuration() != null) {
                        quantity = prescription.getTreatmentDuration().toString() + space + Messages.getString((String)"JRS.", (String[])new String[0]);
                    }
                } else {
                    quantity = prescription.getQuantity().toString() + "u";
                    if (isDrug && prescription.getFormat() != null && prescription.getFormat() != XMyOrderableDrugForm.SO_NA) {
                        quantity = quantity + prescription.getFormat().description();
                    }
                }
            }
        }
        String rx = "";
        String startdate = "";
        String note = "";
        if (detail.showMoreThan(CPrescriptionFormatter.ShowMedFileDetail.SUPERIEUR)) {
            rx = prescription.getRx() == null ? "" : prescription.getRx().toString();
            String string = startdate = prescription.getStartDate() == null ? "" : LocalDateFormat.format((LocalDate)prescription.getStartDate(), (String)FormatDateProvider.getFormatDate().toString());
            if (detail.showMoreThan(CPrescriptionFormatter.ShowMedFileDetail.MAXIMUM)) {
                note = prescription.getNote() == null ? "" : prescription.getNote();
                note = note.length() > 50 ? note.substring(0, 50) : note;
            }
        }
        String otherProf = "";
        if (detail.showMoreThan(CPrescriptionFormatter.ShowMedFileDetail.SUPERIEUR)) {
            otherProf = Boolean.TRUE.equals(prescription.getFromProfExterne()) ? Messages.getString((String)"PrescriptionSubControl.FROM_PROF_EXTERNE", (String[])new String[0]) : "";
        }
        StringBuilder b = new StringBuilder(100);
        if (isDrug && strength.length() > 0 && !"-".equals(strength)) {
            b.append(strength);
            b.append(space);
        }
        if (posology.length() > 0 && !"-".equals(posology)) {
            b.append(posology);
            if (detail.showMoreThan(CPrescriptionFormatter.ShowMedFileDetail.SUPERIEUR)) {
                b.append(", ");
            }
        }
        if (format != null && format.length() > 0) {
            b.append(format);
            b.append(space);
        }
        if (frequency != null && frequency.length() > 0 && !"-".equals(frequency) && !".".equals(frequency)) {
            b.append(frequency);
            b.append(space);
        }
        if (quantity != null && quantity.length() > 0) {
            b.append(quantity);
        }
        if (rx != null && rx.length() > 0) {
            b.append(", Rx ");
            b.append(rx);
            b.append(space);
            b.append(Messages.getString((String)"LE", (String[])new String[0]));
            b.append(space);
            b.append(startdate);
        }
        if (note.length() > 0) {
            b.append(space);
            b.append(note);
        }
        if (otherProf.length() > 0) {
            b.append(", ");
            b.append(otherProf);
        }
        if (detail.showMoreThan(CPrescriptionFormatter.ShowMedFileDetail.MAXIMUM) && (rxAddedBy = XPrescriptionFormatter.getAddedByOn(prescription.getEncounter())).length() > 0) {
            b.append(", ");
            b.append(rxAddedBy);
        }
        return b.toString();
    }

    public static String formatLastPrescription(XPrescription prescription, CPrescriptionFormatter.ShowMedFileDetail detail) {
        String rxAddedBy;
        if (prescription == null) {
            throw new NullPointerException("prescription");
        }
        boolean isDrug = prescription.getStrength() != null && !XDrugType.FOURNITURE.equals((Object)prescription.getStrength().getDrugType());
        String strength = prescription.getStrength() == null ? nodata : prescription.getStrength().getText();
        String posology = "";
        String frequency = "";
        String quantity = "";
        String rx = "";
        if (detail.showMoreThan(CPrescriptionFormatter.ShowMedFileDetail.MOYEN)) {
            posology = prescription.getPosology() == null ? "" : prescription.getPosology();
            String string = frequency = prescription.getFrequency() == null ? "" : prescription.getFrequency();
            if (detail.showMoreThan(CPrescriptionFormatter.ShowMedFileDetail.SUPERIEUR)) {
                quantity = "";
                if (prescription.getQuantity() == null || prescription.getQuantity() == 0) {
                    quantity = prescription.getTreatmentDuration() == null ? "0" : prescription.getTreatmentDuration().toString() + space + Messages.getString((String)"JRS.", (String[])new String[0]);
                } else {
                    quantity = prescription.getQuantity().toString();
                    quantity = quantity + space;
                    if (isDrug && prescription.getFormat() != null) {
                        quantity = quantity + prescription.getFormat().description();
                    }
                }
                rx = prescription.getRx() == null ? "" : prescription.getRx().toString();
            }
        }
        StringBuilder b = new StringBuilder(100);
        if (isDrug) {
            b.append(strength);
            b.append(space);
        }
        if (StringUtils.isNotBlank((String)posology)) {
            b.append(posology);
            b.append(space);
        }
        if (isDrug && StringUtils.isNotBlank((String)frequency)) {
            b.append(frequency);
            b.append(", ");
        }
        if (StringUtils.isNotBlank((String)quantity)) {
            b.append(quantity);
        }
        if (StringUtils.isNotBlank((String)rx)) {
            b.append(", R x ");
            b.append(rx);
        }
        if (detail.showMoreThan(CPrescriptionFormatter.ShowMedFileDetail.MAXIMUM) && (rxAddedBy = XPrescriptionFormatter.getAddedByOn(prescription.getEncounter())).length() > 0) {
            b.append(", ");
            b.append(rxAddedBy);
        }
        return b.toString();
    }

    public static String formatActive(XPrescription prescription, CPrescriptionFormatter.ShowMedFileDetail detail) {
        String rxAddedBy;
        if (prescription == null) {
            throw new NullPointerException("prescription");
        }
        boolean isDrug = prescription.getStrength() != null && !XDrugType.FOURNITURE.equals((Object)prescription.getStrength().getDrugType());
        String strength = prescription.getStrength() == null ? "" : prescription.getStrength().getStrength();
        String quantity = "";
        String rx = "";
        if (detail.showMoreThan(CPrescriptionFormatter.ShowMedFileDetail.SUPERIEUR)) {
            if (prescription.getQuantity() == null || prescription.getQuantity() == 0) {
                if (prescription.getTreatmentDuration() != null) {
                    quantity = prescription.getTreatmentDuration().toString() + space + Messages.getString((String)"JRS.", (String[])new String[0]);
                }
            } else {
                quantity = prescription.getQuantity().toString();
                quantity = quantity + space;
                if (isDrug && prescription.getFormat() != null) {
                    quantity = quantity + prescription.getFormat().description();
                }
            }
            rx = prescription.getRx() == null ? nodata : prescription.getRx().toString();
        }
        String startdate = "";
        String enddate = "";
        if (detail.showMoreThan(CPrescriptionFormatter.ShowMedFileDetail.SUPERIEUR)) {
            String string = startdate = prescription.getStartDate() == null ? "" : LocalDateFormat.format((LocalDate)prescription.getStartDate(), (String)FormatDateProvider.getFormatDate().toString());
        }
        if (detail.showMoreThan(CPrescriptionFormatter.ShowMedFileDetail.SUPERIEUR) && prescription.getEndDate() != null) {
            enddate = " (" + Messages.getString((String)"FIN", (String[])new String[0]) + space + LocalDateFormat.format((LocalDate)prescription.getEndDate(), (String)FormatDateProvider.getFormatDate().toString()) + ")";
        }
        StringBuilder b = new StringBuilder(100);
        if (startdate.length() > 0) {
            b.append(startdate);
            b.append(": ");
        }
        if (quantity.length() > 0) {
            b.append(quantity);
            b.append(space);
        }
        if (isDrug && strength.length() > 0) {
            b.append(strength);
            b.append(space);
        }
        if (rx.length() > 0) {
            b.append(rx);
            b.append(space);
            b.append(Messages.getString((String)"RENOUVELLEMENTS", (String[])new String[0]).toLowerCase());
        }
        if (enddate.length() > 0) {
            b.append(enddate);
        }
        if (detail.showMoreThan(CPrescriptionFormatter.ShowMedFileDetail.MAXIMUM) && (rxAddedBy = XPrescriptionFormatter.getAddedByOn(prescription.getEncounter())).length() > 0) {
            b.append(", ");
            b.append(rxAddedBy);
        }
        return b.toString();
    }

    public static String formatReprescribed(XPrescription prescription, CPrescriptionFormatter.ShowMedFileDetail detail) {
        String rxAddedBy;
        if (prescription == null) {
            throw new NullPointerException("prescription");
        }
        boolean isDrug = prescription.getStrength() != null && !XDrugType.FOURNITURE.equals((Object)prescription.getStrength().getDrugType());
        String strength = prescription.getStrength() == null ? nodata : prescription.getStrength().getText();
        String quantity = "";
        String rx = "";
        if (detail.showMoreThan(CPrescriptionFormatter.ShowMedFileDetail.SUPERIEUR)) {
            if (prescription.getQuantity() == null || prescription.getQuantity() == 0) {
                if (prescription.getTreatmentDuration() != null) {
                    quantity = prescription.getTreatmentDuration().toString() + space + Messages.getString((String)"JRS.", (String[])new String[0]);
                }
            } else {
                quantity = prescription.getQuantity().toString();
                quantity = quantity + space;
                if (isDrug && prescription.getFormat() != null) {
                    quantity = quantity + prescription.getFormat().description();
                }
            }
            rx = prescription.getRx() == null ? "" : prescription.getRx().toString();
        }
        String startdate = "";
        String stopdate = "";
        String drugname = null;
        if (detail.showMoreThan(CPrescriptionFormatter.ShowMedFileDetail.SUPERIEUR)) {
            String string = startdate = prescription.getStartDate() == null ? "" : prescription.getStartDate().formatSlash();
        }
        if (prescription.getStrength() != null && !StringUtils.isBlank((CharSequence)prescription.getStrength().getCommercialName())) {
            drugname = prescription.getStrength().getCommercialName();
        }
        StringBuilder b = new StringBuilder(100);
        if (startdate.length() > 0) {
            b.append(startdate);
            b.append(": ");
        }
        if (quantity.length() > 0) {
            b.append(quantity);
            b.append(space);
        }
        if (isDrug && strength.length() > 0) {
            b.append(Messages.getString((String)"DE", (String[])new String[0]).toLowerCase());
            b.append(space);
            b.append(strength);
            b.append(space);
        }
        if (rx.length() > 0) {
            b.append(rx);
            b.append(space);
            b.append(Messages.getString((String)"RENOUVELLEMENTS", (String[])new String[0]).toLowerCase());
        }
        if (stopdate.length() > 0) {
            b.append(stopdate);
        }
        if (detail.showMoreThan(CPrescriptionFormatter.ShowMedFileDetail.MAXIMUM) && (rxAddedBy = XPrescriptionFormatter.getReprescribedByOn(prescription.getEncounter())).length() > 0) {
            b.append(", ");
            b.append(rxAddedBy);
        }
        return b.toString();
    }

    public static String formatInactive(XPrescription prescription, CPrescriptionFormatter.ShowMedFileDetail detail) {
        String rxAddedBy;
        if (prescription == null) {
            throw new NullPointerException("prescription");
        }
        boolean isDrug = prescription.getStrength() != null && !XDrugType.FOURNITURE.equals((Object)prescription.getStrength().getDrugType());
        String _ARRETER_LE_ = Messages.getString((String)"BasePrescriptionSwitchTable._ARRETEE_LE_", (String[])new String[0]);
        String _FIN_ = Messages.getString((String)"BasePrescriptionSwitchTable._FIN_", (String[])new String[0]);
        String strength = prescription.getStrength() == null ? "" : prescription.getStrength().getText() + space + prescription.getStrength().getStrength();
        String quantity = "";
        String rx = "";
        if (detail.showMoreThan(CPrescriptionFormatter.ShowMedFileDetail.SUPERIEUR)) {
            if (prescription.getQuantity() == null || prescription.getQuantity() == 0) {
                if (prescription.getTreatmentDuration() != null) {
                    quantity = prescription.getTreatmentDuration().toString() + space + Messages.getString((String)"JRS.", (String[])new String[0]);
                }
            } else {
                quantity = prescription.getQuantity().toString();
                quantity = quantity + space;
                if (isDrug && prescription.getFormat() != null) {
                    quantity = quantity + prescription.getFormat().description();
                }
            }
            rx = prescription.getRx() == null ? "" : prescription.getRx().toString();
        }
        String startdate = "";
        String stopdate = "";
        String drugname = null;
        if (detail.showMoreThan(CPrescriptionFormatter.ShowMedFileDetail.SUPERIEUR)) {
            String string = startdate = prescription.getStartDate() == null ? "" : prescription.getStartDate().formatSlash();
        }
        if (prescription.getStrength() != null && StringUtils.isNotEmpty((String)prescription.getStrength().getCommercialName())) {
            drugname = prescription.getStrength().getCommercialName();
        }
        if (prescription.getDevice() != null && StringUtils.isNotEmpty((String)prescription.getDevice().getName())) {
            drugname = prescription.getDevice().getName();
        }
        if (detail.showMoreThan(CPrescriptionFormatter.ShowMedFileDetail.SUPERIEUR)) {
            if (prescription.getStopDate() != null) {
                stopdate = _ARRETER_LE_ + prescription.getStopDate().formatSlash();
                if (prescription.getStopReason() != null) {
                    stopdate = stopdate + " : " + prescription.getStopReason();
                }
                stopdate = stopdate + ")";
            }
            if (prescription.getEndDate() != null) {
                stopdate = _FIN_ + prescription.getEndDate().formatSlash() + ")";
            }
        }
        StringBuilder b = new StringBuilder(100);
        if (startdate.length() > 0) {
            b.append(startdate);
            b.append(": ");
        }
        if (quantity.length() > 0) {
            b.append(quantity);
            b.append(space);
        }
        if (isDrug && strength.length() > 0) {
            b.append(Messages.getString((String)"DE", (String[])new String[0]).toLowerCase());
            b.append(space);
            b.append(strength);
            b.append(space);
        }
        if (rx.length() > 0) {
            b.append(rx);
            b.append(space);
            b.append(Messages.getString((String)"RENOUVELLEMENTS", (String[])new String[0]).toLowerCase());
        }
        if (stopdate.length() > 0) {
            b.append(stopdate);
        }
        if (detail.showMoreThan(CPrescriptionFormatter.ShowMedFileDetail.MAXIMUM) && (rxAddedBy = XPrescriptionFormatter.getAddedByOn(prescription.getEncounter())).length() > 0) {
            b.append(", ");
            b.append(rxAddedBy);
        }
        return b.toString();
    }

    public static String getFormattedText(XPrescription prescription, boolean isPrescriptionActive, CPrescriptionFormatter.ShowMedFileDetail detail) {
        String rxAddedBy;
        boolean isDrug = prescription.getStrength() != null && !XDrugType.FOURNITURE.equals((Object)prescription.getStrength().getDrugType());
        String name = nodata;
        name = isDrug ? "" : prescription.getDevice().getName() + space;
        String strength = null;
        if (prescription.getStrength() != null) {
            strength = prescription.getStrength().getText() == null ? "" : prescription.getStrength().getText();
        }
        String posology = "";
        String frequency = "";
        String quantity = "";
        String rx = "";
        if (detail.showMoreThan(CPrescriptionFormatter.ShowMedFileDetail.MOYEN)) {
            posology = prescription.getPosology() == null ? "" : prescription.getPosology();
            String string = frequency = prescription.getFrequency() == null ? "" : prescription.getFrequency();
            if (detail.showMoreThan(CPrescriptionFormatter.ShowMedFileDetail.SUPERIEUR)) {
                if (prescription.getTreatmentDuration() != null && prescription.getTreatmentDuration() > 0) {
                    quantity = prescription.getTreatmentDuration().toString() + space + Messages.getString((String)"JRS.", (String[])new String[0]);
                } else if (prescription.getQuantity() != null && prescription.getQuantity() > 0) {
                    quantity = prescription.getQuantity().toString() + "u ";
                    if (isDrug && prescription.getFormat() != null && prescription.getFormat() != XMyOrderableDrugForm.SO_NA) {
                        quantity = quantity + prescription.getFormat().description();
                    }
                }
            }
        }
        String startdate = "";
        String enddate = "";
        if (detail.showMoreThan(CPrescriptionFormatter.ShowMedFileDetail.SUPERIEUR)) {
            rx = prescription.getRx() == null ? "" : prescription.getRx().toString();
            String string = startdate = prescription.getStartDate() == null ? "" : LocalDateFormat.format((LocalDate)prescription.getStartDate(), (String)FormatDateProvider.getFormatDate().toString());
            if (prescription.getStopDate() != null) {
                enddate = " (" + Messages.getString((String)"ARRETEE_LE", (String[])new String[0]) + space + prescription.getStopDate().formatSlash() + ")";
            } else if (prescription.getEndDate() != null) {
                enddate = " (" + Messages.getString((String)"FIN", (String[])new String[0]) + space + prescription.getEndDate().formatSlash() + ")";
            }
        }
        StringBuilder b = new StringBuilder(100);
        b.append(name);
        if (isDrug && strength.length() > 0 && !"-".equals(strength)) {
            b.append(space);
            b.append(strength);
            b.append(space);
        }
        if (posology.length() > 0 && !"-".equals(posology)) {
            b.append(posology);
            b.append(space);
        }
        if (isDrug && frequency != null && frequency.length() > 0 && !"-".equals(frequency) && !".".equals(frequency)) {
            b.append(frequency);
            b.append(space);
        }
        if (quantity.length() > 0) {
            b.append(", ");
            b.append(quantity);
        }
        if (prescription.getRx() != null && prescription.getRx() > 0 && isPrescriptionActive && rx.length() > 0) {
            b.append(", Rx ");
            b.append(rx);
            b.append(space);
            b.append(Messages.getString((String)"LE", (String[])new String[0]));
            b.append(space);
            b.append(startdate);
        }
        if (enddate.length() > 0) {
            b.append(space);
            b.append(enddate);
            LocalDate presumedEndDate = prescription.getPresumedDateToRenvew();
            String finDate = presumedEndDate == null ? "" : " * FIN: " + LocalDateFormat.format((LocalDate)presumedEndDate, (String)FormatDateProvider.getFormatDate().toString());
            b.append(finDate);
        }
        if (detail.showMoreThan(CPrescriptionFormatter.ShowMedFileDetail.MAXIMUM) && (rxAddedBy = XPrescriptionFormatter.getAddedByOn(prescription.getEncounter())).length() > 0) {
            b.append(", ");
            b.append(rxAddedBy);
        }
        return b.toString();
    }
}

