/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.dsq.internal;

import ca.infodata.dsq.domain.Address;
import ca.infodata.dsq.domain.Candidate;
import ca.infodata.dsq.domain.Gender;
import ca.infodata.dsq.domain.NAM;
import ca.infodata.dsq.service.ru.FindCandidateCriteria;
import ca.infodata.dsq.service.ru.FindCandidateCriteriaBuilder;
import ca.infodata.dsq.signature.Signature;
import ca.infodata.dsq.signature.XmlSignatureI;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.job.IProgressMonitor;
import ca.infodata.ofys.client.job.NullProgressMonitor;
import ca.infodata.ofys.client.modules.dsq.AbortException;
import ca.infodata.ofys.client.modules.dsq.Alias;
import ca.infodata.ofys.client.modules.dsq.CancelException;
import ca.infodata.ofys.client.modules.dsq.IDSQPluginController;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.IDSQAccessor;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XPerson;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.ofys.ui.dashboard.models.CFindCandidateCriteria;
import ca.infodata.util1.StringUtils;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FindCandidateController {
    private static final Logger logger = Logger.getLogger(FindCandidateController.class.getName());
    private static final String RECHERCHE_DU_PATIENT = Messages.getString((String)"FindCandidateAction.RECHERCHE_DU_PATIENT", (String[])new String[0]);
    private final IDSQPluginController dsq = Application.get().getDsqPluginController();
    private final IDSQAccessor dsqAccessor = Application.get().getDataAccessors().getDSQAccessor();

    public Candidate findCandidate(CFindCandidateCriteria cCriteria) throws Exception {
        return this.findCandidate(cCriteria, null);
    }

    public Candidate findCandidate(CFindCandidateCriteria cCriteria, IProgressMonitor monitor) throws Exception {
        if (cCriteria == null) {
            throw new IllegalArgumentException("criteria is required");
        }
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        monitor.beginTask(RECHERCHE_DU_PATIENT, 2);
        Candidate result = null;
        try {
            XmlSignatureI signature = null;
            if (!this.dsq.hasSignatures(null)) {
                if (!Application.get().getApplicationUiPlugin().isWindowsDesktop()) {
                    throw new AbortException(Messages.getString((String)"ABSENCE_SIGN_DSQ", (String[])new String[0]));
                }
                Alias alias = this.dsq.getAlias(monitor);
                signature = this.dsq.getSignatureI(monitor, alias, null);
                monitor.worked(1);
            }
            monitor.subTask(RECHERCHE_DU_PATIENT);
            FindCandidateCriteriaBuilder builder = FindCandidateCriteria.builder();
            builder.setFirstName(cCriteria.firstName);
            builder.setLastName(cCriteria.lastName);
            builder.setBirthdate(cCriteria.birthdate == null ? null : Long.valueOf(cCriteria.birthdate.toTimeInMillisUTC()));
            builder.setGender(FindCandidateController.getDsqGender(cCriteria.gender));
            builder.setNam(StringUtils.isBlank((CharSequence)cCriteria.nam) ? null : new NAM(cCriteria.nam));
            builder.setFatherFirstName(cCriteria.fatherFirstName);
            builder.setFatherLastName(cCriteria.fatherLastName);
            builder.setMotherMaidenFirstName(cCriteria.motherFirstName);
            builder.setMotherMaidenLastName(cCriteria.motherLastName);
            if (StringUtils.isNotBlank((String)cCriteria.addressStreet)) {
                builder.setAddress(new Address(cCriteria.addressStreet, cCriteria.addressPostalCode, cCriteria.addressCity, cCriteria.addressState, cCriteria.addressCountry, null));
            }
            FindCandidateCriteria criteria = builder.build();
            ReturnObject r = this.dsqAccessor.findCandidateByCriteria((Signature)signature, criteria);
            monitor.worked(1);
            if (r == null) {
                throw new AbortException("Erreur lors de la recherche du patient au registre");
            }
            this.dsq.manageDsqStatus(r.getStatus());
            result = (Candidate)r.getObj();
            if (result != null) {
                monitor.log(Level.INFO, "Recherche r\u00e9ussie");
            }
        }
        catch (CannotConnectToServerException e) {
            throw new StatusException((IStatus)new Status(IStatus.Severity.ERROR, e.getMessage()));
        }
        catch (AbortException | CancelException | StatusException e) {
            throw e;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, String.format("Failed to find candidate with criteria ", cCriteria), e);
            throw new AbortException("Erreur lors de la recherche du patient au registre");
        }
        finally {
            monitor.done();
        }
        return result;
    }

    private static Gender getDsqGender(String gender) {
        XPerson.Gender g = XPerson.Gender.from((String)gender);
        if (g == XPerson.Gender.FEMININ) {
            return Gender.FEMALE;
        }
        if (g == XPerson.Gender.MASCULIN) {
            return Gender.MALE;
        }
        return null;
    }
}

