/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.dsq;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.dsq.PatientDsqControllersKey;
import ca.infodata.ofys.client.modules.dsq.internal.ConsentControllerWeb;
import ca.infodata.ofys.client.modules.dsq.internal.DMMedicationControllerWeb;
import ca.infodata.ofys.client.modules.dsq.internal.DMPrescriptionControllerWeb;
import ca.infodata.ofys.client.modules.dsq.internal.DispenseControllerWeb;
import ca.infodata.ofys.client.modules.dsq.internal.ExportPrescriptionToDsqControllerWeb;
import ca.infodata.ofys.client.modules.dsq.internal.GetCandidateController;
import ca.infodata.ofys.client.modules.dsq.internal.GetDischargeCareDetailControllerWeb;
import ca.infodata.ofys.client.modules.dsq.internal.GetImagingResultExamReportControllerWeb;
import ca.infodata.ofys.client.modules.dsq.internal.GetLaboListControllerWeb;
import ca.infodata.ofys.client.modules.dsq.internal.GetLaboReportControllerWeb;
import ca.infodata.ofys.client.modules.dsq.internal.ListDischargeCareSummaryControllerWeb;
import ca.infodata.ofys.client.modules.dsq.internal.ListImagingExamControllerWeb;
import ca.infodata.ofys.client.modules.dsq.internal.OEPrescriptionControllerWeb;
import ca.infodata.ofys.client.modules.dsq.internal.OERetractControllerWeb;
import ca.infodata.ofys.client.web.controller.DocumentsController;
import ca.infodata.ofys.client.web.core.IWebSocketChannel;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.ui.dashboard.models.CDsqRequest;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PatientDsqControllers {
    private static final Logger logger = Logger.getLogger(PatientDsqControllers.class.getName());
    private final PatientDsqControllersKey key;
    private final GetCandidateController findCandidateController;
    private final ConsentControllerWeb consentController;
    private final DispenseControllerWeb dispenseController;
    private final OEPrescriptionControllerWeb oePrescriptionController;
    private final DMPrescriptionControllerWeb dmPrescriptionController;
    private final DMMedicationControllerWeb dmMedicationController;
    private final OERetractControllerWeb oeRetractController;
    private final ListImagingExamControllerWeb listImagingExamController;
    private final ListDischargeCareSummaryControllerWeb listDischargeCareSummaryController;
    private final GetImagingResultExamReportControllerWeb getImagingResultExamReportControllerWeb;
    private final GetDischargeCareDetailControllerWeb getDischargeCareDetailControllerWeb;
    private final GetLaboReportControllerWeb getLaboReportController;
    private final GetLaboListControllerWeb getLaboListController;
    private final ExportPrescriptionToDsqControllerWeb exportPrescriptionToDsqController;

    public PatientDsqControllers(PatientDsqControllersKey key, DocumentsController documentsController) {
        this.key = key;
        this.findCandidateController = new GetCandidateController(this.getIdPatient(), this.getWsChannel());
        this.consentController = new ConsentControllerWeb(this.getIdPatient(), this.getWsChannel());
        this.dispenseController = new DispenseControllerWeb(this.getIdPatient(), this.getWsChannel(), this.findCandidateController);
        this.oePrescriptionController = new OEPrescriptionControllerWeb(this.getIdPatient(), this.getWsChannel(), this.findCandidateController);
        this.dmPrescriptionController = new DMPrescriptionControllerWeb(this.getIdPatient(), this.getWsChannel(), this.findCandidateController);
        this.dmMedicationController = new DMMedicationControllerWeb(this.getIdPatient(), this.getWsChannel(), this.findCandidateController);
        this.oeRetractController = new OERetractControllerWeb(this.getIdPatient(), this.getWsChannel(), this.oePrescriptionController);
        this.exportPrescriptionToDsqController = new ExportPrescriptionToDsqControllerWeb(this.getIdPatient(), this.getWsChannel(), this.findCandidateController, this.oeRetractController);
        this.listImagingExamController = new ListImagingExamControllerWeb(this.getIdPatient(), this.getWsChannel(), this.findCandidateController);
        this.getImagingResultExamReportControllerWeb = new GetImagingResultExamReportControllerWeb(this.getIdPatient(), this.getWsChannel(), this.findCandidateController, documentsController);
        this.listDischargeCareSummaryController = new ListDischargeCareSummaryControllerWeb(this.getIdPatient(), this.getWsChannel(), this.findCandidateController);
        this.getDischargeCareDetailControllerWeb = new GetDischargeCareDetailControllerWeb(this.getIdPatient(), this.getWsChannel(), this.findCandidateController, documentsController);
        this.getLaboReportController = new GetLaboReportControllerWeb(this.getIdPatient(), this.getWsChannel(), this.findCandidateController, documentsController);
        this.getLaboListController = new GetLaboListControllerWeb(this.getIdPatient(), this.getWsChannel(), this.findCandidateController);
    }

    public void update(CDsqRequest r) {
        try {
            if ("oe-start".equals(r.type)) {
                LocalDate localDate = this.parseLocalDateSafe(r.value);
                this.oePrescriptionController.setStart(localDate);
            } else if ("oe-end".equals(r.type)) {
                LocalDate localDate = this.parseLocalDateSafe(r.value);
                this.oePrescriptionController.setEnd(localDate);
            } else if ("oe-actif".equals(r.type)) {
                if (r.actif != null) {
                    this.oePrescriptionController.setOnlyActive(r.actif);
                }
            } else if ("dm-start".equals(r.type)) {
                LocalDate localDate = this.parseLocalDateSafe(r.value);
                this.dmPrescriptionController.setStart(localDate);
            } else if ("dm-end".equals(r.type)) {
                LocalDate localDate = this.parseLocalDateSafe(r.value);
                this.dmPrescriptionController.setEnd(localDate);
            } else if ("dm-complete".equals(r.type)) {
                if (r.actif != null) {
                    this.dmPrescriptionController.setIncludeCompletlyDispensed(r.actif);
                }
            } else if ("dm-partiel".equals(r.type)) {
                if (r.actif != null) {
                    this.dmPrescriptionController.setIncludePartiallyDispensed(r.actif);
                }
            } else if ("dm-never".equals(r.type)) {
                if (r.actif != null) {
                    this.dmPrescriptionController.setIncludeNeverDispensed(r.actif);
                }
            } else if ("med-start".equals(r.type)) {
                LocalDate localDate = this.parseLocalDateSafe(r.value);
                this.dmMedicationController.setAdministrationEffectiveStart(localDate);
            } else if ("med-end".equals(r.type)) {
                LocalDate localDate = this.parseLocalDateSafe(r.value);
                this.dmMedicationController.setAdministrationEffectiveEnd(localDate);
            } else if ("med-modif-start".equals(r.type)) {
                LocalDate localDate = this.parseLocalDateSafe(r.value);
                this.dmMedicationController.setAmendedInTimeStart(localDate);
            } else if ("med-modif-end".equals(r.type)) {
                LocalDate localDate = this.parseLocalDateSafe(r.value);
                this.dmMedicationController.setAmendedInTimeEnd(localDate);
            } else if ("med-with-issue".equals(r.type)) {
                if (r.actif != null) {
                    this.dmMedicationController.setOnlyThoseWithIssue(r.actif);
                }
            } else if ("dispense-start".equals(r.type)) {
                LocalDate localDate = this.parseLocalDateSafe(r.value);
                this.dispenseController.setStart(localDate);
            } else if ("dispense-end".equals(r.type)) {
                LocalDate localDate = this.parseLocalDateSafe(r.value);
                this.dispenseController.setEnd(localDate);
            } else if ("dispense-active".equals(r.type)) {
                if (r.actif != null) {
                    this.dispenseController.setActiveProfile(r.actif);
                }
            } else if ("dispense-custom".equals(r.type)) {
                if (r.actif != null) {
                    this.dispenseController.setActiveProfile(r.actif == false);
                }
            } else if ("dispense-mostrecent".equals(r.type) && r.actif != null) {
                this.dispenseController.setMostRecent(r.actif);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to open Encounter Element form edit browser.", e);
        }
    }

    private LocalDate parseLocalDateSafe(String value) {
        LocalDate date = null;
        if (StringUtils.isNotBlank((String)value) && value.trim().length() >= 10) {
            try {
                date = LocalDateFormat.parse((String)value, (String)"yyyy/MM/dd");
            }
            catch (Exception e) {
                logger.info("Coudn't parse value '" + value + "' as a date.");
            }
        }
        return date;
    }

    public IPatient getPatient() {
        return Application.get().getCache().getPatientCache().get(this.key.getIdPatient());
    }

    public Integer getIdPatient() {
        return this.key.getIdPatient();
    }

    public IWebSocketChannel getWsChannel() {
        return this.key.getWebSocketChannel();
    }

    public GetCandidateController getFindCandidateController() {
        return this.findCandidateController;
    }

    public ConsentControllerWeb getConsentController() {
        return this.consentController;
    }

    public DispenseControllerWeb getDispenseController() {
        return this.dispenseController;
    }

    public OEPrescriptionControllerWeb getOePrescriptionController() {
        return this.oePrescriptionController;
    }

    public DMPrescriptionControllerWeb getDmPrescriptionController() {
        return this.dmPrescriptionController;
    }

    public DMMedicationControllerWeb getDmMedicationController() {
        return this.dmMedicationController;
    }

    public OERetractControllerWeb getOeRetractController() {
        return this.oeRetractController;
    }

    public ListImagingExamControllerWeb getListImagingExamController() {
        return this.listImagingExamController;
    }

    public ListDischargeCareSummaryControllerWeb getListDischargeCareSummaryController() {
        return this.listDischargeCareSummaryController;
    }

    public GetDischargeCareDetailControllerWeb getGetDischargeCareDetailControllerWeb() {
        return this.getDischargeCareDetailControllerWeb;
    }

    public GetLaboReportControllerWeb getGetLaboReportController() {
        return this.getLaboReportController;
    }

    public GetLaboListControllerWeb getGetLaboListController() {
        return this.getLaboListController;
    }

    public GetImagingResultExamReportControllerWeb getGetImagingResultExamReportControllerWeb() {
        return this.getImagingResultExamReportControllerWeb;
    }

    public ExportPrescriptionToDsqControllerWeb getExportPrescriptionToDsqController() {
        return this.exportPrescriptionToDsqController;
    }

    public String toString() {
        return "PatientDsqControllers [key=" + this.key + "]";
    }
}

