/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt;

import com.hivemq.client.internal.mqtt.MqttClientSslConfigImpl;
import com.hivemq.client.internal.mqtt.MqttClientSslConfigImplBuilder;
import com.hivemq.client.internal.mqtt.MqttClientTransportConfigImpl;
import com.hivemq.client.internal.mqtt.MqttProxyConfigImpl;
import com.hivemq.client.internal.mqtt.MqttProxyConfigImplBuilder;
import com.hivemq.client.internal.mqtt.MqttWebSocketConfigImpl;
import com.hivemq.client.internal.mqtt.MqttWebSocketConfigImplBuilder;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.internal.util.InetSocketAddressUtil;
import com.hivemq.client.mqtt.MqttClientSslConfig;
import com.hivemq.client.mqtt.MqttClientTransportConfigBuilder;
import com.hivemq.client.mqtt.MqttProxyConfig;
import com.hivemq.client.mqtt.MqttWebSocketConfig;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public abstract class MqttClientTransportConfigImplBuilder<B extends MqttClientTransportConfigImplBuilder<B>> {
    @Nullable
    private InetSocketAddress serverAddress;
    @NotNull
    private Object serverHost = "localhost";
    private int serverPort = -1;
    @Nullable
    private InetSocketAddress localAddress;
    @Nullable
    private MqttClientSslConfigImpl sslConfig;
    @Nullable
    private MqttWebSocketConfigImpl webSocketConfig;
    @Nullable
    private MqttProxyConfigImpl proxyConfig;
    private int socketConnectTimeoutMs = 10000;
    private int mqttConnectTimeoutMs = 60000;

    MqttClientTransportConfigImplBuilder() {
    }

    MqttClientTransportConfigImplBuilder(@NotNull MqttClientTransportConfigImpl transportConfig) {
        this.set(transportConfig);
    }

    MqttClientTransportConfigImplBuilder(@NotNull MqttClientTransportConfigImplBuilder<?> builder) {
        this.serverAddress = builder.serverAddress;
        this.serverHost = builder.serverHost;
        this.serverPort = builder.serverPort;
        this.localAddress = builder.localAddress;
        this.sslConfig = builder.sslConfig;
        this.webSocketConfig = builder.webSocketConfig;
        this.proxyConfig = builder.proxyConfig;
        this.socketConnectTimeoutMs = builder.socketConnectTimeoutMs;
        this.mqttConnectTimeoutMs = builder.mqttConnectTimeoutMs;
    }

    void set(@NotNull MqttClientTransportConfigImpl transportConfig) {
        this.serverAddress = transportConfig.getServerAddress();
        this.localAddress = transportConfig.getRawLocalAddress();
        this.sslConfig = transportConfig.getRawSslConfig();
        this.webSocketConfig = transportConfig.getRawWebSocketConfig();
        this.proxyConfig = transportConfig.getRawProxyConfig();
        this.socketConnectTimeoutMs = transportConfig.getSocketConnectTimeoutMs();
        this.mqttConnectTimeoutMs = transportConfig.getMqttConnectTimeoutMs();
    }

    @NotNull
    abstract B self();

    @NotNull
    public B serverAddress(@Nullable InetSocketAddress address) {
        this.serverAddress = Checks.notNull(address, "Server address");
        return this.self();
    }

    @NotNull
    public B serverHost(@Nullable String host) {
        this.setServerHost(Checks.notEmpty(host, "Server host"));
        return this.self();
    }

    @NotNull
    public B serverHost(@Nullable InetAddress host) {
        this.setServerHost(Checks.notNull(host, "Server host"));
        return this.self();
    }

    private void setServerHost(@NotNull Object host) {
        this.serverHost = host;
        if (this.serverAddress != null) {
            this.serverPort = this.serverAddress.getPort();
            this.serverAddress = null;
        }
    }

    @NotNull
    public B serverPort(int port) {
        this.serverPort = Checks.unsignedShort(port, "Server port");
        if (this.serverAddress != null) {
            InetAddress inetAddress = this.serverAddress.getAddress();
            this.serverHost = inetAddress != null ? inetAddress : this.serverAddress.getHostString();
            this.serverAddress = null;
        }
        return this.self();
    }

    @NotNull
    public B localAddress(@Nullable InetSocketAddress address) {
        this.localAddress = address == null ? null : this.checkLocalAddress(address);
        return this.self();
    }

    @NotNull
    public B localAddress(@Nullable String address) {
        if (address == null) {
            this.removeLocalAddress();
        } else {
            this.localAddress = this.checkLocalAddress(new InetSocketAddress(address, this.getLocalPort()));
        }
        return this.self();
    }

    @NotNull
    public B localAddress(@Nullable InetAddress address) {
        if (address == null) {
            this.removeLocalAddress();
        } else {
            this.localAddress = new InetSocketAddress(address, this.getLocalPort());
        }
        return this.self();
    }

    @NotNull
    private InetSocketAddress checkLocalAddress(@NotNull InetSocketAddress address) {
        if (address.isUnresolved()) {
            throw new IllegalArgumentException("Local bind address must not be unresolved.");
        }
        return address;
    }

    private void removeLocalAddress() {
        if (this.localAddress != null && this.localAddress.getAddress() != null) {
            this.localAddress = this.localAddress.getPort() == 0 ? null : new InetSocketAddress(this.localAddress.getPort());
        }
    }

    private int getLocalPort() {
        return this.localAddress == null ? 0 : this.localAddress.getPort();
    }

    @NotNull
    public B localPort(int port) {
        if (port == 0) {
            if (this.localAddress != null && this.localAddress.getPort() != 0) {
                this.localAddress = this.localAddress.getAddress() == null ? null : new InetSocketAddress(this.localAddress.getAddress(), 0);
            }
        } else {
            this.localAddress = new InetSocketAddress(this.localAddress == null ? null : this.localAddress.getAddress(), port);
        }
        return this.self();
    }

    @NotNull
    public B sslWithDefaultConfig() {
        this.sslConfig = MqttClientSslConfigImpl.DEFAULT;
        return this.self();
    }

    @NotNull
    public B sslConfig(@Nullable MqttClientSslConfig sslConfig) {
        this.sslConfig = Checks.notImplementedOrNull(sslConfig, MqttClientSslConfigImpl.class, "SSL config");
        return this.self();
    }

    public @NotNull MqttClientSslConfigImplBuilder.Nested<B> sslConfig() {
        return new MqttClientSslConfigImplBuilder.Nested<MqttClientTransportConfigImplBuilder>(this.sslConfig, this::sslConfig);
    }

    @NotNull
    public B webSocketWithDefaultConfig() {
        this.webSocketConfig = MqttWebSocketConfigImpl.DEFAULT;
        return this.self();
    }

    @NotNull
    public B webSocketConfig(@Nullable MqttWebSocketConfig webSocketConfig) {
        this.webSocketConfig = Checks.notImplementedOrNull(webSocketConfig, MqttWebSocketConfigImpl.class, "WebSocket config");
        return this.self();
    }

    public  @NotNull MqttWebSocketConfigImplBuilder.Nested<B> webSocketConfig() {
        return new MqttWebSocketConfigImplBuilder.Nested<MqttClientTransportConfigImplBuilder>(this.webSocketConfig, this::webSocketConfig);
    }

    @NotNull
    public B proxyConfig(@Nullable MqttProxyConfig proxyConfig) {
        this.proxyConfig = Checks.notImplementedOrNull(proxyConfig, MqttProxyConfigImpl.class, "Proxy config");
        return this.self();
    }

    public  @NotNull MqttProxyConfigImplBuilder.Nested<B> proxyConfig() {
        return new MqttProxyConfigImplBuilder.Nested<MqttClientTransportConfigImplBuilder>(this.proxyConfig, this::proxyConfig);
    }

    @NotNull
    public B socketConnectTimeout(long timeout, @Nullable TimeUnit timeUnit) {
        Checks.notNull(timeUnit, "Time unit");
        this.socketConnectTimeoutMs = (int)Checks.range(timeUnit.toMillis(timeout), 0L, Integer.MAX_VALUE, "Socket connect timeout in milliseconds");
        return this.self();
    }

    @NotNull
    public B mqttConnectTimeout(long timeout, @Nullable TimeUnit timeUnit) {
        Checks.notNull(timeUnit, "Time unit");
        this.mqttConnectTimeoutMs = (int)Checks.range(timeUnit.toMillis(timeout), 0L, Integer.MAX_VALUE, "MQTT connect timeout in milliseconds");
        return this.self();
    }

    @NotNull
    private InetSocketAddress getServerAddress() {
        if (this.serverAddress != null) {
            return this.serverAddress;
        }
        if (this.serverHost instanceof InetAddress) {
            return new InetSocketAddress((InetAddress)this.serverHost, this.getServerPort());
        }
        return InetSocketAddressUtil.create((String)this.serverHost, this.getServerPort());
    }

    private int getServerPort() {
        if (this.serverPort != -1) {
            return this.serverPort;
        }
        if (this.sslConfig == null) {
            if (this.webSocketConfig == null) {
                return 1883;
            }
            return 80;
        }
        if (this.webSocketConfig == null) {
            return 8883;
        }
        return 443;
    }

    @NotNull
    MqttClientTransportConfigImpl buildTransportConfig() {
        return new MqttClientTransportConfigImpl(this.getServerAddress(), this.localAddress, this.sslConfig, this.webSocketConfig, this.proxyConfig, this.socketConnectTimeoutMs, this.mqttConnectTimeoutMs);
    }

    public static class Nested<P>
    extends MqttClientTransportConfigImplBuilder<Nested<P>>
    implements MqttClientTransportConfigBuilder.Nested<P> {
        @NotNull
        private final Function<? super MqttClientTransportConfigImpl, P> parentConsumer;

        public Nested(@NotNull MqttClientTransportConfigImpl transportConfig, @NotNull Function<? super MqttClientTransportConfigImpl, P> parentConsumer) {
            super(transportConfig);
            this.parentConsumer = parentConsumer;
        }

        Nested(@NotNull MqttClientTransportConfigImplBuilder<?> builder, @NotNull Function<? super MqttClientTransportConfigImpl, P> parentConsumer) {
            super(builder);
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        Nested<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P applyTransportConfig() {
            return this.parentConsumer.apply(this.buildTransportConfig());
        }
    }

    public static class Default
    extends MqttClientTransportConfigImplBuilder<Default>
    implements MqttClientTransportConfigBuilder {
        public Default() {
        }

        Default(@NotNull MqttClientTransportConfigImpl transportConfig) {
            super(transportConfig);
        }

        @Override
        @NotNull
        Default self() {
            return this;
        }

        @Override
        @NotNull
        public MqttClientTransportConfigImpl build() {
            return this.buildTransportConfig();
        }
    }
}

