/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.impl;

import ca.uhn.hl7v2.validation.ValidationException;
import ca.uhn.hl7v2.validation.impl.AbstractPrimitiveTypeRule;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexPrimitiveRule
extends AbstractPrimitiveTypeRule {
    private final Pattern myPattern;
    private final String mySectionReference;

    public RegexPrimitiveRule(String theRegex, String theSectionReference) {
        this.myPattern = Pattern.compile(theRegex);
        this.mySectionReference = theSectionReference;
    }

    @Override
    public ValidationException[] apply(String value) {
        if (value == null || value.equals("\"\"") || value.equals("")) {
            return this.passed();
        }
        Matcher matcher = this.myPattern.matcher(value);
        return this.result(matcher.matches(), value);
    }

    @Override
    public String getDescription() {
        return "%s does not match the regular expression " + this.myPattern.pattern();
    }

    @Override
    public String getSectionReference() {
        return this.mySectionReference;
    }
}

