/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v281.datatype.CWE;
import ca.uhn.hl7v2.model.v281.datatype.NM;
import ca.uhn.hl7v2.model.v281.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class OM5
extends AbstractSegment {
    public OM5(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Sequence Number - Test/Observation Master File");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Test/Observations Included Within an Ordered Test Battery");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Observation ID Suffixes");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OM5 - this is probably a bug in the source code generator.", e);
        }
    }

    public NM getSequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getOm51_SequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE[] getTestObservationsIncludedWithinAnOrderedTestBattery() {
        CWE[] retVal = (CWE[])this.getTypedField(2, new CWE[0]);
        return retVal;
    }

    public CWE[] getOm52_TestObservationsIncludedWithinAnOrderedTestBattery() {
        CWE[] retVal = (CWE[])this.getTypedField(2, new CWE[0]);
        return retVal;
    }

    public int getTestObservationsIncludedWithinAnOrderedTestBatteryReps() {
        return this.getReps(2);
    }

    public CWE getTestObservationsIncludedWithinAnOrderedTestBattery(int rep) {
        CWE retVal = (CWE)this.getTypedField(2, rep);
        return retVal;
    }

    public CWE getOm52_TestObservationsIncludedWithinAnOrderedTestBattery(int rep) {
        CWE retVal = (CWE)this.getTypedField(2, rep);
        return retVal;
    }

    public int getOm52_TestObservationsIncludedWithinAnOrderedTestBatteryReps() {
        return this.getReps(2);
    }

    public CWE insertTestObservationsIncludedWithinAnOrderedTestBattery(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(2, rep);
    }

    public CWE insertOm52_TestObservationsIncludedWithinAnOrderedTestBattery(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(2, rep);
    }

    public CWE removeTestObservationsIncludedWithinAnOrderedTestBattery(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(2, rep);
    }

    public CWE removeOm52_TestObservationsIncludedWithinAnOrderedTestBattery(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(2, rep);
    }

    public ST getObservationIDSuffixes() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getOm53_ObservationIDSuffixes() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NM(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

