/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v281.group.MFN_M09_MF_TEST_CATEGORICAL;
import ca.uhn.hl7v2.model.v281.segment.MFI;
import ca.uhn.hl7v2.model.v281.segment.MSH;
import ca.uhn.hl7v2.model.v281.segment.SFT;
import ca.uhn.hl7v2.model.v281.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class MFN_M09
extends AbstractMessage {
    public MFN_M09() {
        this(new DefaultModelClassFactory());
    }

    public MFN_M09(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(MFI.class, true, false);
            this.add(MFN_M09_MF_TEST_CATEGORICAL.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFN_M09 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.8.1";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return this.getTyped("UAC", UAC.class);
    }

    public MFI getMFI() {
        return this.getTyped("MFI", MFI.class);
    }

    public MFN_M09_MF_TEST_CATEGORICAL getMF_TEST_CATEGORICAL() {
        return this.getTyped("MF_TEST_CATEGORICAL", MFN_M09_MF_TEST_CATEGORICAL.class);
    }

    public MFN_M09_MF_TEST_CATEGORICAL getMF_TEST_CATEGORICAL(int rep) {
        return this.getTyped("MF_TEST_CATEGORICAL", rep, MFN_M09_MF_TEST_CATEGORICAL.class);
    }

    public int getMF_TEST_CATEGORICALReps() {
        return this.getReps("MF_TEST_CATEGORICAL");
    }

    public List<MFN_M09_MF_TEST_CATEGORICAL> getMF_TEST_CATEGORICALAll() throws HL7Exception {
        return this.getAllAsList("MF_TEST_CATEGORICAL", MFN_M09_MF_TEST_CATEGORICAL.class);
    }

    public void insertMF_TEST_CATEGORICAL(MFN_M09_MF_TEST_CATEGORICAL structure, int rep) throws HL7Exception {
        super.insertRepetition("MF_TEST_CATEGORICAL", structure, rep);
    }

    public MFN_M09_MF_TEST_CATEGORICAL insertMF_TEST_CATEGORICAL(int rep) throws HL7Exception {
        return (MFN_M09_MF_TEST_CATEGORICAL)super.insertRepetition("MF_TEST_CATEGORICAL", rep);
    }

    public MFN_M09_MF_TEST_CATEGORICAL removeMF_TEST_CATEGORICAL(int rep) throws HL7Exception {
        return (MFN_M09_MF_TEST_CATEGORICAL)super.removeRepetition("MF_TEST_CATEGORICAL", rep);
    }
}

