/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v281.segment.ARV;
import ca.uhn.hl7v2.model.v281.segment.PRT;
import ca.uhn.hl7v2.model.v281.segment.PV1;
import ca.uhn.hl7v2.model.v281.segment.PV2;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RGV_O15_PATIENT_VISIT
extends AbstractGroup {
    public RGV_O15_PATIENT_VISIT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PV1.class, true, false, false);
            this.add(PV2.class, false, false, false);
            this.add(PRT.class, false, true, false);
            this.add(ARV.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RGV_O15_PATIENT_VISIT - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.8.1";
    }

    public PV1 getPV1() {
        PV1 retVal = this.getTyped("PV1", PV1.class);
        return retVal;
    }

    public PV2 getPV2() {
        PV2 retVal = this.getTyped("PV2", PV2.class);
        return retVal;
    }

    public PRT getPRT() {
        PRT retVal = this.getTyped("PRT", PRT.class);
        return retVal;
    }

    public PRT getPRT(int rep) {
        PRT retVal = this.getTyped("PRT", rep, PRT.class);
        return retVal;
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public ARV getARV() {
        ARV retVal = this.getTyped("ARV", ARV.class);
        return retVal;
    }

    public ARV getARV(int rep) {
        ARV retVal = this.getTyped("ARV", rep, ARV.class);
        return retVal;
    }

    public int getARVReps() {
        return this.getReps("ARV");
    }

    public List<ARV> getARVAll() throws HL7Exception {
        return this.getAllAsList("ARV", ARV.class);
    }

    public void insertARV(ARV structure, int rep) throws HL7Exception {
        super.insertRepetition("ARV", structure, rep);
    }

    public ARV insertARV(int rep) throws HL7Exception {
        return (ARV)super.insertRepetition("ARV", rep);
    }

    public ARV removeARV(int rep) throws HL7Exception {
        return (ARV)super.removeRepetition("ARV", rep);
    }
}

