/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CQ;
import ca.uhn.hl7v2.model.v28.datatype.CWE;
import ca.uhn.hl7v2.model.v28.datatype.DTM;
import ca.uhn.hl7v2.model.v28.datatype.ID;
import ca.uhn.hl7v2.model.v28.datatype.IS;
import ca.uhn.hl7v2.model.v28.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PCR
extends AbstractSegment {
    public PCR(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Implicated Product");
            this.add(IS.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(249)}, "Generic Product");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Product Class");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Total Duration Of Therapy");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Product Manufacture Date");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Product Expiration Date");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Product Implantation Date");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Product Explantation Date");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Single Use Device");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Indication For Product Use");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Product Problem");
            this.add(ST.class, false, 3, 0, new Object[]{this.getMessage()}, "Product Serial/Lot Number");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Product Available For Inspection");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Product Evaluation Performed");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Product Evaluation Status");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Product Evaluation Results");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(248)}, "Evaluated Product Source");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Date Product Returned To Manufacturer");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(242)}, "Device Operator Qualifications");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(250)}, "Relatedness Assessment");
            this.add(ID.class, false, 6, 2, new Object[]{this.getMessage(), new Integer(251)}, "Action Taken In Response To The Event");
            this.add(ID.class, false, 6, 2, new Object[]{this.getMessage(), new Integer(252)}, "Event Causality Observations");
            this.add(ID.class, false, 3, 1, new Object[]{this.getMessage(), new Integer(253)}, "Indirect Exposure Mechanism");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PCR - this is probably a bug in the source code generator.", e);
        }
    }

    public CWE getImplicatedProduct() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getPcr1_ImplicatedProduct() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public IS getGenericProduct() {
        IS retVal = (IS)this.getTypedField(2, 0);
        return retVal;
    }

    public IS getPcr2_GenericProduct() {
        IS retVal = (IS)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getProductClass() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getPcr3_ProductClass() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CQ getTotalDurationOfTherapy() {
        CQ retVal = (CQ)this.getTypedField(4, 0);
        return retVal;
    }

    public CQ getPcr4_TotalDurationOfTherapy() {
        CQ retVal = (CQ)this.getTypedField(4, 0);
        return retVal;
    }

    public DTM getProductManufactureDate() {
        DTM retVal = (DTM)this.getTypedField(5, 0);
        return retVal;
    }

    public DTM getPcr5_ProductManufactureDate() {
        DTM retVal = (DTM)this.getTypedField(5, 0);
        return retVal;
    }

    public DTM getProductExpirationDate() {
        DTM retVal = (DTM)this.getTypedField(6, 0);
        return retVal;
    }

    public DTM getPcr6_ProductExpirationDate() {
        DTM retVal = (DTM)this.getTypedField(6, 0);
        return retVal;
    }

    public DTM getProductImplantationDate() {
        DTM retVal = (DTM)this.getTypedField(7, 0);
        return retVal;
    }

    public DTM getPcr7_ProductImplantationDate() {
        DTM retVal = (DTM)this.getTypedField(7, 0);
        return retVal;
    }

    public DTM getProductExplantationDate() {
        DTM retVal = (DTM)this.getTypedField(8, 0);
        return retVal;
    }

    public DTM getPcr8_ProductExplantationDate() {
        DTM retVal = (DTM)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE getSingleUseDevice() {
        CWE retVal = (CWE)this.getTypedField(9, 0);
        return retVal;
    }

    public CWE getPcr9_SingleUseDevice() {
        CWE retVal = (CWE)this.getTypedField(9, 0);
        return retVal;
    }

    public CWE getIndicationForProductUse() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE getPcr10_IndicationForProductUse() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE getProductProblem() {
        CWE retVal = (CWE)this.getTypedField(11, 0);
        return retVal;
    }

    public CWE getPcr11_ProductProblem() {
        CWE retVal = (CWE)this.getTypedField(11, 0);
        return retVal;
    }

    public ST[] getProductSerialLotNumber() {
        ST[] retVal = (ST[])this.getTypedField(12, new ST[0]);
        return retVal;
    }

    public ST[] getPcr12_ProductSerialLotNumber() {
        ST[] retVal = (ST[])this.getTypedField(12, new ST[0]);
        return retVal;
    }

    public int getProductSerialLotNumberReps() {
        return this.getReps(12);
    }

    public ST getProductSerialLotNumber(int rep) {
        ST retVal = (ST)this.getTypedField(12, rep);
        return retVal;
    }

    public ST getPcr12_ProductSerialLotNumber(int rep) {
        ST retVal = (ST)this.getTypedField(12, rep);
        return retVal;
    }

    public int getPcr12_ProductSerialLotNumberReps() {
        return this.getReps(12);
    }

    public ST insertProductSerialLotNumber(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(12, rep);
    }

    public ST insertPcr12_ProductSerialLotNumber(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(12, rep);
    }

    public ST removeProductSerialLotNumber(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(12, rep);
    }

    public ST removePcr12_ProductSerialLotNumber(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(12, rep);
    }

    public CWE getProductAvailableForInspection() {
        CWE retVal = (CWE)this.getTypedField(13, 0);
        return retVal;
    }

    public CWE getPcr13_ProductAvailableForInspection() {
        CWE retVal = (CWE)this.getTypedField(13, 0);
        return retVal;
    }

    public CWE getProductEvaluationPerformed() {
        CWE retVal = (CWE)this.getTypedField(14, 0);
        return retVal;
    }

    public CWE getPcr14_ProductEvaluationPerformed() {
        CWE retVal = (CWE)this.getTypedField(14, 0);
        return retVal;
    }

    public CWE getProductEvaluationStatus() {
        CWE retVal = (CWE)this.getTypedField(15, 0);
        return retVal;
    }

    public CWE getPcr15_ProductEvaluationStatus() {
        CWE retVal = (CWE)this.getTypedField(15, 0);
        return retVal;
    }

    public CWE getProductEvaluationResults() {
        CWE retVal = (CWE)this.getTypedField(16, 0);
        return retVal;
    }

    public CWE getPcr16_ProductEvaluationResults() {
        CWE retVal = (CWE)this.getTypedField(16, 0);
        return retVal;
    }

    public ID getEvaluatedProductSource() {
        ID retVal = (ID)this.getTypedField(17, 0);
        return retVal;
    }

    public ID getPcr17_EvaluatedProductSource() {
        ID retVal = (ID)this.getTypedField(17, 0);
        return retVal;
    }

    public DTM getDateProductReturnedToManufacturer() {
        DTM retVal = (DTM)this.getTypedField(18, 0);
        return retVal;
    }

    public DTM getPcr18_DateProductReturnedToManufacturer() {
        DTM retVal = (DTM)this.getTypedField(18, 0);
        return retVal;
    }

    public ID getDeviceOperatorQualifications() {
        ID retVal = (ID)this.getTypedField(19, 0);
        return retVal;
    }

    public ID getPcr19_DeviceOperatorQualifications() {
        ID retVal = (ID)this.getTypedField(19, 0);
        return retVal;
    }

    public ID getRelatednessAssessment() {
        ID retVal = (ID)this.getTypedField(20, 0);
        return retVal;
    }

    public ID getPcr20_RelatednessAssessment() {
        ID retVal = (ID)this.getTypedField(20, 0);
        return retVal;
    }

    public ID[] getActionTakenInResponseToTheEvent() {
        ID[] retVal = (ID[])this.getTypedField(21, new ID[0]);
        return retVal;
    }

    public ID[] getPcr21_ActionTakenInResponseToTheEvent() {
        ID[] retVal = (ID[])this.getTypedField(21, new ID[0]);
        return retVal;
    }

    public int getActionTakenInResponseToTheEventReps() {
        return this.getReps(21);
    }

    public ID getActionTakenInResponseToTheEvent(int rep) {
        ID retVal = (ID)this.getTypedField(21, rep);
        return retVal;
    }

    public ID getPcr21_ActionTakenInResponseToTheEvent(int rep) {
        ID retVal = (ID)this.getTypedField(21, rep);
        return retVal;
    }

    public int getPcr21_ActionTakenInResponseToTheEventReps() {
        return this.getReps(21);
    }

    public ID insertActionTakenInResponseToTheEvent(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(21, rep);
    }

    public ID insertPcr21_ActionTakenInResponseToTheEvent(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(21, rep);
    }

    public ID removeActionTakenInResponseToTheEvent(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(21, rep);
    }

    public ID removePcr21_ActionTakenInResponseToTheEvent(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(21, rep);
    }

    public ID[] getEventCausalityObservations() {
        ID[] retVal = (ID[])this.getTypedField(22, new ID[0]);
        return retVal;
    }

    public ID[] getPcr22_EventCausalityObservations() {
        ID[] retVal = (ID[])this.getTypedField(22, new ID[0]);
        return retVal;
    }

    public int getEventCausalityObservationsReps() {
        return this.getReps(22);
    }

    public ID getEventCausalityObservations(int rep) {
        ID retVal = (ID)this.getTypedField(22, rep);
        return retVal;
    }

    public ID getPcr22_EventCausalityObservations(int rep) {
        ID retVal = (ID)this.getTypedField(22, rep);
        return retVal;
    }

    public int getPcr22_EventCausalityObservationsReps() {
        return this.getReps(22);
    }

    public ID insertEventCausalityObservations(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(22, rep);
    }

    public ID insertPcr22_EventCausalityObservations(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(22, rep);
    }

    public ID removeEventCausalityObservations(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(22, rep);
    }

    public ID removePcr22_EventCausalityObservations(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(22, rep);
    }

    public ID[] getIndirectExposureMechanism() {
        ID[] retVal = (ID[])this.getTypedField(23, new ID[0]);
        return retVal;
    }

    public ID[] getPcr23_IndirectExposureMechanism() {
        ID[] retVal = (ID[])this.getTypedField(23, new ID[0]);
        return retVal;
    }

    public int getIndirectExposureMechanismReps() {
        return this.getReps(23);
    }

    public ID getIndirectExposureMechanism(int rep) {
        ID retVal = (ID)this.getTypedField(23, rep);
        return retVal;
    }

    public ID getPcr23_IndirectExposureMechanism(int rep) {
        ID retVal = (ID)this.getTypedField(23, rep);
        return retVal;
    }

    public int getPcr23_IndirectExposureMechanismReps() {
        return this.getReps(23);
    }

    public ID insertIndirectExposureMechanism(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(23, rep);
    }

    public ID insertPcr23_IndirectExposureMechanism(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(23, rep);
    }

    public ID removeIndirectExposureMechanism(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(23, rep);
    }

    public ID removePcr23_IndirectExposureMechanism(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(23, rep);
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CWE(this.getMessage());
            }
            case 1: {
                return new IS(this.getMessage(), new Integer(249));
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new CQ(this.getMessage());
            }
            case 4: {
                return new DTM(this.getMessage());
            }
            case 5: {
                return new DTM(this.getMessage());
            }
            case 6: {
                return new DTM(this.getMessage());
            }
            case 7: {
                return new DTM(this.getMessage());
            }
            case 8: {
                return new CWE(this.getMessage());
            }
            case 9: {
                return new CWE(this.getMessage());
            }
            case 10: {
                return new CWE(this.getMessage());
            }
            case 11: {
                return new ST(this.getMessage());
            }
            case 12: {
                return new CWE(this.getMessage());
            }
            case 13: {
                return new CWE(this.getMessage());
            }
            case 14: {
                return new CWE(this.getMessage());
            }
            case 15: {
                return new CWE(this.getMessage());
            }
            case 16: {
                return new ID(this.getMessage(), new Integer(248));
            }
            case 17: {
                return new DTM(this.getMessage());
            }
            case 18: {
                return new ID(this.getMessage(), new Integer(242));
            }
            case 19: {
                return new ID(this.getMessage(), new Integer(250));
            }
            case 20: {
                return new ID(this.getMessage(), new Integer(251));
            }
            case 21: {
                return new ID(this.getMessage(), new Integer(252));
            }
            case 22: {
                return new ID(this.getMessage(), new Integer(253));
            }
        }
        return null;
    }
}

