/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CWE;
import ca.uhn.hl7v2.model.v28.datatype.EI;
import ca.uhn.hl7v2.model.v28.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class IPC
extends AbstractSegment {
    public IPC(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(EI.class, true, 1, 0, new Object[]{this.getMessage()}, "Accession Identifier");
            this.add(EI.class, true, 1, 0, new Object[]{this.getMessage()}, "Requested Procedure ID");
            this.add(EI.class, true, 1, 0, new Object[]{this.getMessage()}, "Study Instance UID");
            this.add(EI.class, true, 1, 0, new Object[]{this.getMessage()}, "Scheduled Procedure Step ID");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Modality");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Protocol Code");
            this.add(EI.class, false, 1, 0, new Object[]{this.getMessage()}, "Scheduled Station Name");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Scheduled Procedure Step Location");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Scheduled Station AE Title");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating IPC - this is probably a bug in the source code generator.", e);
        }
    }

    public EI getAccessionIdentifier() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getIpc1_AccessionIdentifier() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getRequestedProcedureID() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getIpc2_RequestedProcedureID() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getStudyInstanceUID() {
        EI retVal = (EI)this.getTypedField(3, 0);
        return retVal;
    }

    public EI getIpc3_StudyInstanceUID() {
        EI retVal = (EI)this.getTypedField(3, 0);
        return retVal;
    }

    public EI getScheduledProcedureStepID() {
        EI retVal = (EI)this.getTypedField(4, 0);
        return retVal;
    }

    public EI getIpc4_ScheduledProcedureStepID() {
        EI retVal = (EI)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getModality() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getIpc5_Modality() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE[] getProtocolCode() {
        CWE[] retVal = (CWE[])this.getTypedField(6, new CWE[0]);
        return retVal;
    }

    public CWE[] getIpc6_ProtocolCode() {
        CWE[] retVal = (CWE[])this.getTypedField(6, new CWE[0]);
        return retVal;
    }

    public int getProtocolCodeReps() {
        return this.getReps(6);
    }

    public CWE getProtocolCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(6, rep);
        return retVal;
    }

    public CWE getIpc6_ProtocolCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(6, rep);
        return retVal;
    }

    public int getIpc6_ProtocolCodeReps() {
        return this.getReps(6);
    }

    public CWE insertProtocolCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(6, rep);
    }

    public CWE insertIpc6_ProtocolCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(6, rep);
    }

    public CWE removeProtocolCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(6, rep);
    }

    public CWE removeIpc6_ProtocolCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(6, rep);
    }

    public EI getScheduledStationName() {
        EI retVal = (EI)this.getTypedField(7, 0);
        return retVal;
    }

    public EI getIpc7_ScheduledStationName() {
        EI retVal = (EI)this.getTypedField(7, 0);
        return retVal;
    }

    public CWE[] getScheduledProcedureStepLocation() {
        CWE[] retVal = (CWE[])this.getTypedField(8, new CWE[0]);
        return retVal;
    }

    public CWE[] getIpc8_ScheduledProcedureStepLocation() {
        CWE[] retVal = (CWE[])this.getTypedField(8, new CWE[0]);
        return retVal;
    }

    public int getScheduledProcedureStepLocationReps() {
        return this.getReps(8);
    }

    public CWE getScheduledProcedureStepLocation(int rep) {
        CWE retVal = (CWE)this.getTypedField(8, rep);
        return retVal;
    }

    public CWE getIpc8_ScheduledProcedureStepLocation(int rep) {
        CWE retVal = (CWE)this.getTypedField(8, rep);
        return retVal;
    }

    public int getIpc8_ScheduledProcedureStepLocationReps() {
        return this.getReps(8);
    }

    public CWE insertScheduledProcedureStepLocation(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(8, rep);
    }

    public CWE insertIpc8_ScheduledProcedureStepLocation(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(8, rep);
    }

    public CWE removeScheduledProcedureStepLocation(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(8, rep);
    }

    public CWE removeIpc8_ScheduledProcedureStepLocation(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(8, rep);
    }

    public ST getScheduledStationAETitle() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    public ST getIpc9_ScheduledStationAETitle() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new EI(this.getMessage());
            }
            case 1: {
                return new EI(this.getMessage());
            }
            case 2: {
                return new EI(this.getMessage());
            }
            case 3: {
                return new EI(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new CWE(this.getMessage());
            }
            case 6: {
                return new EI(this.getMessage());
            }
            case 7: {
                return new CWE(this.getMessage());
            }
            case 8: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

