/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CWE;
import ca.uhn.hl7v2.model.v28.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class IAR
extends AbstractSegment {
    public IAR(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Allergy Reaction Code");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Allergy Severity Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Sensitivity to Causative Agent Code");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Management");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating IAR - this is probably a bug in the source code generator.", e);
        }
    }

    public CWE getAllergyReactionCode() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getIar1_AllergyReactionCode() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getAllergySeverityCode() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getIar2_AllergySeverityCode() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getSensitivityToCausativeAgentCode() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getIar3_SensitivityToCausativeAgentCode() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getManagement() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getIar4_Management() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CWE(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

