/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v27.datatype.CWE;
import ca.uhn.hl7v2.model.v27.datatype.DTM;
import ca.uhn.hl7v2.model.v27.datatype.FT;
import ca.uhn.hl7v2.model.v27.datatype.ID;
import ca.uhn.hl7v2.model.v27.datatype.SI;
import ca.uhn.hl7v2.model.v27.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class NTE
extends AbstractSegment {
    public NTE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 0, new Object[]{this.getMessage()}, "Set ID - NTE");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(105)}, "Source of Comment");
            this.add(FT.class, false, 0, 0, new Object[]{this.getMessage()}, "Comment");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Comment Type");
            this.add(XCN.class, false, 1, 0, new Object[]{this.getMessage()}, "Entered By");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Entered Date/Time");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Effective Start Date");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Expiration Date");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating NTE - this is probably a bug in the source code generator.", e);
        }
    }

    public SI getSetIDNTE() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getNte1_SetIDNTE() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getSourceOfComment() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getNte2_SourceOfComment() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public FT[] getComment() {
        FT[] retVal = (FT[])this.getTypedField(3, new FT[0]);
        return retVal;
    }

    public FT[] getNte3_Comment() {
        FT[] retVal = (FT[])this.getTypedField(3, new FT[0]);
        return retVal;
    }

    public int getCommentReps() {
        return this.getReps(3);
    }

    public FT getComment(int rep) {
        FT retVal = (FT)this.getTypedField(3, rep);
        return retVal;
    }

    public FT getNte3_Comment(int rep) {
        FT retVal = (FT)this.getTypedField(3, rep);
        return retVal;
    }

    public int getNte3_CommentReps() {
        return this.getReps(3);
    }

    public FT insertComment(int rep) throws HL7Exception {
        return (FT)super.insertRepetition(3, rep);
    }

    public FT insertNte3_Comment(int rep) throws HL7Exception {
        return (FT)super.insertRepetition(3, rep);
    }

    public FT removeComment(int rep) throws HL7Exception {
        return (FT)super.removeRepetition(3, rep);
    }

    public FT removeNte3_Comment(int rep) throws HL7Exception {
        return (FT)super.removeRepetition(3, rep);
    }

    public CWE getCommentType() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getNte4_CommentType() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public XCN getEnteredBy() {
        XCN retVal = (XCN)this.getTypedField(5, 0);
        return retVal;
    }

    public XCN getNte5_EnteredBy() {
        XCN retVal = (XCN)this.getTypedField(5, 0);
        return retVal;
    }

    public DTM getEnteredDateTime() {
        DTM retVal = (DTM)this.getTypedField(6, 0);
        return retVal;
    }

    public DTM getNte6_EnteredDateTime() {
        DTM retVal = (DTM)this.getTypedField(6, 0);
        return retVal;
    }

    public DTM getEffectiveStartDate() {
        DTM retVal = (DTM)this.getTypedField(7, 0);
        return retVal;
    }

    public DTM getNte7_EffectiveStartDate() {
        DTM retVal = (DTM)this.getTypedField(7, 0);
        return retVal;
    }

    public DTM getExpirationDate() {
        DTM retVal = (DTM)this.getTypedField(8, 0);
        return retVal;
    }

    public DTM getNte8_ExpirationDate() {
        DTM retVal = (DTM)this.getTypedField(8, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(105));
            }
            case 2: {
                return new FT(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new XCN(this.getMessage());
            }
            case 5: {
                return new DTM(this.getMessage());
            }
            case 6: {
                return new DTM(this.getMessage());
            }
            case 7: {
                return new DTM(this.getMessage());
            }
        }
        return null;
    }
}

