/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v251.group.VXX_V02_PATIENT;
import ca.uhn.hl7v2.model.v251.segment.MSA;
import ca.uhn.hl7v2.model.v251.segment.MSH;
import ca.uhn.hl7v2.model.v251.segment.QRD;
import ca.uhn.hl7v2.model.v251.segment.QRF;
import ca.uhn.hl7v2.model.v251.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class VXX_V02
extends AbstractMessage {
    public VXX_V02() {
        this(new DefaultModelClassFactory());
    }

    public VXX_V02(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(SFT.class, false, true);
            this.add(QRD.class, true, false);
            this.add(QRF.class, false, false);
            this.add(VXX_V02_PATIENT.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating VXX_V02 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.5.1";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return this.getTyped("MSA", MSA.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public QRD getQRD() {
        return this.getTyped("QRD", QRD.class);
    }

    public QRF getQRF() {
        return this.getTyped("QRF", QRF.class);
    }

    public VXX_V02_PATIENT getPATIENT() {
        return this.getTyped("PATIENT", VXX_V02_PATIENT.class);
    }

    public VXX_V02_PATIENT getPATIENT(int rep) {
        return this.getTyped("PATIENT", rep, VXX_V02_PATIENT.class);
    }

    public int getPATIENTReps() {
        return this.getReps("PATIENT");
    }

    public List<VXX_V02_PATIENT> getPATIENTAll() throws HL7Exception {
        return this.getAllAsList("PATIENT", VXX_V02_PATIENT.class);
    }

    public void insertPATIENT(VXX_V02_PATIENT structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT", structure, rep);
    }

    public VXX_V02_PATIENT insertPATIENT(int rep) throws HL7Exception {
        return (VXX_V02_PATIENT)super.insertRepetition("PATIENT", rep);
    }

    public VXX_V02_PATIENT removePATIENT(int rep) throws HL7Exception {
        return (VXX_V02_PATIENT)super.removeRepetition("PATIENT", rep);
    }
}

