/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v24.segment.EVN;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.ORG;
import ca.uhn.hl7v2.model.v24.segment.PRA;
import ca.uhn.hl7v2.model.v24.segment.STF;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class PMU_B04
extends AbstractMessage {
    public PMU_B04() {
        this(new DefaultModelClassFactory());
    }

    public PMU_B04(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(EVN.class, true, false);
            this.add(STF.class, true, false);
            this.add(PRA.class, false, true);
            this.add(ORG.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PMU_B04 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.4";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public EVN getEVN() {
        return this.getTyped("EVN", EVN.class);
    }

    public STF getSTF() {
        return this.getTyped("STF", STF.class);
    }

    public PRA getPRA() {
        return this.getTyped("PRA", PRA.class);
    }

    public PRA getPRA(int rep) {
        return this.getTyped("PRA", rep, PRA.class);
    }

    public int getPRAReps() {
        return this.getReps("PRA");
    }

    public List<PRA> getPRAAll() throws HL7Exception {
        return this.getAllAsList("PRA", PRA.class);
    }

    public void insertPRA(PRA structure, int rep) throws HL7Exception {
        super.insertRepetition("PRA", structure, rep);
    }

    public PRA insertPRA(int rep) throws HL7Exception {
        return (PRA)super.insertRepetition("PRA", rep);
    }

    public PRA removePRA(int rep) throws HL7Exception {
        return (PRA)super.removeRepetition("PRA", rep);
    }

    public ORG getORG() {
        return this.getTyped("ORG", ORG.class);
    }
}

