/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v24.group.MFN_M01_MF;
import ca.uhn.hl7v2.model.v24.segment.MFI;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class MFN_M01
extends AbstractMessage {
    public MFN_M01() {
        this(new DefaultModelClassFactory());
    }

    public MFN_M01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MFI.class, true, false);
            this.add(MFN_M01_MF.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFN_M01 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.4";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public MFI getMFI() {
        return this.getTyped("MFI", MFI.class);
    }

    public MFN_M01_MF getMF() {
        return this.getTyped("MF", MFN_M01_MF.class);
    }

    public MFN_M01_MF getMF(int rep) {
        return this.getTyped("MF", rep, MFN_M01_MF.class);
    }

    public int getMFReps() {
        return this.getReps("MF");
    }

    public List<MFN_M01_MF> getMFAll() throws HL7Exception {
        return this.getAllAsList("MF", MFN_M01_MF.class);
    }

    public void insertMF(MFN_M01_MF structure, int rep) throws HL7Exception {
        super.insertRepetition("MF", structure, rep);
    }

    public MFN_M01_MF insertMF(int rep) throws HL7Exception {
        return (MFN_M01_MF)super.insertRepetition("MF", rep);
    }

    public MFN_M01_MF removeMF(int rep) throws HL7Exception {
        return (MFN_M01_MF)super.removeRepetition("MF", rep);
    }
}

