/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v231.datatype.CE;
import ca.uhn.hl7v2.model.v231.datatype.CX;
import ca.uhn.hl7v2.model.v231.datatype.DT;
import ca.uhn.hl7v2.model.v231.datatype.DTN;
import ca.uhn.hl7v2.model.v231.datatype.ID;
import ca.uhn.hl7v2.model.v231.datatype.IS;
import ca.uhn.hl7v2.model.v231.datatype.MOP;
import ca.uhn.hl7v2.model.v231.datatype.PCF;
import ca.uhn.hl7v2.model.v231.datatype.SI;
import ca.uhn.hl7v2.model.v231.datatype.ST;
import ca.uhn.hl7v2.model.v231.datatype.TS;
import ca.uhn.hl7v2.model.v231.datatype.XCN;
import ca.uhn.hl7v2.model.v231.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class IN3
extends AbstractSegment {
    public IN3(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID - IN3");
            this.add(CX.class, false, 1, 59, new Object[]{this.getMessage()}, "Certification Number");
            this.add(XCN.class, false, 0, 60, new Object[]{this.getMessage()}, "Certified By");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Certification Required");
            this.add(MOP.class, false, 1, 10, new Object[]{this.getMessage()}, "Penalty");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Certification Date/Time");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Certification Modify Date/Time");
            this.add(XCN.class, false, 0, 60, new Object[]{this.getMessage()}, "Operator");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Certification Begin Date");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Certification End Date");
            this.add(DTN.class, false, 1, 3, new Object[]{this.getMessage()}, "Days");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Non-Concur Code/Description");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Non-Concur Effective Date/Time");
            this.add(XCN.class, false, 0, 60, new Object[]{this.getMessage()}, "Physician Reviewer");
            this.add(ST.class, false, 1, 48, new Object[]{this.getMessage()}, "Certification Contact");
            this.add(XTN.class, false, 0, 40, new Object[]{this.getMessage()}, "Certification Contact Phone Number");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Appeal Reason");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Certification Agency");
            this.add(XTN.class, false, 0, 40, new Object[]{this.getMessage()}, "Certification Agency Phone Number");
            this.add(PCF.class, false, 0, 40, new Object[]{this.getMessage()}, "Pre-Certification Req/Window");
            this.add(ST.class, false, 1, 48, new Object[]{this.getMessage()}, "Case Manager");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Second Opinion Date");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(151)}, "Second Opinion Status");
            this.add(IS.class, false, 0, 1, new Object[]{this.getMessage(), new Integer(152)}, "Second Opinion Documentation Received");
            this.add(XCN.class, false, 0, 60, new Object[]{this.getMessage()}, "Second Opinion Physician");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating IN3 - this is probably a bug in the source code generator.", e);
        }
    }

    public SI getSetIDIN3() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getIn31_SetIDIN3() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public CX getCertificationNumber() {
        CX retVal = (CX)this.getTypedField(2, 0);
        return retVal;
    }

    public CX getIn32_CertificationNumber() {
        CX retVal = (CX)this.getTypedField(2, 0);
        return retVal;
    }

    public XCN[] getCertifiedBy() {
        XCN[] retVal = (XCN[])this.getTypedField(3, new XCN[0]);
        return retVal;
    }

    public XCN[] getIn33_CertifiedBy() {
        XCN[] retVal = (XCN[])this.getTypedField(3, new XCN[0]);
        return retVal;
    }

    public int getCertifiedByReps() {
        return this.getReps(3);
    }

    public XCN getCertifiedBy(int rep) {
        XCN retVal = (XCN)this.getTypedField(3, rep);
        return retVal;
    }

    public XCN getIn33_CertifiedBy(int rep) {
        XCN retVal = (XCN)this.getTypedField(3, rep);
        return retVal;
    }

    public int getIn33_CertifiedByReps() {
        return this.getReps(3);
    }

    public XCN insertCertifiedBy(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(3, rep);
    }

    public XCN insertIn33_CertifiedBy(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(3, rep);
    }

    public XCN removeCertifiedBy(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(3, rep);
    }

    public XCN removeIn33_CertifiedBy(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(3, rep);
    }

    public ID getCertificationRequired() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public ID getIn34_CertificationRequired() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public MOP getPenalty() {
        MOP retVal = (MOP)this.getTypedField(5, 0);
        return retVal;
    }

    public MOP getIn35_Penalty() {
        MOP retVal = (MOP)this.getTypedField(5, 0);
        return retVal;
    }

    public TS getCertificationDateTime() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getIn36_CertificationDateTime() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getCertificationModifyDateTime() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public TS getIn37_CertificationModifyDateTime() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public XCN[] getOperator() {
        XCN[] retVal = (XCN[])this.getTypedField(8, new XCN[0]);
        return retVal;
    }

    public XCN[] getIn38_Operator() {
        XCN[] retVal = (XCN[])this.getTypedField(8, new XCN[0]);
        return retVal;
    }

    public int getOperatorReps() {
        return this.getReps(8);
    }

    public XCN getOperator(int rep) {
        XCN retVal = (XCN)this.getTypedField(8, rep);
        return retVal;
    }

    public XCN getIn38_Operator(int rep) {
        XCN retVal = (XCN)this.getTypedField(8, rep);
        return retVal;
    }

    public int getIn38_OperatorReps() {
        return this.getReps(8);
    }

    public XCN insertOperator(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(8, rep);
    }

    public XCN insertIn38_Operator(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(8, rep);
    }

    public XCN removeOperator(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(8, rep);
    }

    public XCN removeIn38_Operator(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(8, rep);
    }

    public DT getCertificationBeginDate() {
        DT retVal = (DT)this.getTypedField(9, 0);
        return retVal;
    }

    public DT getIn39_CertificationBeginDate() {
        DT retVal = (DT)this.getTypedField(9, 0);
        return retVal;
    }

    public DT getCertificationEndDate() {
        DT retVal = (DT)this.getTypedField(10, 0);
        return retVal;
    }

    public DT getIn310_CertificationEndDate() {
        DT retVal = (DT)this.getTypedField(10, 0);
        return retVal;
    }

    public DTN getDays() {
        DTN retVal = (DTN)this.getTypedField(11, 0);
        return retVal;
    }

    public DTN getIn311_Days() {
        DTN retVal = (DTN)this.getTypedField(11, 0);
        return retVal;
    }

    public CE getNonConcurCodeDescription() {
        CE retVal = (CE)this.getTypedField(12, 0);
        return retVal;
    }

    public CE getIn312_NonConcurCodeDescription() {
        CE retVal = (CE)this.getTypedField(12, 0);
        return retVal;
    }

    public TS getNonConcurEffectiveDateTime() {
        TS retVal = (TS)this.getTypedField(13, 0);
        return retVal;
    }

    public TS getIn313_NonConcurEffectiveDateTime() {
        TS retVal = (TS)this.getTypedField(13, 0);
        return retVal;
    }

    public XCN[] getPhysicianReviewer() {
        XCN[] retVal = (XCN[])this.getTypedField(14, new XCN[0]);
        return retVal;
    }

    public XCN[] getIn314_PhysicianReviewer() {
        XCN[] retVal = (XCN[])this.getTypedField(14, new XCN[0]);
        return retVal;
    }

    public int getPhysicianReviewerReps() {
        return this.getReps(14);
    }

    public XCN getPhysicianReviewer(int rep) {
        XCN retVal = (XCN)this.getTypedField(14, rep);
        return retVal;
    }

    public XCN getIn314_PhysicianReviewer(int rep) {
        XCN retVal = (XCN)this.getTypedField(14, rep);
        return retVal;
    }

    public int getIn314_PhysicianReviewerReps() {
        return this.getReps(14);
    }

    public XCN insertPhysicianReviewer(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(14, rep);
    }

    public XCN insertIn314_PhysicianReviewer(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(14, rep);
    }

    public XCN removePhysicianReviewer(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(14, rep);
    }

    public XCN removeIn314_PhysicianReviewer(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(14, rep);
    }

    public ST getCertificationContact() {
        ST retVal = (ST)this.getTypedField(15, 0);
        return retVal;
    }

    public ST getIn315_CertificationContact() {
        ST retVal = (ST)this.getTypedField(15, 0);
        return retVal;
    }

    public XTN[] getCertificationContactPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(16, new XTN[0]);
        return retVal;
    }

    public XTN[] getIn316_CertificationContactPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(16, new XTN[0]);
        return retVal;
    }

    public int getCertificationContactPhoneNumberReps() {
        return this.getReps(16);
    }

    public XTN getCertificationContactPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(16, rep);
        return retVal;
    }

    public XTN getIn316_CertificationContactPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(16, rep);
        return retVal;
    }

    public int getIn316_CertificationContactPhoneNumberReps() {
        return this.getReps(16);
    }

    public XTN insertCertificationContactPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(16, rep);
    }

    public XTN insertIn316_CertificationContactPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(16, rep);
    }

    public XTN removeCertificationContactPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(16, rep);
    }

    public XTN removeIn316_CertificationContactPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(16, rep);
    }

    public CE getAppealReason() {
        CE retVal = (CE)this.getTypedField(17, 0);
        return retVal;
    }

    public CE getIn317_AppealReason() {
        CE retVal = (CE)this.getTypedField(17, 0);
        return retVal;
    }

    public CE getCertificationAgency() {
        CE retVal = (CE)this.getTypedField(18, 0);
        return retVal;
    }

    public CE getIn318_CertificationAgency() {
        CE retVal = (CE)this.getTypedField(18, 0);
        return retVal;
    }

    public XTN[] getCertificationAgencyPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(19, new XTN[0]);
        return retVal;
    }

    public XTN[] getIn319_CertificationAgencyPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(19, new XTN[0]);
        return retVal;
    }

    public int getCertificationAgencyPhoneNumberReps() {
        return this.getReps(19);
    }

    public XTN getCertificationAgencyPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(19, rep);
        return retVal;
    }

    public XTN getIn319_CertificationAgencyPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(19, rep);
        return retVal;
    }

    public int getIn319_CertificationAgencyPhoneNumberReps() {
        return this.getReps(19);
    }

    public XTN insertCertificationAgencyPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(19, rep);
    }

    public XTN insertIn319_CertificationAgencyPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(19, rep);
    }

    public XTN removeCertificationAgencyPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(19, rep);
    }

    public XTN removeIn319_CertificationAgencyPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(19, rep);
    }

    public PCF[] getPreCertificationReqWindow() {
        PCF[] retVal = (PCF[])this.getTypedField(20, new PCF[0]);
        return retVal;
    }

    public PCF[] getIn320_PreCertificationReqWindow() {
        PCF[] retVal = (PCF[])this.getTypedField(20, new PCF[0]);
        return retVal;
    }

    public int getPreCertificationReqWindowReps() {
        return this.getReps(20);
    }

    public PCF getPreCertificationReqWindow(int rep) {
        PCF retVal = (PCF)this.getTypedField(20, rep);
        return retVal;
    }

    public PCF getIn320_PreCertificationReqWindow(int rep) {
        PCF retVal = (PCF)this.getTypedField(20, rep);
        return retVal;
    }

    public int getIn320_PreCertificationReqWindowReps() {
        return this.getReps(20);
    }

    public PCF insertPreCertificationReqWindow(int rep) throws HL7Exception {
        return (PCF)super.insertRepetition(20, rep);
    }

    public PCF insertIn320_PreCertificationReqWindow(int rep) throws HL7Exception {
        return (PCF)super.insertRepetition(20, rep);
    }

    public PCF removePreCertificationReqWindow(int rep) throws HL7Exception {
        return (PCF)super.removeRepetition(20, rep);
    }

    public PCF removeIn320_PreCertificationReqWindow(int rep) throws HL7Exception {
        return (PCF)super.removeRepetition(20, rep);
    }

    public ST getCaseManager() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public ST getIn321_CaseManager() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public DT getSecondOpinionDate() {
        DT retVal = (DT)this.getTypedField(22, 0);
        return retVal;
    }

    public DT getIn322_SecondOpinionDate() {
        DT retVal = (DT)this.getTypedField(22, 0);
        return retVal;
    }

    public IS getSecondOpinionStatus() {
        IS retVal = (IS)this.getTypedField(23, 0);
        return retVal;
    }

    public IS getIn323_SecondOpinionStatus() {
        IS retVal = (IS)this.getTypedField(23, 0);
        return retVal;
    }

    public IS[] getSecondOpinionDocumentationReceived() {
        IS[] retVal = (IS[])this.getTypedField(24, new IS[0]);
        return retVal;
    }

    public IS[] getIn324_SecondOpinionDocumentationReceived() {
        IS[] retVal = (IS[])this.getTypedField(24, new IS[0]);
        return retVal;
    }

    public int getSecondOpinionDocumentationReceivedReps() {
        return this.getReps(24);
    }

    public IS getSecondOpinionDocumentationReceived(int rep) {
        IS retVal = (IS)this.getTypedField(24, rep);
        return retVal;
    }

    public IS getIn324_SecondOpinionDocumentationReceived(int rep) {
        IS retVal = (IS)this.getTypedField(24, rep);
        return retVal;
    }

    public int getIn324_SecondOpinionDocumentationReceivedReps() {
        return this.getReps(24);
    }

    public IS insertSecondOpinionDocumentationReceived(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(24, rep);
    }

    public IS insertIn324_SecondOpinionDocumentationReceived(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(24, rep);
    }

    public IS removeSecondOpinionDocumentationReceived(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(24, rep);
    }

    public IS removeIn324_SecondOpinionDocumentationReceived(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(24, rep);
    }

    public XCN[] getSecondOpinionPhysician() {
        XCN[] retVal = (XCN[])this.getTypedField(25, new XCN[0]);
        return retVal;
    }

    public XCN[] getIn325_SecondOpinionPhysician() {
        XCN[] retVal = (XCN[])this.getTypedField(25, new XCN[0]);
        return retVal;
    }

    public int getSecondOpinionPhysicianReps() {
        return this.getReps(25);
    }

    public XCN getSecondOpinionPhysician(int rep) {
        XCN retVal = (XCN)this.getTypedField(25, rep);
        return retVal;
    }

    public XCN getIn325_SecondOpinionPhysician(int rep) {
        XCN retVal = (XCN)this.getTypedField(25, rep);
        return retVal;
    }

    public int getIn325_SecondOpinionPhysicianReps() {
        return this.getReps(25);
    }

    public XCN insertSecondOpinionPhysician(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(25, rep);
    }

    public XCN insertIn325_SecondOpinionPhysician(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(25, rep);
    }

    public XCN removeSecondOpinionPhysician(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(25, rep);
    }

    public XCN removeIn325_SecondOpinionPhysician(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(25, rep);
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CX(this.getMessage());
            }
            case 2: {
                return new XCN(this.getMessage());
            }
            case 3: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 4: {
                return new MOP(this.getMessage());
            }
            case 5: {
                return new TS(this.getMessage());
            }
            case 6: {
                return new TS(this.getMessage());
            }
            case 7: {
                return new XCN(this.getMessage());
            }
            case 8: {
                return new DT(this.getMessage());
            }
            case 9: {
                return new DT(this.getMessage());
            }
            case 10: {
                return new DTN(this.getMessage());
            }
            case 11: {
                return new CE(this.getMessage());
            }
            case 12: {
                return new TS(this.getMessage());
            }
            case 13: {
                return new XCN(this.getMessage());
            }
            case 14: {
                return new ST(this.getMessage());
            }
            case 15: {
                return new XTN(this.getMessage());
            }
            case 16: {
                return new CE(this.getMessage());
            }
            case 17: {
                return new CE(this.getMessage());
            }
            case 18: {
                return new XTN(this.getMessage());
            }
            case 19: {
                return new PCF(this.getMessage());
            }
            case 20: {
                return new ST(this.getMessage());
            }
            case 21: {
                return new DT(this.getMessage());
            }
            case 22: {
                return new IS(this.getMessage(), new Integer(151));
            }
            case 23: {
                return new IS(this.getMessage(), new Integer(152));
            }
            case 24: {
                return new XCN(this.getMessage());
            }
        }
        return null;
    }
}

