/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v231.group.ADT_A43_PIDPD1MRG;
import ca.uhn.hl7v2.model.v231.segment.EVN;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class ADT_A43
extends AbstractMessage {
    public ADT_A43() {
        this(new DefaultModelClassFactory());
    }

    public ADT_A43(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(EVN.class, true, false);
            this.add(ADT_A43_PIDPD1MRG.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ADT_A43 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public EVN getEVN() {
        return this.getTyped("EVN", EVN.class);
    }

    public ADT_A43_PIDPD1MRG getPIDPD1MRG() {
        return this.getTyped("PIDPD1MRG", ADT_A43_PIDPD1MRG.class);
    }

    public ADT_A43_PIDPD1MRG getPIDPD1MRG(int rep) {
        return this.getTyped("PIDPD1MRG", rep, ADT_A43_PIDPD1MRG.class);
    }

    public int getPIDPD1MRGReps() {
        return this.getReps("PIDPD1MRG");
    }

    public List<ADT_A43_PIDPD1MRG> getPIDPD1MRGAll() throws HL7Exception {
        return this.getAllAsList("PIDPD1MRG", ADT_A43_PIDPD1MRG.class);
    }

    public void insertPIDPD1MRG(ADT_A43_PIDPD1MRG structure, int rep) throws HL7Exception {
        super.insertRepetition("PIDPD1MRG", structure, rep);
    }

    public ADT_A43_PIDPD1MRG insertPIDPD1MRG(int rep) throws HL7Exception {
        return (ADT_A43_PIDPD1MRG)super.insertRepetition("PIDPD1MRG", rep);
    }

    public ADT_A43_PIDPD1MRG removePIDPD1MRG(int rep) throws HL7Exception {
        return (ADT_A43_PIDPD1MRG)super.removeRepetition("PIDPD1MRG", rep);
    }
}

