/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.ID;
import ca.uhn.hl7v2.model.v23.datatype.IS;
import ca.uhn.hl7v2.model.v23.datatype.NM;
import ca.uhn.hl7v2.model.v23.datatype.SI;
import ca.uhn.hl7v2.model.v23.datatype.ST;
import ca.uhn.hl7v2.model.v23.datatype.TS;
import ca.uhn.hl7v2.model.v23.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PR1
extends AbstractSegment {
    public PR1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID - Procedure");
            this.add(IS.class, true, 1, 2, new Object[]{this.getMessage(), new Integer(89)}, "Procedure Coding Method");
            this.add(CE.class, false, 1, 80, new Object[]{this.getMessage()}, "Procedure Code");
            this.add(ST.class, false, 1, 40, new Object[]{this.getMessage()}, "Procedure Description");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Procedure Date/Time");
            this.add(ID.class, true, 1, 2, new Object[]{this.getMessage(), new Integer(230)}, "Procedure Type");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Procedure Minutes");
            this.add(XCN.class, false, 0, 120, new Object[]{this.getMessage()}, "Anesthesiologist");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(19)}, "Anesthesia Code");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Anesthesia Minutes");
            this.add(XCN.class, false, 0, 120, new Object[]{this.getMessage()}, "Surgeon");
            this.add(XCN.class, false, 0, 230, new Object[]{this.getMessage()}, "Procedure Practitioner");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Consent Code");
            this.add(NM.class, false, 1, 2, new Object[]{this.getMessage()}, "Procedure Priority");
            this.add(CE.class, false, 1, 80, new Object[]{this.getMessage()}, "Associated Diagnosis Code");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PR1 - this is probably a bug in the source code generator.", e);
        }
    }

    public SI getSetIDProcedure() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getPr11_SetIDProcedure() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public IS getProcedureCodingMethod() {
        IS retVal = (IS)this.getTypedField(2, 0);
        return retVal;
    }

    public IS getPr12_ProcedureCodingMethod() {
        IS retVal = (IS)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getProcedureCode() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getPr13_ProcedureCode() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getProcedureDescription() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getPr14_ProcedureDescription() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public TS getProcedureDateTime() {
        TS retVal = (TS)this.getTypedField(5, 0);
        return retVal;
    }

    public TS getPr15_ProcedureDateTime() {
        TS retVal = (TS)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getProcedureType() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public ID getPr16_ProcedureType() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getProcedureMinutes() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public NM getPr17_ProcedureMinutes() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public XCN[] getAnesthesiologist() {
        XCN[] retVal = (XCN[])this.getTypedField(8, new XCN[0]);
        return retVal;
    }

    public XCN[] getPr18_Anesthesiologist() {
        XCN[] retVal = (XCN[])this.getTypedField(8, new XCN[0]);
        return retVal;
    }

    public int getAnesthesiologistReps() {
        return this.getReps(8);
    }

    public XCN getAnesthesiologist(int rep) {
        XCN retVal = (XCN)this.getTypedField(8, rep);
        return retVal;
    }

    public XCN getPr18_Anesthesiologist(int rep) {
        XCN retVal = (XCN)this.getTypedField(8, rep);
        return retVal;
    }

    public int getPr18_AnesthesiologistReps() {
        return this.getReps(8);
    }

    public XCN insertAnesthesiologist(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(8, rep);
    }

    public XCN insertPr18_Anesthesiologist(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(8, rep);
    }

    public XCN removeAnesthesiologist(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(8, rep);
    }

    public XCN removePr18_Anesthesiologist(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(8, rep);
    }

    public IS getAnesthesiaCode() {
        IS retVal = (IS)this.getTypedField(9, 0);
        return retVal;
    }

    public IS getPr19_AnesthesiaCode() {
        IS retVal = (IS)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getAnesthesiaMinutes() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public NM getPr110_AnesthesiaMinutes() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public XCN[] getSurgeon() {
        XCN[] retVal = (XCN[])this.getTypedField(11, new XCN[0]);
        return retVal;
    }

    public XCN[] getPr111_Surgeon() {
        XCN[] retVal = (XCN[])this.getTypedField(11, new XCN[0]);
        return retVal;
    }

    public int getSurgeonReps() {
        return this.getReps(11);
    }

    public XCN getSurgeon(int rep) {
        XCN retVal = (XCN)this.getTypedField(11, rep);
        return retVal;
    }

    public XCN getPr111_Surgeon(int rep) {
        XCN retVal = (XCN)this.getTypedField(11, rep);
        return retVal;
    }

    public int getPr111_SurgeonReps() {
        return this.getReps(11);
    }

    public XCN insertSurgeon(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(11, rep);
    }

    public XCN insertPr111_Surgeon(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(11, rep);
    }

    public XCN removeSurgeon(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(11, rep);
    }

    public XCN removePr111_Surgeon(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(11, rep);
    }

    public XCN[] getProcedurePractitioner() {
        XCN[] retVal = (XCN[])this.getTypedField(12, new XCN[0]);
        return retVal;
    }

    public XCN[] getPr112_ProcedurePractitioner() {
        XCN[] retVal = (XCN[])this.getTypedField(12, new XCN[0]);
        return retVal;
    }

    public int getProcedurePractitionerReps() {
        return this.getReps(12);
    }

    public XCN getProcedurePractitioner(int rep) {
        XCN retVal = (XCN)this.getTypedField(12, rep);
        return retVal;
    }

    public XCN getPr112_ProcedurePractitioner(int rep) {
        XCN retVal = (XCN)this.getTypedField(12, rep);
        return retVal;
    }

    public int getPr112_ProcedurePractitionerReps() {
        return this.getReps(12);
    }

    public XCN insertProcedurePractitioner(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(12, rep);
    }

    public XCN insertPr112_ProcedurePractitioner(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(12, rep);
    }

    public XCN removeProcedurePractitioner(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(12, rep);
    }

    public XCN removePr112_ProcedurePractitioner(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(12, rep);
    }

    public CE getConsentCode() {
        CE retVal = (CE)this.getTypedField(13, 0);
        return retVal;
    }

    public CE getPr113_ConsentCode() {
        CE retVal = (CE)this.getTypedField(13, 0);
        return retVal;
    }

    public NM getProcedurePriority() {
        NM retVal = (NM)this.getTypedField(14, 0);
        return retVal;
    }

    public NM getPr114_ProcedurePriority() {
        NM retVal = (NM)this.getTypedField(14, 0);
        return retVal;
    }

    public CE getAssociatedDiagnosisCode() {
        CE retVal = (CE)this.getTypedField(15, 0);
        return retVal;
    }

    public CE getPr115_AssociatedDiagnosisCode() {
        CE retVal = (CE)this.getTypedField(15, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new IS(this.getMessage(), new Integer(89));
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new ST(this.getMessage());
            }
            case 4: {
                return new TS(this.getMessage());
            }
            case 5: {
                return new ID(this.getMessage(), new Integer(230));
            }
            case 6: {
                return new NM(this.getMessage());
            }
            case 7: {
                return new XCN(this.getMessage());
            }
            case 8: {
                return new IS(this.getMessage(), new Integer(19));
            }
            case 9: {
                return new NM(this.getMessage());
            }
            case 10: {
                return new XCN(this.getMessage());
            }
            case 11: {
                return new XCN(this.getMessage());
            }
            case 12: {
                return new CE(this.getMessage());
            }
            case 13: {
                return new NM(this.getMessage());
            }
            case 14: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

