/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.CM_EIP;
import ca.uhn.hl7v2.model.v23.datatype.CM_MOC;
import ca.uhn.hl7v2.model.v23.datatype.CM_NDL;
import ca.uhn.hl7v2.model.v23.datatype.CM_PRL;
import ca.uhn.hl7v2.model.v23.datatype.CM_SPS;
import ca.uhn.hl7v2.model.v23.datatype.CQ;
import ca.uhn.hl7v2.model.v23.datatype.EI;
import ca.uhn.hl7v2.model.v23.datatype.ID;
import ca.uhn.hl7v2.model.v23.datatype.NM;
import ca.uhn.hl7v2.model.v23.datatype.SI;
import ca.uhn.hl7v2.model.v23.datatype.ST;
import ca.uhn.hl7v2.model.v23.datatype.TQ;
import ca.uhn.hl7v2.model.v23.datatype.TS;
import ca.uhn.hl7v2.model.v23.datatype.XCN;
import ca.uhn.hl7v2.model.v23.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class OBR
extends AbstractSegment {
    public OBR(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "Set ID - Observation Request");
            this.add(EI.class, false, 0, 22, new Object[]{this.getMessage()}, "Placer Order Number");
            this.add(EI.class, false, 1, 22, new Object[]{this.getMessage()}, "Filler Order Number");
            this.add(CE.class, true, 1, 200, new Object[]{this.getMessage()}, "Universal Service Identifier");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(0)}, "Priority");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Requested Date/Time");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Observation Date/Time");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Observation End Date/Time");
            this.add(CQ.class, false, 1, 20, new Object[]{this.getMessage()}, "Collection Volume");
            this.add(XCN.class, false, 0, 60, new Object[]{this.getMessage()}, "Collector Identifier");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(65)}, "Specimen Action Code");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Danger Code");
            this.add(ST.class, false, 1, 300, new Object[]{this.getMessage()}, "Relevant Clinical Information");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Specimen Received Date/Time");
            this.add(CM_SPS.class, false, 1, 300, new Object[]{this.getMessage()}, "Specimen Source");
            this.add(XCN.class, false, 0, 120, new Object[]{this.getMessage()}, "Ordering Provider");
            this.add(XTN.class, false, 2, 40, new Object[]{this.getMessage()}, "Order Callback Phone Number");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage()}, "Placer Field 1");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage()}, "Placer Field 2");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage()}, "Filler Field 1");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage()}, "Filler Field 2");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Results Rpt/Status Chng - Date/Time");
            this.add(CM_MOC.class, false, 1, 40, new Object[]{this.getMessage()}, "Charge To Practice");
            this.add(ID.class, false, 1, 10, new Object[]{this.getMessage(), new Integer(74)}, "Diagnostic Service Section ID");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(123)}, "Result Status");
            this.add(CM_PRL.class, false, 1, 200, new Object[]{this.getMessage()}, "Parent Result");
            this.add(TQ.class, true, 1, 200, new Object[]{this.getMessage()}, "Quantity/Timing");
            this.add(XCN.class, false, 5, 150, new Object[]{this.getMessage()}, "Result Copies To");
            this.add(CM_EIP.class, false, 1, 150, new Object[]{this.getMessage()}, "Parent Number");
            this.add(ID.class, false, 1, 20, new Object[]{this.getMessage(), new Integer(124)}, "Transportation Mode");
            this.add(CE.class, false, 0, 300, new Object[]{this.getMessage()}, "Reason For Study");
            this.add(CM_NDL.class, false, 1, 200, new Object[]{this.getMessage()}, "Principal Result Interpreter");
            this.add(CM_NDL.class, false, 0, 200, new Object[]{this.getMessage()}, "Assistant Result Interpreter");
            this.add(CM_NDL.class, false, 0, 200, new Object[]{this.getMessage()}, "Technician");
            this.add(CM_NDL.class, false, 0, 200, new Object[]{this.getMessage()}, "Transcriptionist");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Scheduled Date/Time");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Number Of Sample Containers");
            this.add(CE.class, false, 0, 60, new Object[]{this.getMessage()}, "Transport Logistics Of Collected Sample");
            this.add(CE.class, false, 0, 200, new Object[]{this.getMessage()}, "Collector\u2019s Comment");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Transport Arrangement Responsibility");
            this.add(ID.class, false, 1, 30, new Object[]{this.getMessage(), new Integer(224)}, "Transport Arranged");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(225)}, "Escort Required");
            this.add(CE.class, false, 0, 200, new Object[]{this.getMessage()}, "Planned Patient Transport Comment");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OBR - this is probably a bug in the source code generator.", e);
        }
    }

    public SI getSetIDObservationRequest() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getObr1_SetIDObservationRequest() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI[] getPlacerOrderNumber() {
        EI[] retVal = (EI[])this.getTypedField(2, new EI[0]);
        return retVal;
    }

    public EI[] getObr2_PlacerOrderNumber() {
        EI[] retVal = (EI[])this.getTypedField(2, new EI[0]);
        return retVal;
    }

    public int getPlacerOrderNumberReps() {
        return this.getReps(2);
    }

    public EI getPlacerOrderNumber(int rep) {
        EI retVal = (EI)this.getTypedField(2, rep);
        return retVal;
    }

    public EI getObr2_PlacerOrderNumber(int rep) {
        EI retVal = (EI)this.getTypedField(2, rep);
        return retVal;
    }

    public int getObr2_PlacerOrderNumberReps() {
        return this.getReps(2);
    }

    public EI insertPlacerOrderNumber(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(2, rep);
    }

    public EI insertObr2_PlacerOrderNumber(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(2, rep);
    }

    public EI removePlacerOrderNumber(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(2, rep);
    }

    public EI removeObr2_PlacerOrderNumber(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(2, rep);
    }

    public EI getFillerOrderNumber() {
        EI retVal = (EI)this.getTypedField(3, 0);
        return retVal;
    }

    public EI getObr3_FillerOrderNumber() {
        EI retVal = (EI)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getUniversalServiceIdentifier() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getObr4_UniversalServiceIdentifier() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public ID getPriority() {
        ID retVal = (ID)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getObr5_Priority() {
        ID retVal = (ID)this.getTypedField(5, 0);
        return retVal;
    }

    public TS getRequestedDateTime() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getObr6_RequestedDateTime() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getObservationDateTime() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public TS getObr7_ObservationDateTime() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public TS getObservationEndDateTime() {
        TS retVal = (TS)this.getTypedField(8, 0);
        return retVal;
    }

    public TS getObr8_ObservationEndDateTime() {
        TS retVal = (TS)this.getTypedField(8, 0);
        return retVal;
    }

    public CQ getCollectionVolume() {
        CQ retVal = (CQ)this.getTypedField(9, 0);
        return retVal;
    }

    public CQ getObr9_CollectionVolume() {
        CQ retVal = (CQ)this.getTypedField(9, 0);
        return retVal;
    }

    public XCN[] getCollectorIdentifier() {
        XCN[] retVal = (XCN[])this.getTypedField(10, new XCN[0]);
        return retVal;
    }

    public XCN[] getObr10_CollectorIdentifier() {
        XCN[] retVal = (XCN[])this.getTypedField(10, new XCN[0]);
        return retVal;
    }

    public int getCollectorIdentifierReps() {
        return this.getReps(10);
    }

    public XCN getCollectorIdentifier(int rep) {
        XCN retVal = (XCN)this.getTypedField(10, rep);
        return retVal;
    }

    public XCN getObr10_CollectorIdentifier(int rep) {
        XCN retVal = (XCN)this.getTypedField(10, rep);
        return retVal;
    }

    public int getObr10_CollectorIdentifierReps() {
        return this.getReps(10);
    }

    public XCN insertCollectorIdentifier(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(10, rep);
    }

    public XCN insertObr10_CollectorIdentifier(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(10, rep);
    }

    public XCN removeCollectorIdentifier(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(10, rep);
    }

    public XCN removeObr10_CollectorIdentifier(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(10, rep);
    }

    public ID getSpecimenActionCode() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getObr11_SpecimenActionCode() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public CE getDangerCode() {
        CE retVal = (CE)this.getTypedField(12, 0);
        return retVal;
    }

    public CE getObr12_DangerCode() {
        CE retVal = (CE)this.getTypedField(12, 0);
        return retVal;
    }

    public ST getRelevantClinicalInformation() {
        ST retVal = (ST)this.getTypedField(13, 0);
        return retVal;
    }

    public ST getObr13_RelevantClinicalInformation() {
        ST retVal = (ST)this.getTypedField(13, 0);
        return retVal;
    }

    public TS getSpecimenReceivedDateTime() {
        TS retVal = (TS)this.getTypedField(14, 0);
        return retVal;
    }

    public TS getObr14_SpecimenReceivedDateTime() {
        TS retVal = (TS)this.getTypedField(14, 0);
        return retVal;
    }

    public CM_SPS getSpecimenSource() {
        CM_SPS retVal = (CM_SPS)this.getTypedField(15, 0);
        return retVal;
    }

    public CM_SPS getObr15_SpecimenSource() {
        CM_SPS retVal = (CM_SPS)this.getTypedField(15, 0);
        return retVal;
    }

    public XCN[] getOrderingProvider() {
        XCN[] retVal = (XCN[])this.getTypedField(16, new XCN[0]);
        return retVal;
    }

    public XCN[] getObr16_OrderingProvider() {
        XCN[] retVal = (XCN[])this.getTypedField(16, new XCN[0]);
        return retVal;
    }

    public int getOrderingProviderReps() {
        return this.getReps(16);
    }

    public XCN getOrderingProvider(int rep) {
        XCN retVal = (XCN)this.getTypedField(16, rep);
        return retVal;
    }

    public XCN getObr16_OrderingProvider(int rep) {
        XCN retVal = (XCN)this.getTypedField(16, rep);
        return retVal;
    }

    public int getObr16_OrderingProviderReps() {
        return this.getReps(16);
    }

    public XCN insertOrderingProvider(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(16, rep);
    }

    public XCN insertObr16_OrderingProvider(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(16, rep);
    }

    public XCN removeOrderingProvider(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(16, rep);
    }

    public XCN removeObr16_OrderingProvider(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(16, rep);
    }

    public XTN[] getOrderCallbackPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(17, new XTN[0]);
        return retVal;
    }

    public XTN[] getObr17_OrderCallbackPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(17, new XTN[0]);
        return retVal;
    }

    public int getOrderCallbackPhoneNumberReps() {
        return this.getReps(17);
    }

    public XTN getOrderCallbackPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(17, rep);
        return retVal;
    }

    public XTN getObr17_OrderCallbackPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(17, rep);
        return retVal;
    }

    public int getObr17_OrderCallbackPhoneNumberReps() {
        return this.getReps(17);
    }

    public XTN insertOrderCallbackPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(17, rep);
    }

    public XTN insertObr17_OrderCallbackPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(17, rep);
    }

    public XTN removeOrderCallbackPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(17, rep);
    }

    public XTN removeObr17_OrderCallbackPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(17, rep);
    }

    public ST getPlacerField1() {
        ST retVal = (ST)this.getTypedField(18, 0);
        return retVal;
    }

    public ST getObr18_PlacerField1() {
        ST retVal = (ST)this.getTypedField(18, 0);
        return retVal;
    }

    public ST getPlacerField2() {
        ST retVal = (ST)this.getTypedField(19, 0);
        return retVal;
    }

    public ST getObr19_PlacerField2() {
        ST retVal = (ST)this.getTypedField(19, 0);
        return retVal;
    }

    public ST getFillerField1() {
        ST retVal = (ST)this.getTypedField(20, 0);
        return retVal;
    }

    public ST getObr20_FillerField1() {
        ST retVal = (ST)this.getTypedField(20, 0);
        return retVal;
    }

    public ST getFillerField2() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public ST getObr21_FillerField2() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public TS getResultsRptStatusChngDateTime() {
        TS retVal = (TS)this.getTypedField(22, 0);
        return retVal;
    }

    public TS getObr22_ResultsRptStatusChngDateTime() {
        TS retVal = (TS)this.getTypedField(22, 0);
        return retVal;
    }

    public CM_MOC getChargeToPractice() {
        CM_MOC retVal = (CM_MOC)this.getTypedField(23, 0);
        return retVal;
    }

    public CM_MOC getObr23_ChargeToPractice() {
        CM_MOC retVal = (CM_MOC)this.getTypedField(23, 0);
        return retVal;
    }

    public ID getDiagnosticServiceSectionID() {
        ID retVal = (ID)this.getTypedField(24, 0);
        return retVal;
    }

    public ID getObr24_DiagnosticServiceSectionID() {
        ID retVal = (ID)this.getTypedField(24, 0);
        return retVal;
    }

    public ID getResultStatus() {
        ID retVal = (ID)this.getTypedField(25, 0);
        return retVal;
    }

    public ID getObr25_ResultStatus() {
        ID retVal = (ID)this.getTypedField(25, 0);
        return retVal;
    }

    public CM_PRL getParentResult() {
        CM_PRL retVal = (CM_PRL)this.getTypedField(26, 0);
        return retVal;
    }

    public CM_PRL getObr26_ParentResult() {
        CM_PRL retVal = (CM_PRL)this.getTypedField(26, 0);
        return retVal;
    }

    public TQ getQuantityTiming() {
        TQ retVal = (TQ)this.getTypedField(27, 0);
        return retVal;
    }

    public TQ getObr27_QuantityTiming() {
        TQ retVal = (TQ)this.getTypedField(27, 0);
        return retVal;
    }

    public XCN[] getResultCopiesTo() {
        XCN[] retVal = (XCN[])this.getTypedField(28, new XCN[0]);
        return retVal;
    }

    public XCN[] getObr28_ResultCopiesTo() {
        XCN[] retVal = (XCN[])this.getTypedField(28, new XCN[0]);
        return retVal;
    }

    public int getResultCopiesToReps() {
        return this.getReps(28);
    }

    public XCN getResultCopiesTo(int rep) {
        XCN retVal = (XCN)this.getTypedField(28, rep);
        return retVal;
    }

    public XCN getObr28_ResultCopiesTo(int rep) {
        XCN retVal = (XCN)this.getTypedField(28, rep);
        return retVal;
    }

    public int getObr28_ResultCopiesToReps() {
        return this.getReps(28);
    }

    public XCN insertResultCopiesTo(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(28, rep);
    }

    public XCN insertObr28_ResultCopiesTo(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(28, rep);
    }

    public XCN removeResultCopiesTo(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(28, rep);
    }

    public XCN removeObr28_ResultCopiesTo(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(28, rep);
    }

    public CM_EIP getParentNumber() {
        CM_EIP retVal = (CM_EIP)this.getTypedField(29, 0);
        return retVal;
    }

    public CM_EIP getObr29_ParentNumber() {
        CM_EIP retVal = (CM_EIP)this.getTypedField(29, 0);
        return retVal;
    }

    public ID getTransportationMode() {
        ID retVal = (ID)this.getTypedField(30, 0);
        return retVal;
    }

    public ID getObr30_TransportationMode() {
        ID retVal = (ID)this.getTypedField(30, 0);
        return retVal;
    }

    public CE[] getReasonForStudy() {
        CE[] retVal = (CE[])this.getTypedField(31, new CE[0]);
        return retVal;
    }

    public CE[] getObr31_ReasonForStudy() {
        CE[] retVal = (CE[])this.getTypedField(31, new CE[0]);
        return retVal;
    }

    public int getReasonForStudyReps() {
        return this.getReps(31);
    }

    public CE getReasonForStudy(int rep) {
        CE retVal = (CE)this.getTypedField(31, rep);
        return retVal;
    }

    public CE getObr31_ReasonForStudy(int rep) {
        CE retVal = (CE)this.getTypedField(31, rep);
        return retVal;
    }

    public int getObr31_ReasonForStudyReps() {
        return this.getReps(31);
    }

    public CE insertReasonForStudy(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(31, rep);
    }

    public CE insertObr31_ReasonForStudy(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(31, rep);
    }

    public CE removeReasonForStudy(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(31, rep);
    }

    public CE removeObr31_ReasonForStudy(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(31, rep);
    }

    public CM_NDL getPrincipalResultInterpreter() {
        CM_NDL retVal = (CM_NDL)this.getTypedField(32, 0);
        return retVal;
    }

    public CM_NDL getObr32_PrincipalResultInterpreter() {
        CM_NDL retVal = (CM_NDL)this.getTypedField(32, 0);
        return retVal;
    }

    public CM_NDL[] getAssistantResultInterpreter() {
        CM_NDL[] retVal = (CM_NDL[])this.getTypedField(33, new CM_NDL[0]);
        return retVal;
    }

    public CM_NDL[] getObr33_AssistantResultInterpreter() {
        CM_NDL[] retVal = (CM_NDL[])this.getTypedField(33, new CM_NDL[0]);
        return retVal;
    }

    public int getAssistantResultInterpreterReps() {
        return this.getReps(33);
    }

    public CM_NDL getAssistantResultInterpreter(int rep) {
        CM_NDL retVal = (CM_NDL)this.getTypedField(33, rep);
        return retVal;
    }

    public CM_NDL getObr33_AssistantResultInterpreter(int rep) {
        CM_NDL retVal = (CM_NDL)this.getTypedField(33, rep);
        return retVal;
    }

    public int getObr33_AssistantResultInterpreterReps() {
        return this.getReps(33);
    }

    public CM_NDL insertAssistantResultInterpreter(int rep) throws HL7Exception {
        return (CM_NDL)super.insertRepetition(33, rep);
    }

    public CM_NDL insertObr33_AssistantResultInterpreter(int rep) throws HL7Exception {
        return (CM_NDL)super.insertRepetition(33, rep);
    }

    public CM_NDL removeAssistantResultInterpreter(int rep) throws HL7Exception {
        return (CM_NDL)super.removeRepetition(33, rep);
    }

    public CM_NDL removeObr33_AssistantResultInterpreter(int rep) throws HL7Exception {
        return (CM_NDL)super.removeRepetition(33, rep);
    }

    public CM_NDL[] getTechnician() {
        CM_NDL[] retVal = (CM_NDL[])this.getTypedField(34, new CM_NDL[0]);
        return retVal;
    }

    public CM_NDL[] getObr34_Technician() {
        CM_NDL[] retVal = (CM_NDL[])this.getTypedField(34, new CM_NDL[0]);
        return retVal;
    }

    public int getTechnicianReps() {
        return this.getReps(34);
    }

    public CM_NDL getTechnician(int rep) {
        CM_NDL retVal = (CM_NDL)this.getTypedField(34, rep);
        return retVal;
    }

    public CM_NDL getObr34_Technician(int rep) {
        CM_NDL retVal = (CM_NDL)this.getTypedField(34, rep);
        return retVal;
    }

    public int getObr34_TechnicianReps() {
        return this.getReps(34);
    }

    public CM_NDL insertTechnician(int rep) throws HL7Exception {
        return (CM_NDL)super.insertRepetition(34, rep);
    }

    public CM_NDL insertObr34_Technician(int rep) throws HL7Exception {
        return (CM_NDL)super.insertRepetition(34, rep);
    }

    public CM_NDL removeTechnician(int rep) throws HL7Exception {
        return (CM_NDL)super.removeRepetition(34, rep);
    }

    public CM_NDL removeObr34_Technician(int rep) throws HL7Exception {
        return (CM_NDL)super.removeRepetition(34, rep);
    }

    public CM_NDL[] getTranscriptionist() {
        CM_NDL[] retVal = (CM_NDL[])this.getTypedField(35, new CM_NDL[0]);
        return retVal;
    }

    public CM_NDL[] getObr35_Transcriptionist() {
        CM_NDL[] retVal = (CM_NDL[])this.getTypedField(35, new CM_NDL[0]);
        return retVal;
    }

    public int getTranscriptionistReps() {
        return this.getReps(35);
    }

    public CM_NDL getTranscriptionist(int rep) {
        CM_NDL retVal = (CM_NDL)this.getTypedField(35, rep);
        return retVal;
    }

    public CM_NDL getObr35_Transcriptionist(int rep) {
        CM_NDL retVal = (CM_NDL)this.getTypedField(35, rep);
        return retVal;
    }

    public int getObr35_TranscriptionistReps() {
        return this.getReps(35);
    }

    public CM_NDL insertTranscriptionist(int rep) throws HL7Exception {
        return (CM_NDL)super.insertRepetition(35, rep);
    }

    public CM_NDL insertObr35_Transcriptionist(int rep) throws HL7Exception {
        return (CM_NDL)super.insertRepetition(35, rep);
    }

    public CM_NDL removeTranscriptionist(int rep) throws HL7Exception {
        return (CM_NDL)super.removeRepetition(35, rep);
    }

    public CM_NDL removeObr35_Transcriptionist(int rep) throws HL7Exception {
        return (CM_NDL)super.removeRepetition(35, rep);
    }

    public TS getScheduledDateTime() {
        TS retVal = (TS)this.getTypedField(36, 0);
        return retVal;
    }

    public TS getObr36_ScheduledDateTime() {
        TS retVal = (TS)this.getTypedField(36, 0);
        return retVal;
    }

    public NM getNumberOfSampleContainers() {
        NM retVal = (NM)this.getTypedField(37, 0);
        return retVal;
    }

    public NM getObr37_NumberOfSampleContainers() {
        NM retVal = (NM)this.getTypedField(37, 0);
        return retVal;
    }

    public CE[] getTransportLogisticsOfCollectedSample() {
        CE[] retVal = (CE[])this.getTypedField(38, new CE[0]);
        return retVal;
    }

    public CE[] getObr38_TransportLogisticsOfCollectedSample() {
        CE[] retVal = (CE[])this.getTypedField(38, new CE[0]);
        return retVal;
    }

    public int getTransportLogisticsOfCollectedSampleReps() {
        return this.getReps(38);
    }

    public CE getTransportLogisticsOfCollectedSample(int rep) {
        CE retVal = (CE)this.getTypedField(38, rep);
        return retVal;
    }

    public CE getObr38_TransportLogisticsOfCollectedSample(int rep) {
        CE retVal = (CE)this.getTypedField(38, rep);
        return retVal;
    }

    public int getObr38_TransportLogisticsOfCollectedSampleReps() {
        return this.getReps(38);
    }

    public CE insertTransportLogisticsOfCollectedSample(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(38, rep);
    }

    public CE insertObr38_TransportLogisticsOfCollectedSample(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(38, rep);
    }

    public CE removeTransportLogisticsOfCollectedSample(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(38, rep);
    }

    public CE removeObr38_TransportLogisticsOfCollectedSample(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(38, rep);
    }

    public CE[] getCollectorSComment() {
        CE[] retVal = (CE[])this.getTypedField(39, new CE[0]);
        return retVal;
    }

    public CE[] getObr39_CollectorSComment() {
        CE[] retVal = (CE[])this.getTypedField(39, new CE[0]);
        return retVal;
    }

    public int getCollectorSCommentReps() {
        return this.getReps(39);
    }

    public CE getCollectorSComment(int rep) {
        CE retVal = (CE)this.getTypedField(39, rep);
        return retVal;
    }

    public CE getObr39_CollectorSComment(int rep) {
        CE retVal = (CE)this.getTypedField(39, rep);
        return retVal;
    }

    public int getObr39_CollectorSCommentReps() {
        return this.getReps(39);
    }

    public CE insertCollectorSComment(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(39, rep);
    }

    public CE insertObr39_CollectorSComment(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(39, rep);
    }

    public CE removeCollectorSComment(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(39, rep);
    }

    public CE removeObr39_CollectorSComment(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(39, rep);
    }

    public CE getTransportArrangementResponsibility() {
        CE retVal = (CE)this.getTypedField(40, 0);
        return retVal;
    }

    public CE getObr40_TransportArrangementResponsibility() {
        CE retVal = (CE)this.getTypedField(40, 0);
        return retVal;
    }

    public ID getTransportArranged() {
        ID retVal = (ID)this.getTypedField(41, 0);
        return retVal;
    }

    public ID getObr41_TransportArranged() {
        ID retVal = (ID)this.getTypedField(41, 0);
        return retVal;
    }

    public ID getEscortRequired() {
        ID retVal = (ID)this.getTypedField(42, 0);
        return retVal;
    }

    public ID getObr42_EscortRequired() {
        ID retVal = (ID)this.getTypedField(42, 0);
        return retVal;
    }

    public CE[] getPlannedPatientTransportComment() {
        CE[] retVal = (CE[])this.getTypedField(43, new CE[0]);
        return retVal;
    }

    public CE[] getObr43_PlannedPatientTransportComment() {
        CE[] retVal = (CE[])this.getTypedField(43, new CE[0]);
        return retVal;
    }

    public int getPlannedPatientTransportCommentReps() {
        return this.getReps(43);
    }

    public CE getPlannedPatientTransportComment(int rep) {
        CE retVal = (CE)this.getTypedField(43, rep);
        return retVal;
    }

    public CE getObr43_PlannedPatientTransportComment(int rep) {
        CE retVal = (CE)this.getTypedField(43, rep);
        return retVal;
    }

    public int getObr43_PlannedPatientTransportCommentReps() {
        return this.getReps(43);
    }

    public CE insertPlannedPatientTransportComment(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(43, rep);
    }

    public CE insertObr43_PlannedPatientTransportComment(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(43, rep);
    }

    public CE removePlannedPatientTransportComment(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(43, rep);
    }

    public CE removeObr43_PlannedPatientTransportComment(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(43, rep);
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new EI(this.getMessage());
            }
            case 2: {
                return new EI(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
            case 4: {
                return new ID(this.getMessage(), new Integer(0));
            }
            case 5: {
                return new TS(this.getMessage());
            }
            case 6: {
                return new TS(this.getMessage());
            }
            case 7: {
                return new TS(this.getMessage());
            }
            case 8: {
                return new CQ(this.getMessage());
            }
            case 9: {
                return new XCN(this.getMessage());
            }
            case 10: {
                return new ID(this.getMessage(), new Integer(65));
            }
            case 11: {
                return new CE(this.getMessage());
            }
            case 12: {
                return new ST(this.getMessage());
            }
            case 13: {
                return new TS(this.getMessage());
            }
            case 14: {
                return new CM_SPS(this.getMessage());
            }
            case 15: {
                return new XCN(this.getMessage());
            }
            case 16: {
                return new XTN(this.getMessage());
            }
            case 17: {
                return new ST(this.getMessage());
            }
            case 18: {
                return new ST(this.getMessage());
            }
            case 19: {
                return new ST(this.getMessage());
            }
            case 20: {
                return new ST(this.getMessage());
            }
            case 21: {
                return new TS(this.getMessage());
            }
            case 22: {
                return new CM_MOC(this.getMessage());
            }
            case 23: {
                return new ID(this.getMessage(), new Integer(74));
            }
            case 24: {
                return new ID(this.getMessage(), new Integer(123));
            }
            case 25: {
                return new CM_PRL(this.getMessage());
            }
            case 26: {
                return new TQ(this.getMessage());
            }
            case 27: {
                return new XCN(this.getMessage());
            }
            case 28: {
                return new CM_EIP(this.getMessage());
            }
            case 29: {
                return new ID(this.getMessage(), new Integer(124));
            }
            case 30: {
                return new CE(this.getMessage());
            }
            case 31: {
                return new CM_NDL(this.getMessage());
            }
            case 32: {
                return new CM_NDL(this.getMessage());
            }
            case 33: {
                return new CM_NDL(this.getMessage());
            }
            case 34: {
                return new CM_NDL(this.getMessage());
            }
            case 35: {
                return new TS(this.getMessage());
            }
            case 36: {
                return new NM(this.getMessage());
            }
            case 37: {
                return new CE(this.getMessage());
            }
            case 38: {
                return new CE(this.getMessage());
            }
            case 39: {
                return new CE(this.getMessage());
            }
            case 40: {
                return new ID(this.getMessage(), new Integer(224));
            }
            case 41: {
                return new ID(this.getMessage(), new Integer(225));
            }
            case 42: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

