/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.IS;
import ca.uhn.hl7v2.model.v23.datatype.PL;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class LCC
extends AbstractSegment {
    public LCC(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PL.class, true, 1, 200, new Object[]{this.getMessage()}, "Primary Key Value");
            this.add(IS.class, true, 1, 10, new Object[]{this.getMessage(), new Integer(264)}, "Location Department");
            this.add(CE.class, false, 0, 60, new Object[]{this.getMessage()}, "Accommodation Type");
            this.add(CE.class, true, 0, 60, new Object[]{this.getMessage()}, "Charge Code");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating LCC - this is probably a bug in the source code generator.", e);
        }
    }

    public PL getPrimaryKeyValue() {
        PL retVal = (PL)this.getTypedField(1, 0);
        return retVal;
    }

    public PL getLcc1_PrimaryKeyValue() {
        PL retVal = (PL)this.getTypedField(1, 0);
        return retVal;
    }

    public IS getLocationDepartment() {
        IS retVal = (IS)this.getTypedField(2, 0);
        return retVal;
    }

    public IS getLcc2_LocationDepartment() {
        IS retVal = (IS)this.getTypedField(2, 0);
        return retVal;
    }

    public CE[] getAccommodationType() {
        CE[] retVal = (CE[])this.getTypedField(3, new CE[0]);
        return retVal;
    }

    public CE[] getLcc3_AccommodationType() {
        CE[] retVal = (CE[])this.getTypedField(3, new CE[0]);
        return retVal;
    }

    public int getAccommodationTypeReps() {
        return this.getReps(3);
    }

    public CE getAccommodationType(int rep) {
        CE retVal = (CE)this.getTypedField(3, rep);
        return retVal;
    }

    public CE getLcc3_AccommodationType(int rep) {
        CE retVal = (CE)this.getTypedField(3, rep);
        return retVal;
    }

    public int getLcc3_AccommodationTypeReps() {
        return this.getReps(3);
    }

    public CE insertAccommodationType(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(3, rep);
    }

    public CE insertLcc3_AccommodationType(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(3, rep);
    }

    public CE removeAccommodationType(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(3, rep);
    }

    public CE removeLcc3_AccommodationType(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(3, rep);
    }

    public CE[] getChargeCode() {
        CE[] retVal = (CE[])this.getTypedField(4, new CE[0]);
        return retVal;
    }

    public CE[] getLcc4_ChargeCode() {
        CE[] retVal = (CE[])this.getTypedField(4, new CE[0]);
        return retVal;
    }

    public int getChargeCodeReps() {
        return this.getReps(4);
    }

    public CE getChargeCode(int rep) {
        CE retVal = (CE)this.getTypedField(4, rep);
        return retVal;
    }

    public CE getLcc4_ChargeCode(int rep) {
        CE retVal = (CE)this.getTypedField(4, rep);
        return retVal;
    }

    public int getLcc4_ChargeCodeReps() {
        return this.getReps(4);
    }

    public CE insertChargeCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(4, rep);
    }

    public CE insertLcc4_ChargeCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(4, rep);
    }

    public CE removeChargeCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(4, rep);
    }

    public CE removeLcc4_ChargeCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(4, rep);
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new PL(this.getMessage());
            }
            case 1: {
                return new IS(this.getMessage(), new Integer(264));
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

