/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v23.group.SIU_S22_PATIENT;
import ca.uhn.hl7v2.model.v23.group.SIU_S22_RESOURCES;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.model.v23.segment.NTE;
import ca.uhn.hl7v2.model.v23.segment.SCH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class SIU_S22
extends AbstractMessage {
    public SIU_S22() {
        this(new DefaultModelClassFactory());
    }

    public SIU_S22(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SCH.class, true, false);
            this.add(NTE.class, false, true);
            this.add(SIU_S22_PATIENT.class, false, true);
            this.add(SIU_S22_RESOURCES.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating SIU_S22 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.3";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SCH getSCH() {
        return this.getTyped("SCH", SCH.class);
    }

    public NTE getNTE() {
        return this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public SIU_S22_PATIENT getPATIENT() {
        return this.getTyped("PATIENT", SIU_S22_PATIENT.class);
    }

    public SIU_S22_PATIENT getPATIENT(int rep) {
        return this.getTyped("PATIENT", rep, SIU_S22_PATIENT.class);
    }

    public int getPATIENTReps() {
        return this.getReps("PATIENT");
    }

    public List<SIU_S22_PATIENT> getPATIENTAll() throws HL7Exception {
        return this.getAllAsList("PATIENT", SIU_S22_PATIENT.class);
    }

    public void insertPATIENT(SIU_S22_PATIENT structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT", structure, rep);
    }

    public SIU_S22_PATIENT insertPATIENT(int rep) throws HL7Exception {
        return (SIU_S22_PATIENT)super.insertRepetition("PATIENT", rep);
    }

    public SIU_S22_PATIENT removePATIENT(int rep) throws HL7Exception {
        return (SIU_S22_PATIENT)super.removeRepetition("PATIENT", rep);
    }

    public SIU_S22_RESOURCES getRESOURCES() {
        return this.getTyped("RESOURCES", SIU_S22_RESOURCES.class);
    }

    public SIU_S22_RESOURCES getRESOURCES(int rep) {
        return this.getTyped("RESOURCES", rep, SIU_S22_RESOURCES.class);
    }

    public int getRESOURCESReps() {
        return this.getReps("RESOURCES");
    }

    public List<SIU_S22_RESOURCES> getRESOURCESAll() throws HL7Exception {
        return this.getAllAsList("RESOURCES", SIU_S22_RESOURCES.class);
    }

    public void insertRESOURCES(SIU_S22_RESOURCES structure, int rep) throws HL7Exception {
        super.insertRepetition("RESOURCES", structure, rep);
    }

    public SIU_S22_RESOURCES insertRESOURCES(int rep) throws HL7Exception {
        return (SIU_S22_RESOURCES)super.insertRepetition("RESOURCES", rep);
    }

    public SIU_S22_RESOURCES removeRESOURCES(int rep) throws HL7Exception {
        return (SIU_S22_RESOURCES)super.removeRepetition("RESOURCES", rep);
    }
}

