/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v22.datatype.CM_MSG;
import ca.uhn.hl7v2.model.v22.datatype.ID;
import ca.uhn.hl7v2.model.v22.datatype.NM;
import ca.uhn.hl7v2.model.v22.datatype.ST;
import ca.uhn.hl7v2.model.v22.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class MSH
extends AbstractSegment {
    public MSH(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ST.class, true, 1, 1, new Object[]{this.getMessage()}, "Field separator");
            this.add(ST.class, true, 1, 4, new Object[]{this.getMessage()}, "Encoding characters");
            this.add(ST.class, false, 1, 15, new Object[]{this.getMessage()}, "Sending application");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "Sending facility");
            this.add(ST.class, false, 1, 30, new Object[]{this.getMessage()}, "Receiving application");
            this.add(ST.class, false, 1, 30, new Object[]{this.getMessage()}, "Receiving facility");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Date / Time of message");
            this.add(ST.class, false, 1, 40, new Object[]{this.getMessage()}, "Security");
            this.add(CM_MSG.class, true, 1, 7, new Object[]{this.getMessage()}, "Message type");
            this.add(ST.class, true, 1, 20, new Object[]{this.getMessage()}, "Message Control ID");
            this.add(ID.class, true, 1, 1, new Object[]{this.getMessage(), new Integer(103)}, "Processing ID");
            this.add(ID.class, true, 1, 8, new Object[]{this.getMessage(), new Integer(104)}, "Version ID");
            this.add(NM.class, false, 1, 15, new Object[]{this.getMessage()}, "Sequence number");
            this.add(ST.class, false, 1, 180, new Object[]{this.getMessage()}, "Continuation pointer");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(155)}, "Accept acknowledgement type");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(155)}, "Application acknowledgement type");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(0)}, "Country code");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MSH - this is probably a bug in the source code generator.", e);
        }
    }

    public ST getFieldSeparator() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getMsh1_FieldSeparator() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getEncodingCharacters() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getMsh2_EncodingCharacters() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getSendingApplication() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getMsh3_SendingApplication() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getSendingFacility() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getMsh4_SendingFacility() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getReceivingApplication() {
        ST retVal = (ST)this.getTypedField(5, 0);
        return retVal;
    }

    public ST getMsh5_ReceivingApplication() {
        ST retVal = (ST)this.getTypedField(5, 0);
        return retVal;
    }

    public ST getReceivingFacility() {
        ST retVal = (ST)this.getTypedField(6, 0);
        return retVal;
    }

    public ST getMsh6_ReceivingFacility() {
        ST retVal = (ST)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getDateTimeOfMessage() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public TS getMsh7_DateTimeOfMessage() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public ST getSecurity() {
        ST retVal = (ST)this.getTypedField(8, 0);
        return retVal;
    }

    public ST getMsh8_Security() {
        ST retVal = (ST)this.getTypedField(8, 0);
        return retVal;
    }

    public CM_MSG getMessageType() {
        CM_MSG retVal = (CM_MSG)this.getTypedField(9, 0);
        return retVal;
    }

    public CM_MSG getMsh9_MessageType() {
        CM_MSG retVal = (CM_MSG)this.getTypedField(9, 0);
        return retVal;
    }

    public ST getMessageControlID() {
        ST retVal = (ST)this.getTypedField(10, 0);
        return retVal;
    }

    public ST getMsh10_MessageControlID() {
        ST retVal = (ST)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getProcessingID() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getMsh11_ProcessingID() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getVersionID() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public ID getMsh12_VersionID() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public NM getSequenceNumber() {
        NM retVal = (NM)this.getTypedField(13, 0);
        return retVal;
    }

    public NM getMsh13_SequenceNumber() {
        NM retVal = (NM)this.getTypedField(13, 0);
        return retVal;
    }

    public ST getContinuationPointer() {
        ST retVal = (ST)this.getTypedField(14, 0);
        return retVal;
    }

    public ST getMsh14_ContinuationPointer() {
        ST retVal = (ST)this.getTypedField(14, 0);
        return retVal;
    }

    public ID getAcceptAcknowledgementType() {
        ID retVal = (ID)this.getTypedField(15, 0);
        return retVal;
    }

    public ID getMsh15_AcceptAcknowledgementType() {
        ID retVal = (ID)this.getTypedField(15, 0);
        return retVal;
    }

    public ID getApplicationAcknowledgementType() {
        ID retVal = (ID)this.getTypedField(16, 0);
        return retVal;
    }

    public ID getMsh16_ApplicationAcknowledgementType() {
        ID retVal = (ID)this.getTypedField(16, 0);
        return retVal;
    }

    public ID getCountryCode() {
        ID retVal = (ID)this.getTypedField(17, 0);
        return retVal;
    }

    public ID getMsh17_CountryCode() {
        ID retVal = (ID)this.getTypedField(17, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ST(this.getMessage());
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new ST(this.getMessage());
            }
            case 4: {
                return new ST(this.getMessage());
            }
            case 5: {
                return new ST(this.getMessage());
            }
            case 6: {
                return new TS(this.getMessage());
            }
            case 7: {
                return new ST(this.getMessage());
            }
            case 8: {
                return new CM_MSG(this.getMessage());
            }
            case 9: {
                return new ST(this.getMessage());
            }
            case 10: {
                return new ID(this.getMessage(), new Integer(103));
            }
            case 11: {
                return new ID(this.getMessage(), new Integer(104));
            }
            case 12: {
                return new NM(this.getMessage());
            }
            case 13: {
                return new ST(this.getMessage());
            }
            case 14: {
                return new ID(this.getMessage(), new Integer(155));
            }
            case 15: {
                return new ID(this.getMessage(), new Integer(155));
            }
            case 16: {
                return new ID(this.getMessage(), new Integer(0));
            }
        }
        return null;
    }
}

