/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v22.datatype.AD;
import ca.uhn.hl7v2.model.v22.datatype.CK;
import ca.uhn.hl7v2.model.v22.datatype.DT;
import ca.uhn.hl7v2.model.v22.datatype.ID;
import ca.uhn.hl7v2.model.v22.datatype.NM;
import ca.uhn.hl7v2.model.v22.datatype.PN;
import ca.uhn.hl7v2.model.v22.datatype.SI;
import ca.uhn.hl7v2.model.v22.datatype.ST;
import ca.uhn.hl7v2.model.v22.datatype.TN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class GT1
extends AbstractSegment {
    public GT1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID - guarantor");
            this.add(CK.class, false, 1, 20, new Object[]{this.getMessage()}, "Guarantor number");
            this.add(PN.class, true, 1, 48, new Object[]{this.getMessage()}, "Guarantor name");
            this.add(PN.class, false, 1, 48, new Object[]{this.getMessage()}, "Guarantor spouse name");
            this.add(AD.class, false, 1, 106, new Object[]{this.getMessage()}, "Guarantor address");
            this.add(TN.class, false, 3, 40, new Object[]{this.getMessage()}, "Guarantor phone number - home");
            this.add(TN.class, false, 3, 40, new Object[]{this.getMessage()}, "Guarantor phone number - business");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Guarantor date of birth");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(1)}, "Guarantor sex");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(68)}, "Guarantor type");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(63)}, "Guarantor relationship");
            this.add(ST.class, false, 1, 11, new Object[]{this.getMessage()}, "Guarantor social security number");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Guarantor date - begin");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Guarantor date - end");
            this.add(NM.class, false, 1, 2, new Object[]{this.getMessage()}, "Guarantor priority");
            this.add(ST.class, false, 1, 45, new Object[]{this.getMessage()}, "Guarantor employer name");
            this.add(AD.class, false, 1, 106, new Object[]{this.getMessage()}, "Guarantor employer address");
            this.add(TN.class, false, 3, 40, new Object[]{this.getMessage()}, "Guarantor employ phone number");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "Guarantor employee ID number");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(66)}, "Guarantor employment status");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage()}, "Guarantor organization");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating GT1 - this is probably a bug in the source code generator.", e);
        }
    }

    public SI getSetIDGuarantor() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getGt11_SetIDGuarantor() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public CK getGuarantorNumber() {
        CK retVal = (CK)this.getTypedField(2, 0);
        return retVal;
    }

    public CK getGt12_GuarantorNumber() {
        CK retVal = (CK)this.getTypedField(2, 0);
        return retVal;
    }

    public PN getGuarantorName() {
        PN retVal = (PN)this.getTypedField(3, 0);
        return retVal;
    }

    public PN getGt13_GuarantorName() {
        PN retVal = (PN)this.getTypedField(3, 0);
        return retVal;
    }

    public PN getGuarantorSpouseName() {
        PN retVal = (PN)this.getTypedField(4, 0);
        return retVal;
    }

    public PN getGt14_GuarantorSpouseName() {
        PN retVal = (PN)this.getTypedField(4, 0);
        return retVal;
    }

    public AD getGuarantorAddress() {
        AD retVal = (AD)this.getTypedField(5, 0);
        return retVal;
    }

    public AD getGt15_GuarantorAddress() {
        AD retVal = (AD)this.getTypedField(5, 0);
        return retVal;
    }

    public TN[] getGuarantorPhoneNumberHome() {
        TN[] retVal = (TN[])this.getTypedField(6, new TN[0]);
        return retVal;
    }

    public TN[] getGt16_GuarantorPhoneNumberHome() {
        TN[] retVal = (TN[])this.getTypedField(6, new TN[0]);
        return retVal;
    }

    public int getGuarantorPhoneNumberHomeReps() {
        return this.getReps(6);
    }

    public TN getGuarantorPhoneNumberHome(int rep) {
        TN retVal = (TN)this.getTypedField(6, rep);
        return retVal;
    }

    public TN getGt16_GuarantorPhoneNumberHome(int rep) {
        TN retVal = (TN)this.getTypedField(6, rep);
        return retVal;
    }

    public int getGt16_GuarantorPhoneNumberHomeReps() {
        return this.getReps(6);
    }

    public TN insertGuarantorPhoneNumberHome(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(6, rep);
    }

    public TN insertGt16_GuarantorPhoneNumberHome(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(6, rep);
    }

    public TN removeGuarantorPhoneNumberHome(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(6, rep);
    }

    public TN removeGt16_GuarantorPhoneNumberHome(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(6, rep);
    }

    public TN[] getGuarantorPhoneNumberBusiness() {
        TN[] retVal = (TN[])this.getTypedField(7, new TN[0]);
        return retVal;
    }

    public TN[] getGt17_GuarantorPhoneNumberBusiness() {
        TN[] retVal = (TN[])this.getTypedField(7, new TN[0]);
        return retVal;
    }

    public int getGuarantorPhoneNumberBusinessReps() {
        return this.getReps(7);
    }

    public TN getGuarantorPhoneNumberBusiness(int rep) {
        TN retVal = (TN)this.getTypedField(7, rep);
        return retVal;
    }

    public TN getGt17_GuarantorPhoneNumberBusiness(int rep) {
        TN retVal = (TN)this.getTypedField(7, rep);
        return retVal;
    }

    public int getGt17_GuarantorPhoneNumberBusinessReps() {
        return this.getReps(7);
    }

    public TN insertGuarantorPhoneNumberBusiness(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(7, rep);
    }

    public TN insertGt17_GuarantorPhoneNumberBusiness(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(7, rep);
    }

    public TN removeGuarantorPhoneNumberBusiness(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(7, rep);
    }

    public TN removeGt17_GuarantorPhoneNumberBusiness(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(7, rep);
    }

    public DT getGuarantorDateOfBirth() {
        DT retVal = (DT)this.getTypedField(8, 0);
        return retVal;
    }

    public DT getGt18_GuarantorDateOfBirth() {
        DT retVal = (DT)this.getTypedField(8, 0);
        return retVal;
    }

    public ID getGuarantorSex() {
        ID retVal = (ID)this.getTypedField(9, 0);
        return retVal;
    }

    public ID getGt19_GuarantorSex() {
        ID retVal = (ID)this.getTypedField(9, 0);
        return retVal;
    }

    public ID getGuarantorType() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getGt110_GuarantorType() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getGuarantorRelationship() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getGt111_GuarantorRelationship() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public ST getGuarantorSocialSecurityNumber() {
        ST retVal = (ST)this.getTypedField(12, 0);
        return retVal;
    }

    public ST getGt112_GuarantorSocialSecurityNumber() {
        ST retVal = (ST)this.getTypedField(12, 0);
        return retVal;
    }

    public DT getGuarantorDateBegin() {
        DT retVal = (DT)this.getTypedField(13, 0);
        return retVal;
    }

    public DT getGt113_GuarantorDateBegin() {
        DT retVal = (DT)this.getTypedField(13, 0);
        return retVal;
    }

    public DT getGuarantorDateEnd() {
        DT retVal = (DT)this.getTypedField(14, 0);
        return retVal;
    }

    public DT getGt114_GuarantorDateEnd() {
        DT retVal = (DT)this.getTypedField(14, 0);
        return retVal;
    }

    public NM getGuarantorPriority() {
        NM retVal = (NM)this.getTypedField(15, 0);
        return retVal;
    }

    public NM getGt115_GuarantorPriority() {
        NM retVal = (NM)this.getTypedField(15, 0);
        return retVal;
    }

    public ST getGuarantorEmployerName() {
        ST retVal = (ST)this.getTypedField(16, 0);
        return retVal;
    }

    public ST getGt116_GuarantorEmployerName() {
        ST retVal = (ST)this.getTypedField(16, 0);
        return retVal;
    }

    public AD getGuarantorEmployerAddress() {
        AD retVal = (AD)this.getTypedField(17, 0);
        return retVal;
    }

    public AD getGt117_GuarantorEmployerAddress() {
        AD retVal = (AD)this.getTypedField(17, 0);
        return retVal;
    }

    public TN[] getGuarantorEmployPhoneNumber() {
        TN[] retVal = (TN[])this.getTypedField(18, new TN[0]);
        return retVal;
    }

    public TN[] getGt118_GuarantorEmployPhoneNumber() {
        TN[] retVal = (TN[])this.getTypedField(18, new TN[0]);
        return retVal;
    }

    public int getGuarantorEmployPhoneNumberReps() {
        return this.getReps(18);
    }

    public TN getGuarantorEmployPhoneNumber(int rep) {
        TN retVal = (TN)this.getTypedField(18, rep);
        return retVal;
    }

    public TN getGt118_GuarantorEmployPhoneNumber(int rep) {
        TN retVal = (TN)this.getTypedField(18, rep);
        return retVal;
    }

    public int getGt118_GuarantorEmployPhoneNumberReps() {
        return this.getReps(18);
    }

    public TN insertGuarantorEmployPhoneNumber(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(18, rep);
    }

    public TN insertGt118_GuarantorEmployPhoneNumber(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(18, rep);
    }

    public TN removeGuarantorEmployPhoneNumber(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(18, rep);
    }

    public TN removeGt118_GuarantorEmployPhoneNumber(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(18, rep);
    }

    public ST getGuarantorEmployeeIDNumber() {
        ST retVal = (ST)this.getTypedField(19, 0);
        return retVal;
    }

    public ST getGt119_GuarantorEmployeeIDNumber() {
        ST retVal = (ST)this.getTypedField(19, 0);
        return retVal;
    }

    public ID getGuarantorEmploymentStatus() {
        ID retVal = (ID)this.getTypedField(20, 0);
        return retVal;
    }

    public ID getGt120_GuarantorEmploymentStatus() {
        ID retVal = (ID)this.getTypedField(20, 0);
        return retVal;
    }

    public ST getGuarantorOrganization() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public ST getGt121_GuarantorOrganization() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CK(this.getMessage());
            }
            case 2: {
                return new PN(this.getMessage());
            }
            case 3: {
                return new PN(this.getMessage());
            }
            case 4: {
                return new AD(this.getMessage());
            }
            case 5: {
                return new TN(this.getMessage());
            }
            case 6: {
                return new TN(this.getMessage());
            }
            case 7: {
                return new DT(this.getMessage());
            }
            case 8: {
                return new ID(this.getMessage(), new Integer(1));
            }
            case 9: {
                return new ID(this.getMessage(), new Integer(68));
            }
            case 10: {
                return new ID(this.getMessage(), new Integer(63));
            }
            case 11: {
                return new ST(this.getMessage());
            }
            case 12: {
                return new DT(this.getMessage());
            }
            case 13: {
                return new DT(this.getMessage());
            }
            case 14: {
                return new NM(this.getMessage());
            }
            case 15: {
                return new ST(this.getMessage());
            }
            case 16: {
                return new AD(this.getMessage());
            }
            case 17: {
                return new TN(this.getMessage());
            }
            case 18: {
                return new ST(this.getMessage());
            }
            case 19: {
                return new ID(this.getMessage(), new Integer(66));
            }
            case 20: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

