/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v21.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v21.datatype.CN;
import ca.uhn.hl7v2.model.v21.datatype.ID;
import ca.uhn.hl7v2.model.v21.datatype.NM;
import ca.uhn.hl7v2.model.v21.datatype.SI;
import ca.uhn.hl7v2.model.v21.datatype.ST;
import ca.uhn.hl7v2.model.v21.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PR1
extends AbstractSegment {
    public PR1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 0, 4, new Object[]{this.getMessage()}, "SET ID - PROCEDURE");
            this.add(ID.class, true, 1, 2, new Object[]{this.getMessage(), new Integer(89)}, "PROCEDURE CODING METHOD.");
            this.add(ID.class, true, 1, 10, new Object[]{this.getMessage(), new Integer(88)}, "PROCEDURE CODE");
            this.add(ST.class, false, 1, 40, new Object[]{this.getMessage()}, "PROCEDURE DESCRIPTION");
            this.add(TS.class, true, 1, 19, new Object[]{this.getMessage()}, "PROCEDURE DATE/TIME");
            this.add(ID.class, true, 1, 2, new Object[]{this.getMessage(), new Integer(90)}, "PROCEDURE TYPE");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "PROCEDURE MINUTES");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage()}, "ANESTHESIOLOGIST");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(19)}, "ANESTHESIA CODE");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "ANESTHESIA MINUTES");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage()}, "SURGEON");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage()}, "RESIDENT CODE");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(59)}, "CONSENT CODE");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PR1 - this is probably a bug in the source code generator.", e);
        }
    }

    public SI[] getSETIDPROCEDURE() {
        SI[] retVal = (SI[])this.getTypedField(1, new SI[0]);
        return retVal;
    }

    public SI[] getPr11_SETIDPROCEDURE() {
        SI[] retVal = (SI[])this.getTypedField(1, new SI[0]);
        return retVal;
    }

    public int getSETIDPROCEDUREReps() {
        return this.getReps(1);
    }

    public SI getSETIDPROCEDURE(int rep) {
        SI retVal = (SI)this.getTypedField(1, rep);
        return retVal;
    }

    public SI getPr11_SETIDPROCEDURE(int rep) {
        SI retVal = (SI)this.getTypedField(1, rep);
        return retVal;
    }

    public int getPr11_SETIDPROCEDUREReps() {
        return this.getReps(1);
    }

    public SI insertSETIDPROCEDURE(int rep) throws HL7Exception {
        return (SI)super.insertRepetition(1, rep);
    }

    public SI insertPr11_SETIDPROCEDURE(int rep) throws HL7Exception {
        return (SI)super.insertRepetition(1, rep);
    }

    public SI removeSETIDPROCEDURE(int rep) throws HL7Exception {
        return (SI)super.removeRepetition(1, rep);
    }

    public SI removePr11_SETIDPROCEDURE(int rep) throws HL7Exception {
        return (SI)super.removeRepetition(1, rep);
    }

    public ID getPROCEDURECODINGMETHOD() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getPr12_PROCEDURECODINGMETHOD() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getPROCEDURECODE() {
        ID retVal = (ID)this.getTypedField(3, 0);
        return retVal;
    }

    public ID getPr13_PROCEDURECODE() {
        ID retVal = (ID)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getPROCEDUREDESCRIPTION() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getPr14_PROCEDUREDESCRIPTION() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public TS getPROCEDUREDATETIME() {
        TS retVal = (TS)this.getTypedField(5, 0);
        return retVal;
    }

    public TS getPr15_PROCEDUREDATETIME() {
        TS retVal = (TS)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getPROCEDURETYPE() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public ID getPr16_PROCEDURETYPE() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getPROCEDUREMINUTES() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public NM getPr17_PROCEDUREMINUTES() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public CN getANESTHESIOLOGIST() {
        CN retVal = (CN)this.getTypedField(8, 0);
        return retVal;
    }

    public CN getPr18_ANESTHESIOLOGIST() {
        CN retVal = (CN)this.getTypedField(8, 0);
        return retVal;
    }

    public ID getANESTHESIACODE() {
        ID retVal = (ID)this.getTypedField(9, 0);
        return retVal;
    }

    public ID getPr19_ANESTHESIACODE() {
        ID retVal = (ID)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getANESTHESIAMINUTES() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public NM getPr110_ANESTHESIAMINUTES() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public CN getSURGEON() {
        CN retVal = (CN)this.getTypedField(11, 0);
        return retVal;
    }

    public CN getPr111_SURGEON() {
        CN retVal = (CN)this.getTypedField(11, 0);
        return retVal;
    }

    public CN getRESIDENTCODE() {
        CN retVal = (CN)this.getTypedField(12, 0);
        return retVal;
    }

    public CN getPr112_RESIDENTCODE() {
        CN retVal = (CN)this.getTypedField(12, 0);
        return retVal;
    }

    public ID getCONSENTCODE() {
        ID retVal = (ID)this.getTypedField(13, 0);
        return retVal;
    }

    public ID getPr113_CONSENTCODE() {
        ID retVal = (ID)this.getTypedField(13, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(89));
            }
            case 2: {
                return new ID(this.getMessage(), new Integer(88));
            }
            case 3: {
                return new ST(this.getMessage());
            }
            case 4: {
                return new TS(this.getMessage());
            }
            case 5: {
                return new ID(this.getMessage(), new Integer(90));
            }
            case 6: {
                return new NM(this.getMessage());
            }
            case 7: {
                return new CN(this.getMessage());
            }
            case 8: {
                return new ID(this.getMessage(), new Integer(19));
            }
            case 9: {
                return new NM(this.getMessage());
            }
            case 10: {
                return new CN(this.getMessage());
            }
            case 11: {
                return new CN(this.getMessage());
            }
            case 12: {
                return new ID(this.getMessage(), new Integer(59));
            }
        }
        return null;
    }
}

