/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1.xml;

import java.io.OutputStream;
import java.util.Map;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public final class XmlWriter {
    private final OutputStream os;
    private final XMLEventWriter eventWriter;
    private final XMLEventFactory eventFactory;
    private final XMLEvent newline;

    public XmlWriter(OutputStream os) throws XMLStreamException {
        this.os = os;
        if (os == null) {
            throw new NullPointerException("os");
        }
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        this.eventWriter = outputFactory.createXMLEventWriter(this.os);
        this.eventFactory = XMLEventFactory.newInstance();
        this.newline = this.eventFactory.createDTD("\n");
        StartDocument startDocument = this.eventFactory.createStartDocument();
        this.eventWriter.add(startDocument);
        this.eventWriter.add(this.newline);
    }

    public XmlWriter appendAndCloseElement(String localName, Map<String, String> data) throws XMLStreamException {
        this.appendElement(localName, data);
        this.closeElement(localName);
        return this;
    }

    public XmlWriter closeElement(String localName) throws XMLStreamException {
        if (localName == null) {
            throw new NullPointerException("localName");
        }
        this.eventWriter.add(this.eventFactory.createEndElement("", "", localName));
        this.eventWriter.add(this.newline);
        return this;
    }

    public XmlWriter appendElement(String localName, Map<String, String> data) throws XMLStreamException {
        if (localName == null) {
            throw new NullPointerException("localName");
        }
        if (data == null) {
            throw new NullPointerException("data");
        }
        StartElement configStartElement = this.eventFactory.createStartElement("", "", localName);
        this.eventWriter.add(configStartElement);
        this.eventWriter.add(this.newline);
        for (Map.Entry<String, String> entry : data.entrySet()) {
            this.createNode(this.eventWriter, localName, entry.getKey(), entry.getValue());
        }
        return this;
    }

    public XmlWriter close() throws XMLStreamException {
        this.eventWriter.add(this.eventFactory.createEndDocument());
        this.eventWriter.close();
        return this;
    }

    private void createNode(XMLEventWriter eventWriter, String namespaceUri, String name, String value) throws XMLStreamException {
        DTD end = this.eventFactory.createDTD("\n");
        DTD tab = this.eventFactory.createDTD("\t");
        StartElement sElement = this.eventFactory.createStartElement("", namespaceUri, name);
        eventWriter.add(tab);
        eventWriter.add(sElement);
        Characters characters = this.eventFactory.createCharacters(value);
        eventWriter.add(characters);
        EndElement eElement = this.eventFactory.createEndElement("", namespaceUri, name);
        eventWriter.add(eElement);
        eventWriter.add(end);
    }
}

