/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1.date;

import ca.infodata.util1.IntegerRange;
import ca.infodata.util1.LongRange;
import ca.infodata.util1.RangeNotation;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateRange;
import java.util.Calendar;

public class TimeRange
extends LongRange {
    private static final long serialVersionUID = 1L;

    public TimeRange() {
    }

    public TimeRange(Long start, Long end, RangeNotation notation) {
        super(start, end, notation);
    }

    public LocalDateRange toLocalDateRange() {
        LocalDate dstart = this.start == null ? null : LocalDate.fromTimeInMillisLOCAL((Long)this.start);
        LocalDate dend = this.end == null ? null : LocalDate.fromTimeInMillisLOCAL((Long)this.end);
        return new LocalDateRange(dstart, dend, this.notation);
    }

    public static TimeRange past() {
        return new TimeRange(null, DateUtil.newCalendar().getTimeInMillis(), RangeNotation.OPEN);
    }

    public static TimeRange future() {
        return new TimeRange(DateUtil.newCalendar().getTimeInMillis(), null, RangeNotation.OPEN);
    }

    public IntegerRange toMinuteRange() {
        Calendar c = null;
        Integer mstart = null;
        if (this.start != null) {
            c = DateUtil.newCalendar();
            c.setTimeInMillis((Long)this.start);
            mstart = c.get(12);
        }
        Integer mend = null;
        if (this.end != null) {
            if (c == null) {
                c = DateUtil.newCalendar();
            }
            c.setTimeInMillis((Long)this.end);
            mend = c.get(12);
        }
        return new IntegerRange(mstart, mend, this.notation);
    }
}

