/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1.date;

import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocaleProvider;
import ca.infodata.util1.date.TimeZoneProvider;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class LocalDateFormat {
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String YYYYMMDD_SLASH = "yyyy/MM/dd";
    public static final String YYYYMMDD_HYPHEN = "yyyy-MM-dd";
    public static final String YYMMDD = "yyMMdd";
    public static final String YYMMDD_SLASH = "yy/MM/dd";
    public static final String YYMMDD_HYPHEN = "yy-MM-dd";
    public static final String DDMMYY = "ddMMyy";
    public static final String DDMMYYYY = "ddMMyyyy";
    public static final String TEXTUAL_DAY_OF_WEEK = "EEEE d MMMM yyyy";
    public static final String TEXTUAL = "d MMMM yyyy";
    private static final TimeZone utc = TimeZone.getTimeZone("UTC");

    private LocalDateFormat() {
        throw new UnsupportedOperationException();
    }

    public static String nullSafeFormat(LocalDate date, String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern");
        }
        if (date == null) {
            return "";
        }
        return LocalDateFormat.format(date, pattern);
    }

    public static String format(LocalDate date, String pattern) {
        return LocalDateFormat.format(date, pattern, LocaleProvider.getLocale());
    }

    public static String format(LocalDate date, String pattern, Locale locale) {
        if (date == null) {
            throw new IllegalArgumentException("date cant be null");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("pattern cant be null");
        }
        if (locale == null) {
            throw new IllegalArgumentException("locale cant be null");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern, locale);
        simpleDateFormat.setTimeZone(TimeZoneProvider.getTimeZoneNoCopy());
        return simpleDateFormat.format(date.toTimeInMillisUTC());
    }

    public static LocalDate parse(String source, String pattern, Locale locale) throws ParseException {
        if (source == null) {
            throw new IllegalArgumentException("source cant be null");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("pattern cant be null");
        }
        if (locale == null) {
            throw new IllegalArgumentException("locale cant be null");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern, locale);
        simpleDateFormat.setTimeZone(utc);
        simpleDateFormat.setLenient(false);
        Date date = simpleDateFormat.parse(source);
        return LocalDate.fromTimeInMillisUTC(date.getTime());
    }

    public static LocalDate parse(String source, String pattern) throws ParseException {
        return LocalDateFormat.parse(source, pattern, LocaleProvider.getLocale());
    }

    public static LocalDate parseWithFixedFormats(String source) throws ParseException {
        return LocalDateFormat.parseWithFixedFormats(source, LocaleProvider.getLocale());
    }

    public static LocalDate parseWithFixedFormats(String source, Locale locale) throws ParseException {
        if (source == null) {
            throw new IllegalArgumentException("source cant be null");
        }
        if (locale == null) {
            throw new IllegalArgumentException("locale cant be null");
        }
        String text = source;
        if (source.length() >= 6) {
            text = text.replace("-", "");
            if ((text = text.replace("/", "")).length() == 6) {
                try {
                    return LocalDateFormat.parse(text, YYMMDD, locale);
                }
                catch (ParseException e) {
                    return LocalDateFormat.parse(text, DDMMYY, locale);
                }
            }
            if (text.length() == 8) {
                try {
                    return LocalDateFormat.parse(text, YYYYMMDD, locale);
                }
                catch (Exception e) {
                    return LocalDateFormat.parse(text, DDMMYYYY, locale);
                }
            }
        }
        throw new ParseException("source could not be parsed with fixed formats", 0);
    }
}

