/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1.date;

import ca.infodata.util1.Messages;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.IRelativeDate;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import ca.infodata.util1.date.LocaleProvider;
import ca.infodata.util1.date.PartialDate;
import ca.infodata.util1.date.RelativeDate;
import ca.infodata.util1.date.TimeZoneProvider;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class DateUtil {
    public static final String DTOC_SEP = "-";
    private static Map<String, SimpleDateFormat> simpleDateFormatCache = new HashMap<String, SimpleDateFormat>();

    public static String format(Long datetime, String pattern) {
        if (datetime == null) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern, LocaleProvider.getLocale());
        simpleDateFormat.setTimeZone(TimeZoneProvider.getTimeZone());
        return simpleDateFormat.format(new Date(datetime));
    }

    public static String nonThreadSafeFormat(Long datetime, String pattern) {
        if (datetime == null) {
            return "";
        }
        SimpleDateFormat sdf = simpleDateFormatCache.get(pattern);
        if (sdf == null) {
            sdf = new SimpleDateFormat(pattern, LocaleProvider.getLocale());
            sdf.setTimeZone(TimeZoneProvider.getTimeZone());
            simpleDateFormatCache.put(pattern, sdf);
        }
        return sdf.format(new Date(datetime));
    }

    public static String dtoc(Calendar c) {
        String s = "";
        if (c != null) {
            s = new StringBuilder(10).append(String.valueOf(c.get(1))).append(DTOC_SEP).append(DateUtil.padL(c.get(2) + 1, 2)).append(DTOC_SEP).append(DateUtil.padL(c.get(5), 2)).toString();
        }
        return s;
    }

    public static String format(LocalDate date) {
        if (date == null) {
            return "";
        }
        return LocalDateFormat.format(date, "yyyy/MM/dd");
    }

    public static String dtoc(long l) {
        return DateUtil.getStrDateFromLong(l);
    }

    public static String dtos(Calendar c) {
        String s = "";
        if (c != null) {
            s = String.valueOf(c.get(1)) + DateUtil.padL(c.get(2) + 1, 2) + DateUtil.padL(c.get(5), 2);
        }
        return s;
    }

    public static String dtos(Calendar c, int len) {
        String s = "";
        if (c != null) {
            s = String.valueOf(c.get(1)) + DateUtil.padL(c.get(2) + 1, 2) + DateUtil.padL(c.get(5), 2);
            s = s.substring(8 - len);
        }
        return s;
    }

    public static Calendar stod(String s) {
        if (StringUtils.isNotBlank(s)) {
            String format = s.length() == 8 ? "yyyyMMdd" : "yyyyMMddHHmm";
            SimpleDateFormat sdf = new SimpleDateFormat(format, LocaleProvider.getLocale());
            GregorianCalendar c = new GregorianCalendar(TimeZoneProvider.getTimeZone(), LocaleProvider.getLocale());
            try {
                Date d = sdf.parse(s, new ParsePosition(0));
                c.setTime(d);
                return c;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Calendar ctod(String s) {
        s = s.replace('/', DTOC_SEP.charAt(0));
        s = s.replace('-', DTOC_SEP.charAt(0));
        String format = new StringBuilder(10).append("yyyy").append(DTOC_SEP).append("MM").append(DTOC_SEP).append("dd").toString();
        try {
            LocalDateFormat.parse(s, format);
            return DateUtil.stod(s.replace(DTOC_SEP.charAt(0), '~').replaceAll("~", ""));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String padL(int numberToPad, int toLength) {
        String stringToPad = String.valueOf(numberToPad);
        if (stringToPad.length() < toLength) {
            stringToPad = "0" + stringToPad;
        }
        return stringToPad;
    }

    public static String convertTimeToString(Integer timeInMinutes, Character separator) {
        if (timeInMinutes == null) {
            return "";
        }
        if (timeInMinutes > 1440) {
            timeInMinutes = timeInMinutes % 1440;
        }
        int hour = timeInMinutes / 60;
        int minutes = timeInMinutes % 60;
        StringBuilder b = new StringBuilder(separator == null ? 4 : 5);
        if (hour < 10) {
            b.append('0');
        }
        b.append(hour);
        if (separator != null) {
            b.append(separator.charValue());
        }
        if (minutes < 10) {
            b.append('0');
        }
        b.append(minutes);
        return b.toString();
    }

    public static String convertTimeToString(Short timeInMinutes, Character separator) {
        if (timeInMinutes == null) {
            return "";
        }
        return DateUtil.convertTimeToString(timeInMinutes.intValue(), separator);
    }

    public static Calendar getDateFromLong(long date) {
        Calendar local = DateUtil.newCalendar();
        local.setTimeInMillis(date);
        return local;
    }

    public static String getStrDateFromLong(long date) {
        Calendar local = DateUtil.newCalendar();
        local.setTimeInMillis(date);
        return DateUtil.dtoc(local);
    }

    public static long getTimeAtMidnightInLong(Calendar local) {
        return DateUtil.getTimeAtMidnight(local).getTimeInMillis();
    }

    public static long getTodayAtMidnightInLong() {
        return DateUtil.getTimeAtMidnightInLong(DateUtil.newCalendar());
    }

    public static Calendar getTimeAtMidnight(Calendar date) {
        Calendar local = (Calendar)date.clone();
        local.set(11, 0);
        local.set(12, 0);
        local.set(13, 0);
        local.set(14, 0);
        return local;
    }

    public static Calendar getTimeAtMidnight(Long l) {
        if (l != null) {
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(l);
            return DateUtil.getTimeAtMidnight(c, false);
        }
        return null;
    }

    public static Calendar getTimeAtMidnight(Calendar date, boolean withClone) {
        Calendar local = withClone ? (Calendar)date.clone() : date;
        local.set(11, 0);
        local.set(12, 0);
        local.set(13, 0);
        local.set(14, 0);
        return local;
    }

    public static int nbMonthBetween(Calendar dateSmall, Calendar dateBig) {
        if (dateSmall == null || dateBig == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        int nbMonth = DateUtil.nbYearsBetween(dateSmall, dateBig) * 12;
        if (dateBig.get(2) < dateSmall.get(2)) {
            nbMonth += 12 - dateSmall.get(2) + dateBig.get(2);
        } else if (dateBig.get(2) > dateSmall.get(2)) {
            nbMonth += dateSmall.get(2) - dateBig.get(2);
        }
        if (dateBig.get(2) == dateSmall.get(2)) {
            if (dateBig.get(5) < dateSmall.get(5)) {
                nbMonth += 11;
            }
        } else if (dateBig.get(5) < dateSmall.get(5)) {
            --nbMonth;
        }
        return nbMonth;
    }

    public static int nbYearsBetween(Calendar dateSmall, Calendar dateBig) {
        if (dateSmall == null || dateBig == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        int nbYears = dateBig.get(1) - dateSmall.get(1);
        if (dateBig.get(2) < dateSmall.get(2)) {
            --nbYears;
        } else if (dateBig.get(2) == dateSmall.get(2) && dateBig.get(5) < dateSmall.get(5)) {
            --nbYears;
        }
        return nbYears;
    }

    public static int getMinutesFromMidnight() {
        Calendar c = DateUtil.newCalendar();
        return c.get(12) + c.get(11) * 60;
    }

    public static long getOneMonthInMillis() {
        Calendar start = DateUtil.newCalendar();
        start.set(2009, 0, 1);
        Calendar end = DateUtil.newCalendar();
        end.set(2009, 0, 31);
        return end.getTimeInMillis() - start.getTimeInMillis();
    }

    public static Locale parseLocale(String nl) {
        Locale locale = null;
        if (nl != null) {
            String[] iso = nl.split("_");
            String language = "";
            String country = "";
            String variant = "";
            switch (iso.length) {
                case 3: {
                    variant = iso[2];
                }
                case 2: {
                    boolean isValidISOCountry;
                    boolean bl = isValidISOCountry = Arrays.binarySearch(Locale.getISOCountries(), iso[1]) >= 0;
                    if (isValidISOCountry) {
                        country = iso[1];
                    }
                }
                case 1: {
                    boolean isValidISOLanguage;
                    boolean bl = isValidISOLanguage = Arrays.binarySearch(Locale.getISOLanguages(), iso[0]) >= 0;
                    if (!isValidISOLanguage) break;
                    language = iso[0];
                    locale = new Locale(language, country, variant);
                }
            }
        }
        return locale;
    }

    public static Calendar newCalendar() {
        return Calendar.getInstance(TimeZoneProvider.getTimeZone(), LocaleProvider.getLocale());
    }

    public static Calendar newCalendar(TimeZone zone) {
        if (zone == null) {
            throw new NullPointerException("zone");
        }
        return Calendar.getInstance(zone, LocaleProvider.getLocale());
    }

    public static Calendar newUTCCalendar() {
        return Calendar.getInstance(TimeZone.getTimeZone("UTC"), LocaleProvider.getLocale());
    }

    public static String longToDataString(long dateLong) {
        Calendar date = DateUtil.newCalendar();
        date.setTimeInMillis(dateLong);
        return DateUtil.calendarToDataString(date);
    }

    public static Calendar getCalendarFromLong(long date) {
        Calendar local = DateUtil.newCalendar();
        local.setTimeInMillis(date);
        return local;
    }

    public static String calendarToDataString(Calendar time) {
        String ret = "";
        if (time != null) {
            String year = Integer.toString(time.get(1));
            String month = "0" + Integer.toString(time.get(2) + 1);
            String day = "0" + Integer.toString(time.get(5));
            String hour = "0" + Integer.toString(time.get(11));
            String minute = "0" + Integer.toString(time.get(12));
            String second = "0" + Integer.toString(time.get(13));
            String millisecond = "00" + Integer.toString(time.get(14));
            ret = year + month.substring(month.length() - 2) + day.substring(day.length() - 2) + hour.substring(hour.length() - 2) + minute.substring(minute.length() - 2) + second.substring(second.length() - 2) + millisecond.substring(millisecond.length() - 3);
        }
        return ret;
    }

    public static String calendarToFormatedStringDate(Calendar time) {
        return DateUtil.dataStringToFormatedStringDate(DateUtil.calendarToDataString(time));
    }

    public static String calendarToFormatedStringTime(Calendar time) {
        return DateUtil.dataStringToFormatedStringTime(DateUtil.calendarToDataString(time));
    }

    public static String calendarToFormatedStringTimeMilli(Calendar time) {
        return DateUtil.dataStringToFormatedStringTimeMilli(DateUtil.calendarToDataString(time));
    }

    public static String calendarToFormatedStringDateTime(Calendar time) {
        return DateUtil.dataStringToFormatedStringDateTime(DateUtil.calendarToDataString(time));
    }

    public static String calendarToFormatedStringDateTimeMilli(Calendar time) {
        return DateUtil.dataStringToFormatedStringDateTimeMilli(DateUtil.calendarToDataString(time));
    }

    public static String dataStringToFormatedStringDate(String time) {
        StringBuilder newTime = new StringBuilder(8);
        if (time != null && time.length() > 0) {
            newTime.append(time.substring(0, 4) + "/");
            newTime.append(time.substring(4, 6) + "/");
            newTime.append(time.substring(6, 8));
        }
        return newTime.toString();
    }

    public static String dataStringToFormatedStringDateDash(String time) {
        StringBuilder newTime = new StringBuilder(8);
        if (time != null && time.length() > 0) {
            newTime.append(time.substring(0, 4) + DTOC_SEP);
            newTime.append(time.substring(4, 6) + DTOC_SEP);
            newTime.append(time.substring(6, 8));
        }
        return newTime.toString();
    }

    public static String dataStringToFormatedStringTime(String time) {
        StringBuilder newTime = new StringBuilder(4);
        if (time != null && time.length() > 0) {
            newTime.append(time.substring(8, 10) + ":");
            newTime.append(time.substring(10, 12));
        }
        return newTime.toString();
    }

    private static String dataStringToFormatedStringTimeMilli(String time) {
        StringBuilder newTime = new StringBuilder(9);
        if (time != null && time.length() > 0) {
            newTime.append(time.substring(8, 10) + ":");
            newTime.append(time.substring(10, 12) + ":");
            newTime.append(time.substring(12, 14) + ":");
            newTime.append(time.substring(14, 17));
        }
        return newTime.toString();
    }

    private static String dataStringToFormatedStringDateTime(String time) {
        StringBuilder newTime = new StringBuilder();
        if (time != null && time.length() > 0) {
            newTime.append(DateUtil.dataStringToFormatedStringDate(time));
            newTime.append(" " + DateUtil.dataStringToFormatedStringTime(time));
        }
        return newTime.toString();
    }

    private static String dataStringToFormatedStringDateTimeMilli(String time) {
        StringBuilder newTime = new StringBuilder();
        if (time != null && time.length() > 0) {
            newTime.append(DateUtil.dataStringToFormatedStringDate(time));
            newTime.append(" " + DateUtil.dataStringToFormatedStringTimeMilli(time));
        }
        return newTime.toString();
    }

    public static Calendar dataStringToCalendarAtMidnight(String time) {
        Calendar calendar = null;
        if (time != null && time.length() >= 8) {
            calendar = DateUtil.newCalendar();
            calendar.set(1, Integer.parseInt(time.substring(0, 4)));
            calendar.set(2, Integer.parseInt(time.substring(4, 6)) - 1);
            calendar.set(5, Integer.parseInt(time.substring(6, 8)));
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        }
        return calendar;
    }

    public static Calendar dataStringToCalendar(String time) {
        Calendar calendar = null;
        if (time != null && time.length() >= 8) {
            calendar = DateUtil.newCalendar();
            calendar.set(1, Integer.parseInt(time.substring(0, 4)));
            calendar.set(2, Integer.parseInt(time.substring(4, 6)) - 1);
            calendar.set(5, Integer.parseInt(time.substring(6, 8)));
            if (time.length() >= 12) {
                calendar.set(11, Integer.parseInt(time.substring(8, 10)));
                calendar.set(12, Integer.parseInt(time.substring(10, 12)));
                calendar.set(13, 0);
                calendar.set(14, 0);
            } else {
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
            }
        }
        return calendar;
    }

    public static long now() {
        return DateUtil.newCalendar().getTimeInMillis();
    }

    public static long nowUTC() {
        return DateUtil.newUTCCalendar().getTimeInMillis();
    }

    public static void debugPrint(String text, Calendar c) {
        if (c == null) {
            System.out.println((text == null ? "" : text) + " null");
        } else {
            System.out.println((text == null ? "" : text) + " " + String.format("%s-%s-%s %s:%s:%s.%s.%s.%s", c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13), c.get(14), "Z" + c.getTimeZone().getOffset(c.getTimeInMillis()), (float)c.getTimeZone().getOffset(c.getTimeInMillis()) / 1000.0f / 60.0f / 60.0f + "h"));
        }
    }

    public static String ttoc(long l) {
        return DateUtil.ttoc(l, true);
    }

    public static String ttoc(long l, boolean withSeparator) {
        return DateUtil.ttoc(l, withSeparator, false);
    }

    public static String ttoc(long l, boolean withSeparator, boolean withSeconds) {
        String s = "";
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(l);
        s = new StringBuffer(10).append(String.valueOf(c.get(1))).append(withSeparator ? DTOC_SEP : "").append(DateUtil.padL(c.get(2) + 1, 2)).append(withSeparator ? DTOC_SEP : "").append(DateUtil.padL(c.get(5), 2)).append(withSeparator ? ": " : "").append(DateUtil.padL(c.get(11), 2)).append(withSeparator ? "H" : "").append(DateUtil.padL(c.get(12), 2)).toString();
        if (withSeconds) {
            s = s + DateUtil.padL(c.get(13), 2);
        }
        return s;
    }

    public static IRelativeDate restoreDate(String s) {
        if (StringUtils.isBlank(s)) {
            return null;
        }
        IRelativeDate date = LocalDate.restore(s);
        if (date == null && (date = PartialDate.restore(s)) == null) {
            date = RelativeDate.restore(s);
        }
        return date;
    }

    public static String toMonthString(int month) {
        switch (month) {
            case 0: {
                return Messages.getString("JANVIER", new String[0]);
            }
            case 1: {
                return Messages.getString("FEVRIER", new String[0]);
            }
            case 2: {
                return Messages.getString("MARS", new String[0]);
            }
            case 3: {
                return Messages.getString("AVRIL", new String[0]);
            }
            case 4: {
                return Messages.getString("MAI", new String[0]);
            }
            case 5: {
                return Messages.getString("JUIN", new String[0]);
            }
            case 6: {
                return Messages.getString("JUILLET", new String[0]);
            }
            case 7: {
                return Messages.getString("AOUT", new String[0]);
            }
            case 8: {
                return Messages.getString("SEPTEMBRE", new String[0]);
            }
            case 9: {
                return Messages.getString("OCTOBRE", new String[0]);
            }
            case 10: {
                return Messages.getString("NOVEMBRE", new String[0]);
            }
            case 11: {
                return Messages.getString("DECEMBRE", new String[0]);
            }
        }
        throw new IllegalArgumentException("invalid month : " + month);
    }

    public static String toDayWeekString(int i, boolean court) {
        String ret = "";
        switch (i) {
            case 0: {
                ret = Messages.getString("DIM", new String[0]);
                break;
            }
            case 1: {
                ret = Messages.getString("LUN", new String[0]);
                break;
            }
            case 2: {
                ret = Messages.getString("MAR", new String[0]);
                break;
            }
            case 3: {
                ret = Messages.getString("MER", new String[0]);
                break;
            }
            case 4: {
                ret = Messages.getString("JEU", new String[0]);
                break;
            }
            case 5: {
                ret = Messages.getString("VEN", new String[0]);
                break;
            }
            case 6: {
                ret = Messages.getString("SAM", new String[0]);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid dayOfWeek " + i);
            }
        }
        return court ? ret.substring(0, 3) : ret;
    }

    public static String mtos(Integer minutesFromMidnigth, Character sep) {
        if (minutesFromMidnigth == null) {
            return "";
        }
        int m = minutesFromMidnigth;
        if (m < 0) {
            m = (int)(TimeUnit.DAYS.toMinutes(1L) + (long)m);
        }
        return DateUtil.convertTimeToString(m, sep);
    }
}

