/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1.config;

import ca.infodata.util1.config.ConfigKey;
import ca.infodata.util1.config.ConfigurationException;
import ca.infodata.util1.config.IConfigService;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;

public class ConfigService
implements IConfigService {
    private static final Logger logger = Logger.getLogger(ConfigService.class.getName());
    private volatile ConcurrentHashMap<Object, Object> properties = new ConcurrentHashMap();
    private String jndiName;
    private Class<?> configClass;

    public void init(String jndiName, Class<?> configClass) {
        this.jndiName = jndiName;
        this.configClass = configClass;
        this.loadConfig();
        this.validConfig();
    }

    public void destroy() {
    }

    protected void validConfig() {
        logger.info("Validating ... " + this.jndiName);
        try {
            List<ConfigKey<?>> keys = ConfigService.listConfigKeys(this.configClass);
            for (ConfigKey<?> key : keys) {
                this.getProperty(key);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Validation failed " + this.jndiName, e);
        }
    }

    @Override
    public <T> T getProperty(ConfigKey<T> key) {
        key.setProperties(this.properties);
        return key.getProperty();
    }

    @Override
    public <T> T getCheckedProperty(ConfigKey<T> key) throws ConfigurationException {
        key.setProperties(this.properties);
        return key.getCheckedProperty();
    }

    public void loadConfig() {
        try {
            logger.info("Loading config file from jndi context " + this.jndiName);
            InitialContext initialContext = null;
            try {
                initialContext = new InitialContext();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to load config file from jndi context " + this.jndiName, e);
            }
            if (initialContext != null) {
                Properties config = (Properties)initialContext.lookup(this.jndiName);
                ConcurrentHashMap<Object, Object> map = new ConcurrentHashMap<Object, Object>();
                for (Map.Entry<Object, Object> e : config.entrySet()) {
                    map.put(e.getKey(), e.getValue());
                }
                this.properties = map;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to load config", e);
        }
    }

    public static List<ConfigKey<?>> listConfigKeys(Class<?> c) throws Exception {
        Field[] declaredFields;
        ArrayList list = new ArrayList();
        for (Field field : declaredFields = c.getDeclaredFields()) {
            Object value;
            int modifiers;
            if (field == null || !field.isAccessible() || !Modifier.isStatic(modifiers = field.getModifiers()) || !Modifier.isPublic(modifiers) || !((value = field.get(null)) instanceof ConfigKey)) continue;
            list.add((ConfigKey)value);
        }
        return list;
    }
}

