/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1;

import ca.infodata.util1.RangeNotation;
import java.io.Serializable;

public abstract class Range<T extends Comparable<? super T>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public T start;
    public T end;
    public RangeNotation notation;

    public Range() {
    }

    public Range(T start, T end, RangeNotation notation) {
        this.start = start;
        this.end = end;
        this.notation = notation;
        this.valid();
    }

    public void valid() {
        if (this.notation == null) {
            throw new IllegalArgumentException("notation cant be null");
        }
        if (this.start != null && this.end != null) {
            int compareTo = this.start.compareTo(this.end);
            if (compareTo > 0) {
                throw new IllegalArgumentException("start must be lower than or equals to end");
            }
            switch (this.notation) {
                case LEFT_CLOSED: 
                case RIGHT_CLOSED: 
                case OPEN: {
                    if (compareTo != 0) break;
                    throw new IllegalArgumentException("with LEFT_CLOSED, RIGHT_CLOSED or OPEN notation, start cant be equals to end");
                }
            }
        }
    }

    public abstract boolean intersect(Range<T> var1);

    public boolean contains(T other) {
        this.valid();
        return this.notation.inRange(other, this.start, this.end);
    }

    public String toString() {
        switch (this.notation) {
            case OPEN: {
                return String.format("]%s...%s[", this.start, this.end);
            }
            case CLOSED: {
                return String.format("[%s...%s]", this.start, this.end);
            }
            case LEFT_CLOSED: {
                return String.format("[%s...%s[", this.start, this.end);
            }
            case RIGHT_CLOSED: {
                return String.format("]%s...%s]", this.start, this.end);
            }
        }
        return super.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.end == null ? 0 : this.end.hashCode());
        result = 31 * result + (this.notation == null ? 0 : this.notation.hashCode());
        result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        if (this.end == null ? other.end != null : !this.end.equals(other.end)) {
            return false;
        }
        if (this.notation != other.notation) {
            return false;
        }
        return !(this.start == null ? other.start != null : !this.start.equals(other.start));
    }
}

