/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.readhl7;

import ca.infodata.readhl7.DataTypeUtils;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.validation.impl.NoValidation;
import java.io.FileOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class OscarToOscarUtils {
    private static final Logger logger = Logger.getLogger(DataTypeUtils.class.getName());
    public static final String UPLOAD_MESSAGE_TYPE = "OSCAR_TO_OSCAR_HL7_V2";
    public static final PipeParser pipeParser = OscarToOscarUtils.initialisePipeParser();

    private static PipeParser initialisePipeParser() {
        PipeParser pipeParser = new PipeParser();
        pipeParser.setValidationContext(new NoValidation());
        return pipeParser;
    }

    public static AbstractMessage pipeParserParse(String hl7Message) throws EncodingNotSupportedException, HL7Exception {
        hl7Message = hl7Message.replaceAll("\n", "\r");
        hl7Message = hl7Message.replaceAll("\r\r", "\r");
        AbstractMessage message = (AbstractMessage)pipeParser.parse(hl7Message);
        return message;
    }

    public static void dumpMessageToDebugger(AbstractMessage message) {
        try {
            String result = pipeParser.encode(message);
            result = result.replace("\r", "\r\n");
            result = result.replace("\r\r", "\r");
            logger.log(Level.SEVERE, result);
        }
        catch (HL7Exception e) {
            logger.log(Level.SEVERE, "Unexpected error.", e);
        }
    }

    public static void dumpMessageToFile(AbstractMessage message) {
        try {
            String result = pipeParser.encode(message);
            result = result.replace("\r", "\r\n");
            result = result.replace("\r\r", "\r");
            FileOutputStream fos = new FileOutputStream("/tmp/temp.hl7");
            fos.write(result.getBytes());
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unexpected error.", e);
        }
    }
}

