/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.readhl7;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DateTimeFormatUtils {
    private static final Logger logger = Logger.getLogger(DateTimeFormatUtils.class.getName());
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat TIME_FORMAT = DateFormat.getTimeInstance(3);

    public static final Timestamp getPast(int numYears) {
        return DateTimeFormatUtils.getPast(Calendar.getInstance(), numYears);
    }

    public static final Timestamp getPast(Calendar calendar, int numYears) {
        calendar.add(1, -numYears);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static final Date getFuture(Date start, Integer daysInFuture) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, daysInFuture);
        Date future = calendar.getTime();
        return DateTimeFormatUtils.getDateFromDate(future);
    }

    public static final String getStringFromDate(Date date) {
        return DateTimeFormatUtils.getStringFromDate(date, DATE_FORMAT);
    }

    public static final String getStringFromDate(Date date, DateFormat format) {
        return DateTimeFormatUtils.format(date, format);
    }

    public static final Date getDateFromString(String date) {
        return DateTimeFormatUtils.getDateFromString(date, DATE_FORMAT);
    }

    public static final Date getDateFromString(String date, DateFormat format) {
        return DateTimeFormatUtils.parse(date, DATE_FORMAT);
    }

    public static final Date getDateFromDate(Date date) {
        return DateTimeFormatUtils.parseFormat(date, DATE_FORMAT);
    }

    public static final Date getTimeFromLong(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        Date date = calendar.getTime();
        return DateTimeFormatUtils.getTimeFromDate(date);
    }

    public static final String getStringFromTime(Date time) {
        return DateTimeFormatUtils.format(time, TIME_FORMAT);
    }

    public static final Date getTimeFromString(String time) {
        return DateTimeFormatUtils.parse(time, TIME_FORMAT);
    }

    public static final Date getTimeFromDate(Date date) {
        return DateTimeFormatUtils.parse(DateTimeFormatUtils.format(date, TIME_FORMAT), TIME_FORMAT);
    }

    private static final Date parseFormat(Date date, DateFormat format) {
        return DateTimeFormatUtils.parse(DateTimeFormatUtils.format(date, format), format);
    }

    private static final String format(Date date, DateFormat format) {
        return date != null ? format.format(date) : new String();
    }

    private static final Date parse(String s, DateFormat format) {
        try {
            return s != null && s.length() > 0 ? format.parse(s) : null;
        }
        catch (ParseException e) {
            logger.log(Level.SEVERE, "parse: " + s, e);
            throw new IllegalStateException(e);
        }
    }
}

