/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.scan.dsq;

import ca.infodata.dsq.domain.Candidate;
import ca.infodata.dsq.domain.Code;
import ca.infodata.dsq.domain.Id;
import ca.infodata.dsq.domain.NAM;
import ca.infodata.dsq.domain.NIU;
import ca.infodata.dsq.domain.NIU_U;
import ca.infodata.dsq.domain.labo.getreport.LaboReport;
import ca.infodata.ofys.client.modules.dsq.DsqCallback;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImage;
import ca.infodata.ofys.ui.dsq.BaseDSQAction;
import ca.infodata.ofys.ui.dsq.FindCandidateAction;
import ca.infodata.ofys.ui.scan.dsq.GetLaboReportControllerCallback;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.StringUtils;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class GetLaboReportController {
    private static final String OBTENTION_DU_RAPPORT = "Obtention du rapport";
    private static final Logger logger = Logger.getLogger(GetLaboReportController.class.getName());
    private final GetLaboReportControllerCallback callback;
    private IPatient patient;
    private Id idRequest;
    private Code reportType;
    private LaboReport result;
    private Job get;
    private FindCandidateAction findCandidateAction;
    private BaseDSQAction dsq;
    private XPatientImage patientImage;
    private Candidate candidate;

    public GetLaboReportController(GetLaboReportControllerCallback callback, BaseDSQAction dsq, FindCandidateAction findCandidateAction) {
        if (dsq == null) {
            throw new NullPointerException("dsq");
        }
        if (callback == null) {
            throw new NullPointerException("callback");
        }
        if (findCandidateAction == null) {
            throw new NullPointerException("findCandidateAction");
        }
        this.dsq = dsq;
        this.callback = callback;
        this.findCandidateAction = findCandidateAction;
    }

    public void get(final String hostAddr) {
        if (this.get == null) {
            this.get = new Job(OBTENTION_DU_RAPPORT){

                protected IStatus run(IProgressMonitor monitor) {
                    GetLaboReportController.this.get2(monitor, hostAddr);
                    return Status.OK_STATUS;
                }
            };
        }
        if (this.get.getState() == 4) {
            this.callback.getLabo((DsqCallback<LaboReport>)new DsqCallback(null, "Op\u00e9ration en cours...", null), hostAddr);
        } else {
            this.get.schedule();
        }
    }

    public void get2(IProgressMonitor monitor, String hostAddr) {
        if (this.result == null) {
            DsqCallback<LaboReport> r = this.get3(monitor);
            if (r.result != null) {
                this.result = (LaboReport)r.result;
            }
            this.callback.getLabo(r, hostAddr);
        } else {
            this.callback.getLabo((DsqCallback<LaboReport>)new DsqCallback((Object)this.result), hostAddr);
        }
    }

    /*
     * Exception decompiling
     */
    private DsqCallback<LaboReport> get3(IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void clear() {
        this.result = null;
        this.candidate = null;
    }

    public void setXImage(IPatient patient, XPatientImage x) {
        Integer idPatient2;
        this.clear();
        this.patient = patient;
        this.patientImage = x;
        Integer idPatient1 = patient == null ? null : patient.getId();
        Integer n = idPatient2 = x == null ? null : x.idPatient;
        if (!MiscUtil.areObjectsEquals((Object)idPatient1, (Object)idPatient2)) {
            throw new IllegalArgumentException("patient.getId() should match e.idPatient");
        }
        if (x == null || x.valDsq == null) {
            this.idRequest = null;
            this.reportType = null;
        } else {
            this.idRequest = x.valDsq.laboRequest.id;
            this.reportType = x.valDsq.laboReportHeader.reportType;
        }
        if (StringUtils.isNotEmpty((String)this.patient.getNiu())) {
            this.candidate = new Candidate(new NIU_U(this.patient.getNiu()), StringUtils.isBlank((CharSequence)this.patient.getHealthInsuranceNumber()) ? null : new NAM(this.patient.getHealthInsuranceNumber()), this.patient.getFirstName(), this.patient.getLastName(), BaseDSQAction.getDsqGender((String)this.patient.getGender()), Long.valueOf(this.patient.getBirthDate().toTimeInMillisUTC()), null);
        }
    }

    public XPatientImage getPatientImage() {
        return this.patientImage;
    }

    public static String toString(Id id) {
        return id == null ? null : String.valueOf(id.root) + ";" + id.extension;
    }

    public static String toString(Code code) {
        return code == null ? null : String.valueOf(code.codeSystem) + ";" + code.code;
    }

    public static String toString(NIU niu) {
        return niu == null ? null : String.valueOf(niu.oid()) + ";" + niu.value();
    }

    public IPatient getPatient() {
        return this.patient;
    }

    public LaboReport getLaboReport() {
        return this.result;
    }

    public Candidate getCandidate() {
        return this.candidate;
    }
}

