/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.user;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.XPerson;
import ca.infodata.ofys.data.middle.dataobjects.XRight;
import ca.infodata.ofys.data.middle.dataobjects.XUser;
import ca.infodata.ofys.data.middle.dataobjects.XUserRole;
import ca.infodata.ofys.ui.person.PersonMultiEditor;
import ca.infodata.ofys.ui.person.user.BaseUserControl;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.encryption.DesEncrypter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class UserControl
extends BaseUserControl {
    public UserControl(Composite parent, FormToolkit toolkit, PersonMultiEditor parentEditor) {
        super(parent, 0, parentEditor);
        this.createMyControl(this, toolkit);
    }

    @Override
    public void showCurrentUser() {
        XUser user = this.getUser();
        if (user == null) {
            TableItem ti;
            this.CUser.setVisible(false);
            TableItem[] tableItemArray = this.tblRoles.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                ti = tableItemArray[n2];
                ti.setChecked(false);
                ++n2;
            }
            tableItemArray = this.tblRolesCrisis.getItems();
            n = tableItemArray.length;
            n2 = 0;
            while (n2 < n) {
                ti = tableItemArray[n2];
                ti.setChecked(false);
                ++n2;
            }
            this.chkRoleCrisisEnabled.setSelection(false);
            this.txtRoleCrisisEndDate.setDate(null);
            this.chkUser.setSelection(false);
            this.txtUserName.setRawText(null);
            if (Application.get().getGlobalInstances().hasRight(XRight.EDIT_USER)) {
                this.txtUserName.setEnabled(true);
            }
            this.txtUserPass.setRawText(null);
            this.txtUserPassConfirm.setRawText(null);
            this.txtFromDate.setDate(null);
            this.txtToDate.setDate(null);
        } else {
            TableItem ti;
            this.CUser.setEnabled(true);
            this.chkUser.setEnabled(false);
            this.txtUserName.setEnabled(false);
            this.txtUserPass.setEnabled(false);
            this.txtUserPassConfirm.setEnabled(false);
            this.txtFromDate.setEnabled(false);
            this.txtToDate.setEnabled(false);
            this.chkRoleCrisisEnabled.setEnabled(false);
            this.txtRoleCrisisEndDate.setEnabled(false);
            XPerson person = this.getParentEditor().getPerson();
            this.CUser.setVisible(person.getIsUser() != false && user.getIsDeleted() == false);
            TableItem[] tableItemArray = this.tblRoles.getItems();
            int n = tableItemArray.length;
            int n3 = 0;
            while (n3 < n) {
                ti = tableItemArray[n3];
                if (ti.getData() instanceof XUserRole && user.getRole().contains(ti.getData())) {
                    ti.setChecked(true);
                } else {
                    ti.setChecked(false);
                }
                ++n3;
            }
            tableItemArray = this.tblRolesCrisis.getItems();
            n = tableItemArray.length;
            n3 = 0;
            while (n3 < n) {
                ti = tableItemArray[n3];
                if (ti.getData() instanceof XUserRole && user.getCrisisRole().contains(ti.getData())) {
                    ti.setChecked(true);
                } else {
                    ti.setChecked(false);
                }
                ++n3;
            }
            this.chkUser.setSelection(person.getIsUser() != false && user.getIsDeleted() == false);
            this.txtUserName.setRawText(user.getName());
            this.txtUserPass.setRawText(DesEncrypter.decryptMeOr((String)user.getEncryptedPassword(), (String)""));
            this.txtUserPassConfirm.setRawText(DesEncrypter.decryptMeOr((String)user.getEncryptedPassword(), (String)""));
            this.txtFromDate.setDate((IPartialDate)user.getValidFromDate());
            this.txtToDate.setDate((IPartialDate)user.getValidToDate());
            this.chkRoleCrisisEnabled.setSelection(Boolean.TRUE.equals(user.getCrisisRoleEnabled()));
            this.txtRoleCrisisEndDate.setDate((IPartialDate)user.getCrisisRoleEndDate());
            XUser sessionUser = Application.get().getGlobalInstances().getSession().getUser();
            if (Application.get().getGlobalInstances().hasRight(XRight.EDIT_USER)) {
                this.chkUser.setEnabled(true);
                this.txtUserName.setEnabled(user.getId() == null);
                this.txtUserPass.setEnabled(true);
                this.txtUserPassConfirm.setEnabled(true);
                if (this.getUser().getIsBlocked()) {
                    this.btnUnblockUser.setVisible(true);
                    this.btnUnblockUser.setEnabled(true);
                }
                this.txtFromDate.setEnabled(true);
                this.txtToDate.setEnabled(true);
                this.chkRoleCrisisEnabled.setEnabled(true);
                this.txtRoleCrisisEndDate.setEnabled(true);
            } else if (sessionUser.equals((Object)user)) {
                this.btnUnblockUser.setVisible(false);
                this.btnUnblockUser.setEnabled(false);
                this.chkUser.setEnabled(false);
                this.tblRoles.setEnabled(false);
                this.tblRolesCrisis.setEnabled(false);
                this.txtUserName.setEnabled(false);
                this.txtUserPass.setEnabled(true);
                this.txtUserPassConfirm.setEnabled(true);
                this.txtFromDate.setEnabled(false);
                this.txtToDate.setEnabled(false);
                this.chkRoleCrisisEnabled.setEnabled(false);
                this.txtRoleCrisisEndDate.setEnabled(false);
            } else {
                this.btnUnblockUser.setVisible(false);
                this.btnUnblockUser.setEnabled(false);
                this.chkUser.setEnabled(false);
                this.tblRoles.setEnabled(false);
                this.tblRolesCrisis.setEnabled(false);
                this.txtUserName.setEnabled(false);
                this.txtUserPass.setEnabled(false);
                this.txtUserPassConfirm.setEnabled(false);
                this.txtFromDate.setEnabled(false);
                this.txtToDate.setEnabled(false);
                this.chkRoleCrisisEnabled.setEnabled(false);
                this.txtRoleCrisisEndDate.setEnabled(false);
            }
        }
        this.layout(true);
    }

    public boolean getIsUser() {
        return this.chkUser.getSelection();
    }
}

