/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient.search.editor;

import apple.finder.search.ui.AbstractRow;
import apple.finder.search.ui.AppleFinderGrid;
import apple.finder.search.ui.GroupRow;
import apple.finder.search.ui.IAppleFinderGridFactory;
import apple.finder.search.ui.ICriteriaField;
import apple.finder.search.ui.ICriteriaRowFactory;
import apple.finder.search.ui.IGetFactory;
import apple.finder.search.ui.ISetFactory;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.CommonAccessorClient;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XCompletionProposalType;
import ca.infodata.ofys.data.middle.dataobjects.search.Group;
import ca.infodata.ofys.data.middle.dataobjects.search.XSearchOrder;
import ca.infodata.ofys.data.middle.dataobjects.search.XSearchResult;
import ca.infodata.ofys.data.middle.dataobjects.template.XTemplate;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.ControlDecorator;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.EditorModifyListener;
import ca.infodata.ofys.ui.controls.IBaseEditor2;
import ca.infodata.ofys.ui.controls.ICancelablePart;
import ca.infodata.ofys.ui.controls.IDeleteablePart;
import ca.infodata.ofys.ui.controls.ISaveablePart;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.MyText;
import ca.infodata.ofys.ui.controls.template.TemplateAccessorClient;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.person.patient.search.AbstractCriteria;
import ca.infodata.ofys.ui.person.patient.search.CriteriaGetFactory;
import ca.infodata.ofys.ui.person.patient.search.IAppleFinderGridFactory2;
import ca.infodata.ofys.ui.person.patient.search.XmlGetFactory;
import ca.infodata.ofys.ui.person.patient.search.XmlSetFactory;
import ca.infodata.ofys.ui.person.patient.search.editor.ChooseTemplateDialog;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SearchOrderEditor
extends BaseEditor
implements IAppleFinderGridFactory2,
ISaveablePart,
ICancelablePart,
IDeleteablePart {
    private static final Logger logger = Logger.getLogger(SearchOrderEditor.class.getName());
    public static final String PATIENT_SEARCH_CRITERIA_ID = "ca.infodata.ofys.ui.person.patientSearchCriteria";
    private Map<ICriteriaField, ICriteriaRowFactory> fields;
    private Map<ICriteriaField, AbstractCriteria> fields2;
    private MyText txtName;
    private AppleFinderGrid grid;
    private MyButton btnUseOrder;
    private MyButton btnUseResult;
    private MyButton btnUseTemplate;
    private MyButton btnClear;
    private MyButton chkDone;

    public void showDataObject() {
        XSearchOrder order = this.getOrder();
        if (order == null) {
            this.txtName.clear();
            this.txtName.setEnabled(false);
            this.grid.deleteAll();
            this.grid.setEnabled(false);
            this.chkDone.setSelection(false);
            this.chkDone.setEnabled(false);
        } else {
            this.chkDone.setEnabled(true);
            this.chkDone.setSelection(Boolean.TRUE.equals(order.getIsDone()));
            this.txtName.setEnabled(true);
            this.txtName.setText(order.getName());
            try {
                this.grid.setEnabled(true);
                if (StringUtils.isNotBlank((String)order.getTemplateXml())) {
                    XmlSetFactory factory = new XmlSetFactory(this, order.getTemplateXml());
                    this.grid.setGroup((ISetFactory)factory);
                } else {
                    order.getCriteria();
                }
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "Failed to load xml into grid for order " + StringUtils.safeToString((Logger)logger, (Object)order));
                MessageUtil.bugMsg((Shell)this.getSite().getShell(), (String)"\u00c9chec du chargement de la grille de recherche");
                this.grid.setEnabled(false);
                this.txtName.setEnabled(false);
            }
        }
    }

    public void initDataOverride() {
        EditorInput input = (EditorInput)this.getEditorInput();
        XSearchOrder order = (XSearchOrder)input.getDataObject();
        this.initializeCompleteDataObject(order.clone());
    }

    public void createMyControl(Composite parent) {
        MyLabel lblName = new MyLabel(parent, Messages.getString((String)"NOM", (String[])new String[0]), 16384, this.toolkit);
        this.txtName = new MyText(parent, this.toolkit, 2052);
        this.txtName.setFont(ResourceGetter.getFontNormal((int)5));
        ControlDecorator.decorateWithRequiredField((Control)this.txtName.getControl());
        this.btnUseOrder = new MyButton(parent, "Utiliser une demande", 8, this.toolkit);
        this.btnUseOrder.setToolTipText("Utiliser une demande existante comme source");
        this.btnUseTemplate = new MyButton(parent, "Utiliser un mod\u00e8le", 8, this.toolkit);
        this.btnUseTemplate.setToolTipText("Utiliser un mod\u00e8le existant comme source");
        this.btnUseResult = new MyButton(parent, "Utiliser un r\u00e9sultat", 8, this.toolkit);
        this.btnUseResult.setToolTipText("Utiliser un r\u00e9sultat existant comme source");
        this.btnClear = new MyButton(parent, "Remettre \u00e0 z\u00e9ro", 8, this.toolkit);
        this.chkDone = new MyButton(parent, "Ex\u00e9cut\u00e9? D\u00e9cocher et sauvegarder pour demander une nouvelle ex\u00e9cution de la demande", 32, this.toolkit);
        this.grid = new AppleFinderGrid(parent, 0){

            public void layoutRows() {
                super.layoutRows();
                if (!this.isDeferRowLayout()) {
                    SearchOrderEditor.this.getForm().reflow(true);
                }
            }
        };
        this.grid.setFactory((IAppleFinderGridFactory)this);
        this.btnUseOrder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchOrderEditor.this.querySourceFromOrders();
            }
        });
        this.btnUseTemplate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchOrderEditor.this.querySourceFromTemplates();
            }
        });
        this.btnUseResult.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchOrderEditor.this.querySourceFromResults();
            }
        });
        this.btnClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchOrderEditor.this.doClear();
            }
        });
        this.chkDone.addSelectionListener((SelectionListener)new EditorModifyListener((IBaseEditor2)this, 13){

            public void edited(Event e) {
                SearchOrderEditor.this.getOrder().setIsDone(Boolean.valueOf(SearchOrderEditor.this.chkDone.getSelection()));
            }
        });
        this.txtName.addModifyListener((ModifyListener)new EditorModifyListener((IBaseEditor2)this, 24){

            public void edited(Event e) {
                SearchOrderEditor.this.getOrder().setName(SearchOrderEditor.this.txtName.getText().trim());
            }
        });
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        parent.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        lblName.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblName.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.txtName.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtName.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.chkDone.setLayoutData((Object)data);
        Control control = this.chkDone.getControl();
        data = new FormData();
        data.top = new FormAttachment(control);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(25);
        this.btnUseOrder.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(control);
        data.left = new FormAttachment(this.btnUseOrder.getControl());
        data.right = new FormAttachment(50);
        this.btnUseTemplate.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(control);
        data.left = new FormAttachment(this.btnUseTemplate.getControl());
        data.right = new FormAttachment(75);
        this.btnUseResult.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(control);
        data.left = new FormAttachment(this.btnUseResult.getControl());
        data.right = new FormAttachment(100);
        this.btnClear.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.btnUseOrder.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.grid.setLayoutData((Object)data);
    }

    protected void querySourceFromTemplates() {
        try {
            List list = TemplateAccessorClient.getInstance().find(XCompletionProposalType.PATIENT_COMPLEX_SEARCH, null);
            ChooseTemplateDialog dialog = new ChooseTemplateDialog(this.getSite().getShell(), -1);
            dialog.setModel(list);
            if (dialog.open() == 0) {
                XTemplate template = dialog.getSelectedTemplate();
                this.updateGrid(template);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Erreur", e);
            MessageUtil.unexpectedExceptionMsg((Shell)this.getSite().getShell(), (Exception)e);
        }
    }

    protected void querySourceFromOrders() {
        try {
            List list = CommonAccessorClient.getInstance().findSearchOrderSync(Application.get().getGlobalInstances().getSession());
            ArrayList<XTemplate> list2 = new ArrayList<XTemplate>();
            for (XSearchOrder order : list) {
                XTemplate template = new XTemplate();
                template.setName(order.getName());
                template.setText(order.getTemplateXml());
                template.setId(order.getTemplateId());
                list2.add(template);
            }
            ChooseTemplateDialog dialog = new ChooseTemplateDialog(this.getSite().getShell(), -1);
            dialog.setModel(list2);
            if (dialog.open() == 0) {
                XTemplate template = dialog.getSelectedTemplate();
                this.updateGrid(template);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Erreur", e);
            MessageUtil.unexpectedExceptionMsg((Shell)this.getSite().getShell(), (Exception)e);
        }
    }

    protected void querySourceFromResults() {
        try {
            List list = CommonAccessorClient.getInstance().findSearchResultSync(Application.get().getGlobalInstances().getSession());
            ArrayList<XTemplate> list2 = new ArrayList<XTemplate>();
            int id = 0;
            for (XSearchResult r : list) {
                XTemplate template = new XTemplate();
                template.setName(r.getOrderName());
                template.setText(r.getOrderTemplateXml());
                template.setId(Integer.valueOf(id++));
                list2.add(template);
            }
            ChooseTemplateDialog dialog = new ChooseTemplateDialog(this.getSite().getShell(), -1);
            dialog.setModel(list2);
            if (dialog.open() == 0) {
                XTemplate template = dialog.getSelectedTemplate();
                this.updateGrid(template);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Erreur", e);
            MessageUtil.unexpectedExceptionMsg((Shell)this.getSite().getShell(), (Exception)e);
        }
    }

    private void updateGrid(XTemplate template) {
        if (template == null) {
            return;
        }
        try {
            this.grid.setGroup((ISetFactory)new XmlSetFactory(this, template.getText()));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to update grid with template " + StringUtils.safeToString((Logger)logger, (Object)template));
            MessageUtil.show((Shell)this.getSite().getShell(), (Exception)e);
        }
    }

    public BaseAccessorClient getAccessor() throws CannotConnectToServerException {
        return CommonAccessorClient.getInstance();
    }

    public XSearchOrder getOrder() {
        EditorInput input = (EditorInput)this.getEditorInput();
        return input == null ? null : (XSearchOrder)input.getCompleteDataObject();
    }

    public void setToolBarStatus() {
    }

    public boolean isDataDirty() {
        return this.getOrder().isDirty();
    }

    public Image getEditorTitleImage() {
        return ResourceGetter.getImage((String)"images/search-icon32.png");
    }

    public String getEditorTitle() {
        XSearchOrder order = this.getOrder();
        if (order == null || order.getId() == null) {
            return Messages.getString((String)"NOUVELLE_DEMANDE", (String[])new String[0]);
        }
        return order.getName();
    }

    public Set<ICriteriaField> getFields() {
        if (this.fields == null) {
            this.fields2 = new HashMap<ICriteriaField, AbstractCriteria>();
            this.fields = new TreeMap<ICriteriaField, ICriteriaRowFactory>(new Comparator<ICriteriaField>(){

                @Override
                public int compare(ICriteriaField o1, ICriteriaField o2) {
                    return StringUtils.compareAscii((String)o1.getText(), (String)o2.getText());
                }
            });
            IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(PATIENT_SEARCH_CRITERIA_ID);
            try {
                IConfigurationElement[] iConfigurationElementArray = config;
                int n = config.length;
                int n2 = 0;
                while (n2 < n) {
                    AbstractCriteria factory;
                    IConfigurationElement e = iConfigurationElementArray[n2];
                    AbstractCriteria field = factory = (AbstractCriteria)e.createExecutableExtension("factory");
                    this.fields.put(field, factory);
                    this.fields2.put(field, factory);
                    ++n2;
                }
            }
            catch (CoreException ex) {
                logger.log(Level.WARNING, "Failed to load patient search criteria extensions for " + this.getClass().getName(), ex);
            }
        }
        return this.fields.keySet();
    }

    public ICriteriaRowFactory get(ICriteriaField field) {
        return this.fields.get(field);
    }

    @Override
    public AbstractCriteria getCriteria(ICriteriaField field) {
        return this.fields2.get(field);
    }

    protected void doClear() {
        this.grid.deleteAll();
        try {
            this.grid.setDeferRowLayout(true);
            GroupRow g = this.grid.addGroup(null);
            this.grid.addCriteria((AbstractRow)g);
        }
        finally {
            this.grid.setDeferRowLayout(false);
        }
        this.grid.setDirty(false);
    }

    public void justBeforeSaving() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    XmlGetFactory xmlFactory = new XmlGetFactory(SearchOrderEditor.this.fields2);
                    SearchOrderEditor.this.grid.getGroup((IGetFactory)xmlFactory);
                    String xml = xmlFactory.toXml();
                    CriteriaGetFactory groupFactory = new CriteriaGetFactory(SearchOrderEditor.this.fields2);
                    SearchOrderEditor.this.grid.getGroup((IGetFactory)groupFactory);
                    Group group = groupFactory.toGroup();
                    XSearchOrder order = SearchOrderEditor.this.getOrder();
                    order.setCriteria(group);
                    order.setTemplateXml(xml);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "failed to export grid to order ", e);
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

