/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient.search.criteria;

import apple.finder.search.ui.UI;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.EncounterAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.encounter.ICode;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XCodeClassification;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLabType;
import ca.infodata.ofys.ui.controls.SWTDelayedListener;
import ca.infodata.ofys.ui.controls.form.MyTable2;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchColumn;
import ca.infodata.ofys.ui.controls.popup.PopupFeature;
import ca.infodata.util1.PredicateA;
import ca.infodata.util1.ProviderAR;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class CodeSearchListPopupFeature<E extends ICode>
extends PopupFeature {
    protected List<E> source;
    private MyTable2<E> sourceTable;
    private final Set<E> model;
    private String alias;
    private MyTable2<E> modelTable;
    private XCodeClassification classification;
    private boolean showAlias;
    private boolean showModelTable;

    public CodeSearchListPopupFeature(Control control, Set<E> model, String alias, XCodeClassification classification) {
        super(control);
        this.alias = alias;
        this.classification = classification;
        this.showPopupDown = true;
        this.showAlias = true;
        this.showModelTable = true;
        this.model = model;
    }

    protected Shell createPopupControlOverride(Shell parentShell) {
        Shell shell;
        Shell parent = shell = new Shell(parentShell, 4);
        Label searchTip = new Label((Composite)parent, 0x1000040);
        if (this.isShowModelTable()) {
            searchTip.setText("Utiliser 'Enter' ou Double-cliquer pour ajouter et 'Supprimer' pour supprimer");
        } else {
            searchTip.setText("Utiliser 'Enter' ou Double-cliquer pour ajouter");
        }
        this.modelTable = new MyTable2((Composite)parent, 68098);
        this.modelTable.setPredicate(new PredicateA<E>(){

            public boolean evaluate(E e) {
                return e != null && CodeSearchListPopupFeature.this.classification == e.getClassification();
            }
        });
        this.createTableColumns(this.modelTable);
        this.modelTable.setItems(this.model);
        Label separator = new Label((Composite)parent, 258);
        final Text searchText = new Text((Composite)parent, 2048);
        Label lblAlias = new Label((Composite)parent, 16384);
        lblAlias.setText("Alias - Utiliser un alias pour d\u00e9crire votre s\u00e9lection \u00e0 place d'une longue liste de code");
        final Text txtAlias = new Text((Composite)parent, 2052);
        txtAlias.setText(this.alias == null ? "" : this.alias);
        this.sourceTable = new MyTable2((Composite)parent, 68098);
        this.createTableColumns(this.sourceTable);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        searchText.setLayoutData((Object)data);
        data = new FormData();
        data = new FormData();
        data.top = new FormAttachment((Control)searchText);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.height = 200;
        this.sourceTable.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.sourceTable.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        searchTip.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)searchTip);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        separator.setLayoutData((Object)data);
        if (this.isShowModelTable()) {
            data = new FormData();
            data.top = new FormAttachment((Control)separator);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            data.height = 200;
            this.modelTable.setLayoutData((Object)data);
        }
        this.modelTable.setVisible(this.isShowModelTable());
        data = new FormData();
        data.top = new FormAttachment((Control)(this.isShowModelTable() ? this.modelTable.getControl() : searchTip));
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        lblAlias.setLayoutData((Object)data);
        lblAlias.setVisible(this.isShowAlias());
        data = new FormData();
        data.top = new FormAttachment((Control)lblAlias);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        txtAlias.setLayoutData((Object)data);
        txtAlias.setVisible(this.isShowAlias());
        txtAlias.addListener(24, (Listener)new SWTDelayedListener(2000L, 24){

            public void handleEventOverride(Event e) {
                CodeSearchListPopupFeature.this.alias = txtAlias.getText();
                CodeSearchListPopupFeature.this.modelModified();
            }
        });
        searchText.addListener(24, (Listener)new SWTDelayedListener(1000L, 24){

            public void handleEventOverride(Event e) {
                if (!searchText.isDisposed()) {
                    CodeSearchListPopupFeature.this.search(searchText.getText().trim());
                }
            }
        });
        this.sourceTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (UI.CR((KeyEvent)e)) {
                    List selection = CodeSearchListPopupFeature.this.sourceTable.getSelection();
                    boolean added = false;
                    for (ICode x : selection) {
                        if (!CodeSearchListPopupFeature.this.model.add(x)) continue;
                        added = true;
                        CodeSearchListPopupFeature.this.modelTable.add((Object)x);
                    }
                    if (added) {
                        UI.autoAdjustColumnWidthToContent((Table)CodeSearchListPopupFeature.this.modelTable.getControl());
                        CodeSearchListPopupFeature.this.modelModified();
                        CodeSearchListPopupFeature.this.added(selection);
                    }
                }
            }
        });
        this.sourceTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                List selection = CodeSearchListPopupFeature.this.sourceTable.getSelection();
                boolean added = false;
                for (ICode x : selection) {
                    if (!CodeSearchListPopupFeature.this.model.add(x)) continue;
                    added = true;
                    CodeSearchListPopupFeature.this.modelTable.add((Object)x);
                }
                if (added) {
                    UI.autoAdjustColumnWidthToContent((Table)CodeSearchListPopupFeature.this.modelTable.getControl());
                    CodeSearchListPopupFeature.this.modelModified();
                    CodeSearchListPopupFeature.this.added(selection);
                }
            }
        });
        this.modelTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u007f') {
                    List selection = CodeSearchListPopupFeature.this.modelTable.getSelection();
                    CodeSearchListPopupFeature.this.modelTable.removeAll((Collection)selection);
                    CodeSearchListPopupFeature.this.model.removeAll(selection);
                    UI.autoAdjustColumnWidthToContent((Table)CodeSearchListPopupFeature.this.modelTable.getControl());
                    CodeSearchListPopupFeature.this.modelModified();
                    CodeSearchListPopupFeature.this.deleted(selection);
                }
            }
        });
        shell.pack();
        shell.setSize(500, shell.getSize().y);
        this.setPopupFirstFocusControl((Control)searchText);
        return shell;
    }

    private void search(String text) {
        Callback callback = new Callback(){

            public void responseReceived(ReturnObject response) {
                CodeSearchListPopupFeature.this.source = (List)response.getObj();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (CodeSearchListPopupFeature.this.getPopup() != null && !CodeSearchListPopupFeature.this.getPopup().isDisposed()) {
                            CodeSearchListPopupFeature.this.sourceTable.setItems((this).CodeSearchListPopupFeature.this.source);
                            UI.autoAdjustColumnWidthToContent((Table)CodeSearchListPopupFeature.this.sourceTable.getControl());
                        }
                    }
                });
            }
        };
        try {
            EncounterAccessorClient.getInstance().findCode(((Object)((Object)this)).hashCode(), Application.get().getGlobalInstances().getSession(), (ICallback)callback, text, this.classification.id);
        }
        catch (CannotConnectToServerException cannotConnectToServerException) {
            MessageUtil.cannotConnectToServerExceptionMsg();
        }
        catch (Exception exception) {
            callback.kill();
        }
    }

    protected void createTableColumns(MyTable2<E> table) {
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        final ArrayList<SearchColumn> tableColumns = new ArrayList<SearchColumn>();
        if (this.classification == XCodeClassification.LAB_TYPE) {
            SearchColumn sc = new SearchColumn<XLabType>((Table)table.getControl(), "Code"){

                public String getText(XLabType e) {
                    return e.getCode();
                }
            };
            sc.getColumn().setData("maxWidth", (Object)75);
            sc.getColumn().setData("minWidth", (Object)75);
            tableColumns.add(sc);
            sc = new SearchColumn<XLabType>((Table)table.getControl(), "Nom"){

                public String getText(XLabType e) {
                    return e.getName();
                }
            };
            sc.getColumn().setData("minWidth", (Object)150);
            tableColumns.add(sc);
            sc = new SearchColumn<XLabType>((Table)table.getControl(), "Interval"){

                public String getText(XLabType e) {
                    return e.getInterval();
                }
            };
            sc.getColumn().setData("minWidth", (Object)75);
            tableColumns.add(sc);
            sc = new SearchColumn<XLabType>((Table)table.getControl(), "Unit"){

                public String getText(XLabType e) {
                    return e.getUnit();
                }
            };
            sc.getColumn().setData("minWidth", (Object)75);
            tableColumns.add(sc);
        } else {
            SearchColumn sc = new SearchColumn<E>((Table)table.getControl(), "Code"){

                public String getText(ICode e) {
                    return e.getCode();
                }
            };
            sc.getColumn().setData("minWidth", (Object)75);
            tableColumns.add(sc);
            sc = new SearchColumn<E>((Table)table.getControl(), "Description"){

                public String getText(ICode e) {
                    return e.getDescription();
                }
            };
            sc.getColumn().setData("minWidth", (Object)150);
            tableColumns.add(sc);
        }
        table.setLabelProvider(new ProviderAR<E, String[]>(){

            public String[] get(E e) {
                int size = tableColumns.size();
                String[] s = new String[size];
                int i = 0;
                while (i < size) {
                    s[i] = ((SearchColumn)tableColumns.get(i)).getText(e);
                    ++i;
                }
                return s;
            }
        });
        UI.autoAdjustColumnWidthToContent((Table)table.getControl());
    }

    public Set<E> getModel() {
        return this.model;
    }

    protected void modelModified() {
    }

    protected void deleted(List<E> selection) {
    }

    protected void added(List<E> selection) {
    }

    public String getAlias() {
        return this.alias;
    }

    protected void refreshPopup() {
        this.modelTable.setItems(this.model);
    }

    public boolean isShowAlias() {
        return this.showAlias;
    }

    public void setShowAlias(boolean showAlias) {
        this.showAlias = showAlias;
    }

    public boolean isShowModelTable() {
        return this.showModelTable;
    }

    public void setShowModelTable(boolean showModelTable) {
        this.showModelTable = showModelTable;
    }
}

