/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient.search;

import apple.finder.search.ui.ICriteriaOperator;
import ca.infodata.ofys.data.middle.dataobjects.search.CID;
import ca.infodata.ofys.data.middle.dataobjects.search.Operator;
import ca.infodata.ofys.data.middle.dataobjects.search.ServerCriteria;
import ca.infodata.ofys.ui.controls.MyMask;
import ca.infodata.ofys.ui.controls.MyMaskedText;
import ca.infodata.ofys.ui.controls.SWTDelayedListener;
import ca.infodata.ofys.ui.person.patient.search.AbstractCriteria;
import ca.infodata.ofys.ui.person.patient.search.CriteriaOperator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class AbstractTextCriteria
extends AbstractCriteria {
    public static final CriteriaOperator CONTAINS = new CriteriaOperator("contains", "contient", Operator.EQ);
    public static final CriteriaOperator START_WITH = new CriteriaOperator("startwith", "commence par", Operator.EQ);
    public static final CriteriaOperator END_WITH = new CriteriaOperator("endwith", "se termine par", Operator.EQ);
    private MyMask mask;

    public AbstractTextCriteria(CID cid, MyMask mask) {
        super(cid);
        this.mask = mask;
    }

    public AbstractTextCriteria(CID cid, String text, MyMask mask) {
        super(cid, text);
        this.mask = mask;
    }

    public String getOperatorPrefix() {
        return null;
    }

    public List<? extends ICriteriaOperator> getOperators() {
        List<CriteriaOperator> list = Arrays.asList(CriteriaOperator.IS_NULL, CriteriaOperator.EQ, CONTAINS, START_WITH, END_WITH);
        return list;
    }

    public ICriteriaOperator getDefaultOperator() {
        return CriteriaOperator.EQ;
    }

    public Object createValueControl(Composite parent, ICriteriaOperator operator, Object valueReference) {
        if (this.operatorIn(operator, CriteriaOperator.EQ, CONTAINS, START_WITH, END_WITH)) {
            final String[] value = valueReference == null ? new String[1] : valueReference;
            final MyMaskedText text = new MyMaskedText(parent, 2052);
            text.setMask(this.mask);
            text.setText(value[0]);
            text.addListener(24, (Listener)new SWTDelayedListener(1000L, 24){

                public void handleEventOverride(Event e) {
                    value[0] = text.getText().trim();
                }
            });
            return value;
        }
        return null;
    }

    @Override
    public ServerCriteria toCriteria(ICriteriaOperator operator, Object valueReference) {
        ServerCriteria c = new ServerCriteria();
        c.id = this.cid;
        c.operator = ((CriteriaOperator)operator).getOperator();
        if (valueReference != null) {
            String[] text = (String[])valueReference;
            if (text[0] != null) {
                if (operator == CONTAINS) {
                    c.operator = Operator.LIKE;
                    c.value = "%" + text[0] + "%";
                } else if (operator == START_WITH) {
                    c.operator = Operator.LIKE;
                    c.value = String.valueOf(text[0]) + "%";
                } else if (operator == END_WITH) {
                    c.operator = Operator.LIKE;
                    c.value = "%" + text[0];
                } else if (operator == CriteriaOperator.EQ) {
                    c.operator = Operator.EQ;
                    c.value = text[0];
                }
            }
        } else {
            c.value = null;
        }
        return c;
    }

    @Override
    public Map<String, String> valueToXml(ICriteriaOperator operator, Object valueReference) {
        String[] text = (String[])valueReference;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("value", text == null ? null : text[0]);
        return map;
    }

    @Override
    public Object xmlToValue(Map<String, String> map) {
        return new String[]{map.get("value")};
    }
}

