/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient.criteria;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.ui.controls.ControlsPlugin;
import ca.infodata.ofys.ui.controls.MyMaskedText;
import ca.infodata.ofys.ui.controls.MyMasks;
import ca.infodata.ofys.ui.controls.SWTDelayedListener;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.util.IDialogSettings3;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.patient.criteria.Criteria;
import ca.infodata.ofys.ui.person.patient.criteria.TextSearchController;
import ca.infodata.util1.JoinList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TextSearchComposite
extends Composite {
    private static final String ENTER_CTRL_ENTER_TOOLTIP = Messages.getString((String)"RETOUR_RECHERCHE", (String[])new String[0]);
    private static final String NOMPRENOMNO_DE_DOSSIER = Messages.getString((String)"NOMPRENOMNO_DE_DOSSIER", (String[])new String[0]);
    private MyButton btnInMyPatient;
    private MyButton btnFilterBySite;
    private MyLabel lblNameDossier;
    private MyMaskedText txtNameDossier;
    private MyLabel lblSearchDescription;
    private TextSearchController controller;

    public TextSearchComposite(Composite parent, int style, FormToolkit toolkit) {
        super(parent, style);
        this.lblNameDossier = new MyLabel((Composite)this, "NOMPRENOMNO_DE_DOSSIER", 0, toolkit);
        this.lblNameDossier.setToolTipText(NOMPRENOMNO_DE_DOSSIER);
        this.txtNameDossier = new MyMaskedText((Composite)this, 0, toolkit);
        this.txtNameDossier.setMask(MyMasks.standardText);
        this.txtNameDossier.setToolTipText(ENTER_CTRL_ENTER_TOOLTIP);
        this.btnFilterBySite = new MyButton((Composite)this, 2);
        Image image = ResourceGetter.getImage((String)"images/site16_2.png");
        ResourceGetter.linkResourceWithWidgetLife((Object)image, (Widget)this.btnFilterBySite.getControl());
        this.btnFilterBySite.setImage(image);
        final Color original = this.btnFilterBySite.getBackground();
        final Color green = ResourceGetter.getColor((int)0, (int)255, (int)0);
        final IDialogSettings3 settings = ControlsPlugin.getDefault().getSettings();
        if (settings.hasKey("patient_search_site_filter_on")) {
            this.btnFilterBySite.setSelection(settings.getBoolean("patient_search_site_filter_on"));
        } else {
            settings.put("patient_search_site_filter_on", false);
            this.btnFilterBySite.setSelection(false);
        }
        if (this.btnFilterBySite.getSelection()) {
            this.btnFilterBySite.setToolTipText(Messages.getString((String)"NE_PLUS_FILTER_LES_PATIENTS_PAR_SITE", (String[])new String[0]));
            this.btnFilterBySite.setBackground(green);
        } else {
            this.btnFilterBySite.setBackground(original);
            this.btnFilterBySite.setToolTipText(Messages.getString((String)"FILTER_LES_PATIENTS_PAR_SITE", (String[])new String[0]));
        }
        this.btnFilterBySite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.put("patient_search_site_filter_on", TextSearchComposite.this.btnFilterBySite.getSelection());
                if (TextSearchComposite.this.btnFilterBySite.getSelection()) {
                    TextSearchComposite.this.btnFilterBySite.setBackground(green);
                    TextSearchComposite.this.btnFilterBySite.setToolTipText(Messages.getString((String)"NE_PLUS_FILTER_LES_PATIENTS_PAR_SITE", (String[])new String[0]));
                } else {
                    TextSearchComposite.this.btnFilterBySite.setBackground(original);
                    TextSearchComposite.this.btnFilterBySite.setToolTipText(Messages.getString((String)"FILTER_LES_PATIENTS_PAR_SITE", (String[])new String[0]));
                }
            }
        });
        this.btnInMyPatient = new MyButton((Composite)this, Messages.getString((String)"RECHERCHER_PARMI_MES_PATIENTS", (String[])new String[0]), 32, toolkit);
        boolean isProf = PersonUiPlugin.getDefault().getSessionProfessionnal() != null;
        this.btnInMyPatient.setVisible(isProf);
        this.lblSearchDescription = new MyLabel((Composite)this, "", 16384, toolkit);
        this.btnFilterBySite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TextSearchComposite.this.getController().setFilterBySite(TextSearchComposite.this.btnFilterBySite.getSelection());
                TextSearchComposite.this.refresh();
            }
        });
        this.btnInMyPatient.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextSearchComposite.this.getController().setOnlyInMyPatient(TextSearchComposite.this.btnInMyPatient.getSelection());
                TextSearchComposite.this.refresh();
            }
        });
        this.txtNameDossier.addListener(24, (Listener)new SWTDelayedListener(500L, 24){

            public void handleEventOverride(Event e) {
                TextSearchComposite.this.getController().setText(TextSearchComposite.this.txtNameDossier.getText().trim());
                TextSearchComposite.this.refresh();
            }
        });
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        this.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 2);
        data.left = new FormAttachment(this.btnFilterBySite.getControl(), 7);
        this.lblNameDossier.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblNameDossier.getControl(), 1);
        data.left = new FormAttachment(this.btnFilterBySite.getControl(), 7);
        data.right = new FormAttachment(98, -10);
        this.txtNameDossier.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 7);
        data.left = new FormAttachment(0);
        data.bottom = new FormAttachment(this.txtNameDossier.getControl(), 0, 1024);
        this.btnFilterBySite.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtNameDossier.getControl(), 2);
        data.left = new FormAttachment(0);
        this.btnInMyPatient.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.btnInMyPatient.getControl(), 2);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.lblSearchDescription.setLayoutData((Object)data);
        toolkit.adapt((Composite)this);
    }

    public void setController(TextSearchController controller) {
        this.controller = controller;
    }

    private void refresh() {
        JoinList list = new JoinList(", ");
        for (Criteria c : this.controller.getCriterias()) {
            String s = String.valueOf(c.id.text()) + " " + c.operator.text() + " " + c.svalue;
            list.add((CharSequence)s);
        }
        this.lblSearchDescription.setText(list.toString());
    }

    public TextSearchController getController() {
        return this.controller;
    }
}

