/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.AppointmentAccessorClient;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.PatientAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.callback.SaveCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.chat.MessageLink;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.patient.IPatientRelated;
import ca.infodata.ofys.data.middle.dataobjects.patient.XPatientInactiveRaison;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.ICancelablePart;
import ca.infodata.ofys.ui.controls.IMultiPageEditorPart;
import ca.infodata.ofys.ui.controls.IPrintable;
import ca.infodata.ofys.ui.controls.IRefreshablePart;
import ca.infodata.ofys.ui.controls.ISaveablePart;
import ca.infodata.ofys.ui.controls.statusbar.StatusMessageManager;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.PersonMultiEditor;
import ca.infodata.ofys.ui.person.address.AddressControl;
import ca.infodata.ofys.ui.person.contact.ContactInformationControl;
import ca.infodata.ofys.ui.person.patient.PatientEditor;
import ca.infodata.ofys.ui.person.patient.ShowPossibleDuplicatePatientDialog;
import ca.infodata.ofys.ui.person.print.PatientPrintDialog;
import ca.infodata.ofys.ui.person.simple.SimplePatientEditor;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;

public class PatientMultiEditor
extends PersonMultiEditor
implements IPrintable,
ISaveablePart,
ICancelablePart,
IRefreshablePart,
IMultiPageEditorPart,
IPatientRelated {
    private static final String MSG_CONSENTMENT_NEW_PATIENT = Messages.getString((String)"patientMultiEditor.MSG_CONSENTMENT_NEW_PATIENT", (String[])new String[0]);
    private static final String MSG_UNABLE_TO_DELETE_RECALL_AND_FUTURE_APP = Messages.getString((String)"patientMultiEditor.MSG_UNABLE_TO_DELETE_RECALL_AND_FUTURE_APP", (String[])new String[0]);
    private static final Logger logger = Logger.getLogger(SaveCallbackExtension.class.getName());
    private PatientEditor patientEditor;
    private SimplePatientEditor simplePatientEditor;
    private int iNextPage;
    private int iSimplePatientPage;
    private int iGeneralPage;

    public void initDataOverride() {
        IDataObject dataObject = ((EditorInput)this.getEditorInput()).getDataObject();
        if (dataObject.getId() == null) {
            StatusMessageManager.getInstance().setMessage("PatientMultiEditor", MSG_CONSENTMENT_NEW_PATIENT, 20);
            XPatient patient = new XPatient();
            patient.initialize();
            this.initializeCompleteDataObject((EditableDataObject)patient);
        } else {
            JobCallback callback = null;
            try {
                try {
                    callback = new JobCallback(Messages.getString((String)"CHARGEMENT", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

                        public void responseReceived(final ReturnObject response) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    Object object = response.getObj();
                                    if (object == null) {
                                        PatientMultiEditor.this.doClose();
                                    } else if (object instanceof XPatient[] && ((XPatient[])response.getObj()).length == 1 && ((XPatient[])response.getObj())[0] != null) {
                                        PatientMultiEditor.this.initializeCompleteDataObject((EditableDataObject)((XPatient[])response.getObj())[0]);
                                    } else if (object instanceof XPatient) {
                                        PatientMultiEditor.this.initializeCompleteDataObject((EditableDataObject)((XPatient)response.getObj()));
                                    } else {
                                        PatientMultiEditor.this.doClose();
                                    }
                                }
                            });
                        }
                    };
                    PatientAccessorClient.getInstance().getPatient(this.getUniqueKey(), Application.get().getGlobalInstances().getSession(), (ICallback)callback, dataObject.getId().intValue());
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Erreur", e);
                    if (callback != null) {
                        callback.kill();
                    }
                }
            }
            finally {
                if (callback != null) {
                    callback.kill();
                }
            }
        }
    }

    public void createMyPages() throws PartInitException {
        this.iNextPage = 0;
        this.simplePatientEditor = new SimplePatientEditor(this);
        this.addPage(this.simplePatientEditor, this.getEditorInput());
        this.setPageText(this.iNextPage, Messages.getString((String)"SIMPLE", (String[])new String[0]));
        this.setPageImage(this.iNextPage, ResourceGetter.getImage((String)"images/pen.gif"));
        this.iSimplePatientPage = this.iNextPage++;
        this.patientEditor = new PatientEditor(this);
        this.addPage(this.patientEditor, this.getEditorInput());
        this.setPageText(this.iNextPage, Messages.getString((String)"COMPLET", (String[])new String[0]));
        this.setPageImage(this.iNextPage, ResourceGetter.getImage((String)"images/pen.gif"));
        this.iGeneralPage = this.iNextPage++;
    }

    public void print() {
        if (!super.print2()) {
            if (this.isDirty()) {
                Runnable printCallback = new Runnable(){

                    @Override
                    public void run() {
                        if (PatientMultiEditor.this.getLastSaveOrDeleteStatus() != null && PatientMultiEditor.this.getLastSaveOrDeleteStatus().isOK() && PatientMultiEditor.this.getPatient() != null && !PatientMultiEditor.this.isDirty()) {
                            PatientPrintDialog dialog = new PatientPrintDialog(PatientMultiEditor.this.getSite().getShell(), PatientMultiEditor.this.getPatient());
                            UI.centerComposite((Composite)dialog.getShell(), (Composite)PatientMultiEditor.this.getEditorSite().getShell());
                            dialog.open();
                        }
                    }
                };
                this.doSave(printCallback);
            } else if (this.getPatient() != null) {
                PatientPrintDialog dialog = new PatientPrintDialog(this.getSite().getShell(), this.getPatient());
                UI.centerComposite((Composite)dialog.getShell(), (Composite)this.getEditorSite().getShell());
                dialog.open();
            }
        }
    }

    public void doSave(IProgressMonitor progress) {
        this.doSave(null, new SaveCallbackExtension(this, Application.get().getGlobalInstances().getSession()), true);
    }

    public void doSave(Runnable runnable) {
        this.doSave(runnable, new SaveCallbackExtension(this, Application.get().getGlobalInstances().getSession()), true);
    }

    public XPatient getPatient() {
        return (XPatient)this.getPerson();
    }

    public XPatient getInitialPatient() {
        return (XPatient)((EditorInput)this.getEditorInput()).getInitialCompleteDataObject();
    }

    public IDataObject getBasePatient() {
        EditorInput input = (EditorInput)this.getEditorInput();
        return input == null ? null : input.getDataObject();
    }

    public BaseAccessorClient getAccessor() throws CannotConnectToServerException {
        return PatientAccessorClient.getInstance();
    }

    public boolean isDataDirty() {
        return this.getPatient().isDirty();
    }

    public Image getEditorTitleImage() {
        return ResourceGetter.getImage((String)"images/persons-icon32.png");
    }

    public AddressControl getAddress() {
        return this.patientEditor.getAddress();
    }

    public ContactInformationControl getContact() {
        return this.patientEditor.getContact();
    }

    protected void pageChange(int newPageIndex) {
        if (this.isUILoaded()) {
            if (newPageIndex == this.iGeneralPage && this.isDirty()) {
                this.showDataObject(this.iGeneralPage);
            } else if (newPageIndex == this.iSimplePatientPage && this.isDirty()) {
                this.showDataObject(this.iSimplePatientPage);
            }
        }
        super.pageChange(newPageIndex);
    }

    public MessageLink getMessageLink() {
        return null;
    }

    public int getiSimplePatientPage() {
        return this.iSimplePatientPage;
    }

    public int getiGeneralPage() {
        return this.iGeneralPage;
    }

    @Override
    protected boolean showInactivationCondition(boolean forDcd) {
        if (this.patientEditor != null) {
            return this.patientEditor.showInactivationCondition(forDcd);
        }
        return false;
    }

    @Override
    protected String getInactiveText() {
        return this.patientEditor.getInactiveText();
    }

    @Override
    protected XPatientInactiveRaison getInactiveRaison() {
        return this.patientEditor.getInactiveRaison();
    }

    @Override
    public void setInactiveRaison(XPatientInactiveRaison r) {
        this.patientEditor.setInactiveRaison(r);
    }

    public boolean isPrintAllowed() {
        XPatient patient = this.getPatient();
        return patient != null && patient.getId() != null && !this.isDirty();
    }

    private static class SaveCallbackExtension
    extends SaveCallback {
        private static final Logger logger = Logger.getLogger(SaveCallbackExtension.class.getName());
        private final PatientMultiEditor editor;

        public SaveCallbackExtension(PatientMultiEditor editor, XSession session) {
            super(session, (IStatusHandler)DefaultStatusHandler.getInstance());
            this.editor = editor;
        }

        protected boolean handleStatus(ReturnObject response) {
            try {
                if (response != null) {
                    logger.log(Level.FINE, String.valueOf(response.getStatus()));
                    final IStatus status = response.getStatus().getStatus("DUPLICATE_PATIENT");
                    if (status == null) {
                        super.handleStatus(response);
                    } else {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                Shell shell = editor.getShell();
                                if (shell != null && !shell.isDisposed()) {
                                    List patients = (List)((Object)status.getData());
                                    ShowPossibleDuplicatePatientDialog dialog = new ShowPossibleDuplicatePatientDialog(shell, patients);
                                    if (dialog.isAddNewPatient()) {
                                        editor.doSave(null, this, false);
                                    } else if (dialog.isUseSelectedPatient() && dialog.getSelectedPatient() != null) {
                                        editor.changeEditorInput((IEditorInput)new EditorInput((IDataObject)dialog.getSelectedPatient()));
                                    } else {
                                        return;
                                    }
                                }
                            }
                        });
                    }
                    if (response.getStatus() != null && response.getStatus().isOkToProceed() && this.editor != null && this.editor.getPatient() != null && this.editor.getPatient().mustDeleteFutureAppointmentAndReccallOnDelete && this.editor.getPatient().getIsDeleted().booleanValue()) {
                        AppointmentAccessorClient.getInstance().suppressPatientRecallAndFutureAppointment(this.getSession(), (ICallback)new Callback(){

                            public void responseReceived(ReturnObject response) {
                                if (!response.getStatus().isOkToProceed()) {
                                    logger.log(Level.SEVERE, "I got a very VERY VERY BIG PROBLEM while trying to delete future appointment and recall!");
                                    MessageUtil.warningMsg((Shell)editor.getShell(), (String)MSG_UNABLE_TO_DELETE_RECALL_AND_FUTURE_APP);
                                }
                            }
                        }, this.editor.getPatient().getId().intValue());
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in Callback status handling. " + this.toString(), e);
            }
            return true;
        }
    }
}

