/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.PreferencesAccessorClient;
import ca.infodata.ofys.data.dataaccess.util.ObjectCache;
import ca.infodata.ofys.data.dataaccess.util.notification.IConsumerListener;
import ca.infodata.ofys.data.middle.dataobjects.XPersonGroup;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.notification.Notification;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class PersonGroupCache
extends ObjectCache<XPersonGroup> {
    private static final Logger logger = Logger.getLogger(PersonGroupCache.class.getName());
    private static final String PERSON_GROUP = "person-group";
    private IConsumerListener listener = new IConsumerListenerImplementation();

    public PersonGroupCache() {
        super(PERSON_GROUP);
        Application.get().getGlobalInstances().getNotificationSystem().addListener(this.listener);
    }

    protected void load(int uniqueKey, XSession session, ICallback callback) throws Exception {
        PreferencesAccessorClient.getInstance().findPersonGroups(session, callback, true);
    }

    protected void loadSync(int uniqueKey, XSession session, ICallback callback) throws Exception {
        PreferencesAccessorClient.getInstance().findPersonGroups(session, callback, false);
    }

    protected void add(Map<ObjectCache.Key, XPersonGroup> map, XPersonGroup e) {
        if (e != null) {
            map.put(new ObjectCache.Key(PERSON_GROUP, e.getId()), e);
        }
    }

    public XPersonGroup getById(Integer id, boolean logIfNotFound) {
        return this.getById(id, logIfNotFound, true);
    }

    public XPersonGroup getById(Integer id, boolean logIfNotFound, boolean mustTryToFindServer) {
        if (id == null) {
            return null;
        }
        return (XPersonGroup)this.get(new ObjectCache.Key(PERSON_GROUP, id), logIfNotFound, mustTryToFindServer);
    }

    protected XPersonGroup loadSync(XSession session, ObjectCache.Key key) throws Exception {
        if (key == null) {
            return null;
        }
        if (PERSON_GROUP.equals(key.type)) {
            this.reload(true);
            return (XPersonGroup)this.get(key, false, false);
        }
        return null;
    }

    public Stream<XPersonGroup> getAll() {
        return this.getMap().values().stream().sorted();
    }

    public Stream<XPersonGroup> getAllActive() {
        return this.getAll().filter(e -> !Boolean.TRUE.equals(e.getIsDeleted()));
    }

    private final class IConsumerListenerImplementation
    implements IConsumerListener {
        private IConsumerListenerImplementation() {
        }

        public void handle(DataObjectUpdatedNotification notification) {
            try {
                IDataObject object;
                if (notification != null && (object = notification.getObject()) instanceof XPersonGroup) {
                    PersonGroupCache.this.add((Map<ObjectCache.Key, XPersonGroup>)PersonGroupCache.this.getMap(), (XPersonGroup)object);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in IConsumerListenerImplementation.handle", e);
            }
        }

        public void handleOther(Notification notification) {
        }

        public void forceRefresh() {
            try {
                PersonGroupCache.this.reload(true);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in PersonGroupCache.forceRefresh", e);
            }
        }
    }
}

