/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.encounter.patient.search;

import apple.finder.search.ui.ICriteriaOperator;
import ca.infodata.ofys.data.middle.dataobjects.encounter.AHFS;
import ca.infodata.ofys.data.middle.dataobjects.search.CID;
import ca.infodata.ofys.data.middle.dataobjects.search.Operator;
import ca.infodata.ofys.data.middle.dataobjects.search.ServerCriteria;
import ca.infodata.ofys.ui.encounter.patient.search.AHFSSearchPopupFeature;
import ca.infodata.ofys.ui.person.patient.search.AbstractCriteria;
import ca.infodata.ofys.ui.person.patient.search.CriteriaOperator;
import ca.infodata.util1.IPair;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.MutablePair;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class DrugATCCriteria
extends AbstractCriteria {
    public DrugATCCriteria() {
        super(CID.DRUG_AHFS);
    }

    public String getOperatorPrefix() {
        return null;
    }

    public List<? extends ICriteriaOperator> getOperators() {
        List<CriteriaOperator> list = Arrays.asList(CriteriaOperator.IN);
        return list;
    }

    public ICriteriaOperator getDefaultOperator() {
        return CriteriaOperator.IN;
    }

    public Object createValueControl(Composite parent, ICriteriaOperator operator, Object valueReference) {
        final MutablePair value = (MutablePair)(valueReference == null ? new MutablePair() : valueReference);
        value.first = value.first == null ? new LinkedHashSet() : (Set)value.first;
        value.second = value.second == null ? "" : (String)value.second;
        final Label label = new Label(parent, 18432);
        label.setText(this.computeLabel((Set)value.getFirst(), (String)value.getSecond()));
        final AHFSSearchPopupFeature feature = new AHFSSearchPopupFeature((Control)label, (Set)value.getFirst(), (String)value.getSecond()){

            @Override
            protected void modelModified() {
                value.second = this.getAlias();
                label.setText(DrugATCCriteria.this.computeLabel((Set)value.getFirst(), (String)value.getSecond()));
            }
        };
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                feature.openPopupWindow();
            }
        });
        return value;
    }

    protected String computeLabel(Set<AHFS> list, String alias) {
        if (StringUtils.isNotBlank((String)alias)) {
            return alias;
        }
        JoinList joinList = new JoinList(",", list.size());
        for (AHFS e : list) {
            joinList.add((CharSequence)e.id);
        }
        if (joinList.size() == 0) {
            return "Cliquez ici pour ouvrir le dialogue de s\u00e9lection";
        }
        return joinList.toString();
    }

    @Override
    public ServerCriteria toCriteria(ICriteriaOperator operator, Object valueReference) {
        IPair value = (IPair)valueReference;
        ServerCriteria c = new ServerCriteria();
        c.id = this.cid;
        c.operator = Operator.IN;
        ArrayList<String> list = new ArrayList<String>();
        for (AHFS atc : (Set)value.getFirst()) {
            list.add(atc.id);
        }
        c.value = list;
        return c;
    }

    @Override
    public Map<String, String> valueToXml(ICriteriaOperator operator, Object valueReference) {
        IPair value = (IPair)valueReference;
        HashMap<String, String> map = new HashMap<String, String>();
        JoinList joinList = new JoinList(",");
        if (value.getFirst() != null) {
            for (AHFS a : (Set)value.getFirst()) {
                joinList.add((CharSequence)(String.valueOf(a.id) + ";" + a.desc));
            }
        }
        map.put("ahfs", joinList.toString());
        map.put("alias", (String)value.getSecond());
        return map;
    }

    @Override
    public Object xmlToValue(Map<String, String> map) {
        String[] split;
        MutablePair value = new MutablePair();
        value.first = new LinkedHashSet();
        value.second = map.remove("alias");
        String stacs = map.get("ahfs");
        String[] stringArray = split = stacs.split(",");
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String satc = stringArray[n2];
            AHFS a = new AHFS();
            String[] split2 = StringUtils.splitNonDescructive((String)satc, (char)';');
            if (split2.length > 0) {
                a.id = split2[0];
                if (split2.length > 1) {
                    a.desc = split2[1];
                }
                ((Set)value.first).add(a);
            }
            ++n2;
        }
        return value;
    }
}

