/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.util.bean;

import java.beans.PropertyEditor;
import java.util.HashMap;
import java.util.Map;

public class PropertyEditorContext {
    protected Map targetClass2PropertyEditorClass = new HashMap();
    protected Map propertyName2PropertyEditor = new HashMap();

    public void registerEditor(Class targetType, Class editorClass) {
        if (targetType == null) {
            throw new NullPointerException("Param targetType must not be null!");
        }
        if (editorClass == null) {
            throw new NullPointerException("Param editorClass must not be null!");
        }
        this.targetClass2PropertyEditorClass.put(targetType, editorClass);
    }

    public void registerEditor(Object target, Class editorClass) {
        if (target == null) {
            throw new IllegalArgumentException("Param target must not be null!");
        }
        Class<?> targetClass = target.getClass();
        this.registerEditor(targetClass, editorClass);
    }

    public void registerEditor(String propertyName, Class editorClass) {
        if (propertyName == null) {
            throw new NullPointerException("Param propertyName must not be null!");
        }
        if (editorClass == null) {
            throw new NullPointerException("Param editorClass must not be null!");
        }
        this.propertyName2PropertyEditor.put(propertyName, editorClass);
    }

    public PropertyEditor getEditor(Object o) throws IllegalAccessException, InstantiationException {
        if (o == null) {
            throw new IllegalArgumentException("Param o must not be null!");
        }
        Class<?> targetClass = o.getClass();
        PropertyEditor pe = this.getEditor(targetClass);
        if (pe != null) {
            return pe;
        }
        for (Class targetType : this.targetClass2PropertyEditorClass.keySet()) {
            if (!targetType.isAssignableFrom(targetClass)) continue;
            return (PropertyEditor)this.targetClass2PropertyEditorClass.get(targetType);
        }
        return null;
    }

    public PropertyEditor getEditor(Class targetType) throws InstantiationException, IllegalAccessException {
        if (this.targetClass2PropertyEditorClass.containsKey(targetType)) {
            Class pecClass = (Class)this.targetClass2PropertyEditorClass.get(targetType);
            PropertyEditor pe = (PropertyEditor)pecClass.newInstance();
            return pe;
        }
        return null;
    }

    public PropertyEditor getEditor(String propertyName) {
        if (this.propertyName2PropertyEditor.containsKey(propertyName)) {
            PropertyEditor pe = (PropertyEditor)this.propertyName2PropertyEditor.get(propertyName);
            return pe;
        }
        return null;
    }
}

