/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.util;

import java.util.ArrayList;
import java.util.HashMap;
import org.nightlabs.util.DeadLockException;
import org.nightlabs.util.RWLockMan;
import org.nightlabs.util.RWLockable;

public class RWLock
implements RWLockable {
    private int currentLocks = 0;
    private Thread currentWriteThread = null;
    private HashMap currentReadThreads = new HashMap();
    private HashMap savedReadLocks = new HashMap();
    private int waitingWriters = 0;
    private int waitingReaders = 0;
    private Object mutex = new Object();
    private RWLockMan rwLockMan;
    private String rwLockName = null;
    private HashMap lockStacksByThread = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentLockStatus() {
        Object object = this.mutex;
        synchronized (object) {
            return this.currentLocks;
        }
    }

    public RWLock() {
        this.rwLockMan = RWLockMan.getRWLockMan();
    }

    public RWLock(String _rwLockName) {
        this();
        this.rwLockName = _rwLockName;
    }

    public RWLock(String _rwLockName, boolean appendMemAddr) {
        this();
        if (appendMemAddr) {
            StringBuffer sb = new StringBuffer(_rwLockName.length() + 10);
            sb.append(_rwLockName);
            sb.append('@');
            sb.append(Integer.toHexString(this.hashCode()));
            this.rwLockName = sb.toString();
        } else {
            this.rwLockName = _rwLockName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWaitingWriters() {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitingWriters;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWaitingReaders() {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitingReaders;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable getCurrentWriteThread() {
        Object object = this.mutex;
        synchronized (object) {
            return this.currentWriteThread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquireReadLock() throws DeadLockException {
        ReadLockCount rlc = null;
        Object object = this.mutex;
        synchronized (object) {
            Thread currentThread;
            block18: {
                currentThread = Thread.currentThread();
                ++this.waitingReaders;
                try {
                    if (this.currentWriteThread == currentThread || (rlc = (ReadLockCount)this.currentReadThreads.get(currentThread)) != null && rlc.readLockCount != 0) break block18;
                    if (this.currentLocks < 0 || this.waitingWriters != 0) {
                        this.rwLockMan.beginWaitForLock(this, (byte)120);
                        try {
                            try {
                                while (this.currentLocks < 0 || this.waitingWriters != 0) {
                                    this.mutex.wait();
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                throw new IllegalThreadStateException("Waiting interrupted. Can't continue work in this situation, because threads my collide!");
                            }
                        }
                        finally {
                            this.rwLockMan.endWaitForLock(this, (byte)120);
                        }
                    }
                    if (rlc == null) {
                        rlc = new ReadLockCount();
                        this.currentReadThreads.put(currentThread, rlc);
                    }
                }
                finally {
                    --this.waitingReaders;
                }
            }
            this.rwLockMan.acquireLock(this, (byte)120, 1);
            ArrayList<Boolean> lockStack = (ArrayList<Boolean>)this.lockStacksByThread.get(currentThread);
            if (lockStack == null) {
                lockStack = new ArrayList<Boolean>();
                this.lockStacksByThread.put(currentThread, lockStack);
            }
            lockStack.add(new Boolean(false));
            if (this.currentLocks >= 0) {
                ++this.currentLocks;
                ++rlc.readLockCount;
            } else {
                rlc = (ReadLockCount)this.savedReadLocks.get(currentThread);
                if (rlc == null) {
                    rlc = new ReadLockCount();
                    this.savedReadLocks.put(currentThread, rlc);
                }
                ++rlc.readLockCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquireWriteLock() throws DeadLockException {
        Object object = this.mutex;
        synchronized (object) {
            Thread currentThread;
            block17: {
                currentThread = Thread.currentThread();
                ++this.waitingWriters;
                try {
                    block18: {
                        if (currentThread == this.currentWriteThread) break block17;
                        boolean endWaitInRWLockMan = false;
                        if (this.currentLocks != 0) {
                            this.rwLockMan.beginWaitForLock(this, (byte)121);
                            endWaitInRWLockMan = true;
                        }
                        try {
                            ReadLockCount rlc = (ReadLockCount)this.currentReadThreads.get(currentThread);
                            if (rlc != null && rlc.readLockCount > 0) {
                                this.savedReadLocks.put(currentThread, rlc);
                                this.currentReadThreads.remove(currentThread);
                                this.currentLocks -= rlc.readLockCount;
                                if (this.currentLocks < 0) {
                                    throw new IllegalStateException(currentThread + ": currentLocks < 0!!!");
                                }
                                this.rwLockMan.releaseLock(this, (byte)120, rlc.readLockCount);
                                this.mutex.notifyAll();
                            }
                            if (this.currentLocks == 0) break block18;
                            try {
                                while (this.currentLocks != 0) {
                                    this.mutex.wait();
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                throw new IllegalThreadStateException(currentThread + ": Waiting interrupted. Can't continue work in this situation, because threads my collide!");
                            }
                        }
                        finally {
                            if (endWaitInRWLockMan) {
                                this.rwLockMan.endWaitForLock(this, (byte)121);
                            }
                        }
                    }
                    this.currentWriteThread = currentThread;
                }
                finally {
                    --this.waitingWriters;
                }
            }
            this.rwLockMan.acquireLock(this, (byte)121, 1);
            ArrayList<Boolean> lockStack = (ArrayList<Boolean>)this.lockStacksByThread.get(currentThread);
            if (lockStack == null) {
                lockStack = new ArrayList<Boolean>();
                this.lockStacksByThread.put(currentThread, lockStack);
            }
            lockStack.add(new Boolean(true));
            --this.currentLocks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseLock() {
        Object object = this.mutex;
        synchronized (object) {
            Thread currentThread = Thread.currentThread();
            if (this.currentLocks == 0) {
                throw new IllegalStateException(currentThread + ": currentLocks == 0: releaseLock called without previous acquire!");
            }
            ArrayList lockStack = (ArrayList)this.lockStacksByThread.get(currentThread);
            if (lockStack == null) {
                throw new IllegalStateException(currentThread + ": No lock stack registered for current thread!");
            }
            if (lockStack.isEmpty()) {
                throw new IllegalStateException(currentThread + ": lock stack of current thread is empty!");
            }
            Boolean releaseWriteLock = (Boolean)lockStack.remove(lockStack.size() - 1);
            if (releaseWriteLock.booleanValue()) {
                if (this.currentLocks > 0) {
                    throw new IllegalStateException(currentThread + ": currentLocks > 0, but we are trying to release a write lock!");
                }
                ++this.currentLocks;
                if (this.currentLocks == 0) {
                    this.currentWriteThread = null;
                    ReadLockCount rlc = (ReadLockCount)this.savedReadLocks.remove(currentThread);
                    if (rlc != null && rlc.readLockCount > 0) {
                        this.currentLocks += rlc.readLockCount;
                        this.currentReadThreads.put(currentThread, rlc);
                        this.rwLockMan.acquireLock(this, (byte)120, rlc.readLockCount);
                    }
                }
                this.rwLockMan.releaseLock(this, (byte)121, 1);
            } else {
                if (this.currentLocks < 0) {
                    if (currentThread != this.currentWriteThread) {
                        throw new IllegalStateException(currentThread + ": Current thread is not current write thread! Why are we here?");
                    }
                    ReadLockCount rlc = (ReadLockCount)this.savedReadLocks.get(currentThread);
                    if (rlc == null || rlc.readLockCount == 0) {
                        throw new IllegalStateException(currentThread + ": Current thread does not have a read lock set, but tries to release one!");
                    }
                    --rlc.readLockCount;
                } else {
                    ReadLockCount rlc = (ReadLockCount)this.currentReadThreads.get(currentThread);
                    if (rlc == null || rlc.readLockCount == 0) {
                        throw new IllegalStateException(currentThread + ": Current thread does not have a read lock set, but tries to release one!");
                    }
                    --this.currentLocks;
                    --rlc.readLockCount;
                }
                this.rwLockMan.releaseLock(this, (byte)120, 1);
            }
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.mutex;
        synchronized (object) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getName());
            if (this.rwLockName == null) {
                sb.append('@');
                sb.append(Integer.toHexString(this.hashCode()));
                sb.append('{');
            } else {
                sb.append("{name=");
                sb.append(this.rwLockName);
                sb.append(',');
            }
            sb.append("status=");
            sb.append(this.currentLocks);
            sb.append(",waitingReaders=");
            sb.append(this.waitingReaders);
            sb.append(",waitingWriters=");
            sb.append(this.waitingWriters);
            sb.append(",currentWriteThread=");
            sb.append(this.currentWriteThread);
            sb.append('}');
            return sb.toString();
        }
    }

    private static class ReadLockCount {
        public int readLockCount = 0;

        private ReadLockCount() {
        }
    }
}

