/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.print.page;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.nightlabs.print.page.A3Page;
import org.nightlabs.print.page.A4Page;
import org.nightlabs.print.page.A5Page;
import org.nightlabs.print.page.IPredefinedPage;

public class PredefinedPageRegistry {
    private static PredefinedPageRegistry pageRegistry = null;
    private Set<IPredefinedPage> pages = new LinkedHashSet<IPredefinedPage>();
    private Map<String, IPredefinedPage> pageID2Page = new HashMap<String, IPredefinedPage>();

    protected PredefinedPageRegistry() {
        this.addPredefinedPage(new A4Page());
        this.addPredefinedPage(new A3Page());
        this.addPredefinedPage(new A5Page());
    }

    public static PredefinedPageRegistry sharedInstance() {
        if (pageRegistry == null) {
            pageRegistry = new PredefinedPageRegistry();
        }
        return pageRegistry;
    }

    public void addPredefinedPage(IPredefinedPage page) {
        if (page == null) {
            throw new IllegalArgumentException("Param page must not be null!");
        }
        this.pages.add(page);
        this.pageID2Page.put(page.getPageID(), page);
    }

    public void removePredefinedPage(IPredefinedPage page) {
        this.pages.remove(page);
        if (page != null) {
            this.pageID2Page.remove(page.getPageID());
        }
    }

    public Set<IPredefinedPage> getPages() {
        return this.pages;
    }

    public IPredefinedPage getPage(String pageID) {
        return this.pageID2Page.get(pageID);
    }

    public Set<String> getPageIDs() {
        return this.pageID2Page.keySet();
    }
}

