/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.pdf;

import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import javax.print.PrintServiceLookup;
import org.apache.pdfbox.contentstream.operator.MissingOperandException;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.contentstream.operator.OperatorProcessor;
import org.apache.pdfbox.contentstream.operator.graphics.GraphicsOperatorProcessor;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.MissingResourceException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.printing.PDFPrintable;
import org.apache.pdfbox.printing.Scaling;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.rendering.PageDrawer;
import org.apache.pdfbox.rendering.PageDrawerParameters;

public class OpaquePDFRenderer
extends PDFRenderer {
    private static final Logger logger = Logger.getLogger(OpaquePDFRenderer.class.getName());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws IOException, PrinterException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            InputStream is = new URL("https://github.com/qzind/tray/files/1749977/test.pdf").openStream();
            try {
                try (PDDocument doc = PDDocument.load((InputStream)is);){
                    OpaquePDFRenderer renderer = new OpaquePDFRenderer(doc);
                    PDFPrintable printable = new PDFPrintable(doc, Scaling.SCALE_TO_FIT, false, 0.0f, true, (PDFRenderer)renderer);
                    PrinterJob job = PrinterJob.getPrinterJob();
                    job.setPrintService(PrintServiceLookup.lookupDefaultPrintService());
                    job.setPrintable((Printable)printable);
                    if (job.printDialog()) {
                        job.print();
                    }
                }
                if (is == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            is.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public OpaquePDFRenderer(PDDocument document) {
        super(document);
    }

    protected PageDrawer createPageDrawer(PageDrawerParameters parameters) throws IOException {
        return new OpaquePageDrawer(parameters);
    }

    private static class OpaqueDrawObject
    extends GraphicsOperatorProcessor {
        private OpaqueDrawObject() {
        }

        public void process(Operator operator, List<COSBase> operands) throws IOException {
            if (operands.isEmpty()) {
                throw new MissingOperandException(operator, operands);
            }
            COSBase base0 = operands.get(0);
            if (!(base0 instanceof COSName)) {
                return;
            }
            COSName objectName = (COSName)base0;
            PDXObject xobject = this.context.getResources().getXObject(objectName);
            if (xobject == null) {
                throw new MissingResourceException("Missing XObject: " + objectName.getName());
            }
            if (xobject instanceof PDImageXObject) {
                PDImageXObject image = (PDImageXObject)xobject;
                this.context.drawImage((PDImage)image);
            } else if (xobject instanceof PDFormXObject) {
                try {
                    this.context.increaseLevel();
                    if (this.context.getLevel() > 50) {
                        logger.severe("recursion is too deep, skipping form XObject");
                        return;
                    }
                    this.context.showForm((PDFormXObject)xobject);
                }
                finally {
                    this.context.decreaseLevel();
                }
            }
        }

        public String getName() {
            return "Do";
        }
    }

    private class OpaquePageDrawer
    extends PageDrawer {
        public OpaquePageDrawer(PageDrawerParameters parameters) throws IOException {
            super(parameters);
            this.addOperator((OperatorProcessor)new OpaqueDrawObject());
        }
    }
}

