/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.library.log;

import ca.infodata.ofys.ui.library.log.LoggerTree;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class TestTreeViewer {
    private final TreeViewer v;

    public TestTreeViewer(Composite parent) {
        Tree tree = new Tree(parent, 66306);
        this.v = new TreeViewer(tree);
        this.v.getTree().setLinesVisible(true);
        this.v.getTree().setHeaderVisible(true);
        TreeViewerColumn c1 = new TreeViewerColumn(this.v, 0);
        c1.getColumn().setWidth(200);
        c1.getColumn().setMoveable(false);
        c1.getColumn().setText("Name");
        c1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                LoggerTree.Node node = (LoggerTree.Node)element;
                return node.logger.getName();
            }
        });
        TreeViewerColumn c2 = new TreeViewerColumn(this.v, 0);
        c2.getColumn().setWidth(200);
        c2.getColumn().setMoveable(false);
        c2.getColumn().setText("Level");
        c2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                LoggerTree.Node node = (LoggerTree.Node)element;
                return node.getLevel().getName();
            }
        });
        this.v.getTree().setMenu(this.createMenu());
        this.v.setContentProvider((IContentProvider)new LoggerContentProvider());
        this.v.setInput(this.getInput());
    }

    public TreeViewer getTreeViewer() {
        return this.v;
    }

    private Object getInput() {
        return new Object[]{LoggerTree.getRootNode()};
    }

    private Menu createMenu() {
        Menu menu = new Menu((Control)this.v.getTree());
        MenuItem mrefresh = new MenuItem(menu, 64);
        mrefresh.setText("refresh");
        mrefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestTreeViewer.this.refresh();
            }
        });
        MenuItem msetLevel = new MenuItem(menu, 64);
        msetLevel.setText("set level");
        Menu submenu = new Menu(menu);
        msetLevel.setMenu(submenu);
        LoggerTree.ELevel[] eLevelArray = LoggerTree.ELevel.values();
        int n = eLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            LoggerTree.ELevel elevel = eLevelArray[n2];
            MenuItem choiceLevel = new MenuItem(submenu, 8);
            choiceLevel.setData("elevel", (Object)elevel);
            choiceLevel.setText(elevel.toString());
            choiceLevel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MenuItem choiceItem = (MenuItem)e.getSource();
                    LoggerTree.ELevel eelevel = (LoggerTree.ELevel)((Object)choiceItem.getData("elevel"));
                    ITreeSelection selection = (ITreeSelection)TestTreeViewer.this.v.getSelection();
                    if (!selection.isEmpty()) {
                        for (LoggerTree.Node node : selection) {
                            if (node.isRoot() && eelevel == LoggerTree.ELevel.NONE) continue;
                            node.logger.setLevel(eelevel.level);
                        }
                        TestTreeViewer.this.v.refresh(true);
                    }
                }
            });
            ++n2;
        }
        return menu;
    }

    public void refresh() {
        this.v.setInput(this.getInput());
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        new TestTreeViewer((Composite)shell);
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static class LoggerContentProvider
    implements ITreeContentProvider {
        private LoggerTree.Node[] empy_array = new LoggerTree.Node[0];

        private LoggerContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Object[]) {
                return (Object[])parentElement;
            }
            if (parentElement instanceof LoggerTree.Node) {
                LoggerTree.Node node = (LoggerTree.Node)parentElement;
                return node.children.toArray();
            }
            return this.empy_array;
        }

        public Object getParent(Object element) {
            if (element instanceof LoggerTree.Node) {
                LoggerTree.Node node = (LoggerTree.Node)element;
                return node.parent;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            LoggerTree.Node node = (LoggerTree.Node)element;
            return !node.children.isEmpty();
        }
    }
}

