/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.library.h2cache;

import ca.infodata.ofys.ui.library.h2cache.AbstractEncryptedFileSystem;
import ca.infodata.util1.ByteSerialiser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class BigDataEncryptedFileSystem
extends AbstractEncryptedFileSystem {
    private static final Logger logger = Logger.getLogger(BigDataEncryptedFileSystem.class.getName());

    public BigDataEncryptedFileSystem(File file, String filePassword) throws ClassNotFoundException, SQLException {
        super(file, filePassword);
        this.initDatabase();
    }

    protected void initDatabase() throws SQLException {
        Statement s = this.connection.createStatement();
        s.execute("CREATE TABLE IF NOT EXISTS BIGDATA (KEY VARCHAR PRIMARY KEY, VALUE BLOB, TYPE VARCHAR);");
    }

    public Object get(String key) {
        Object object;
        block8: {
            if (key == null) {
                throw new NullPointerException("key cant be null");
            }
            PreparedStatement s = null;
            ResultSet rs = null;
            object = null;
            try {
                try {
                    s = this.connection.prepareStatement("select value, type from bigdata where key = ?;");
                    s.setString(1, key);
                    rs = s.executeQuery();
                    if (rs.next()) {
                        InputStream binaryStream = rs.getBinaryStream(1);
                        String type = rs.getString(2);
                        object = this.readObjectFromType(type, binaryStream);
                        if (rs.next()) {
                            logger.log(Level.SEVERE, "More than 1 value (row) matching key " + key);
                        }
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to get value for key " + key, e);
                    BigDataEncryptedFileSystem.closeAll(rs, s, null);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                BigDataEncryptedFileSystem.closeAll(rs, s, null);
                throw throwable;
            }
            BigDataEncryptedFileSystem.closeAll(rs, s, null);
        }
        return object;
    }

    private Object readObjectFromType(String type, InputStream binaryStream) throws Exception {
        if (type == null) {
            return null;
        }
        if (type.equals("file")) {
            String path = IOUtils.toString((InputStream)binaryStream, (Charset)Charset.defaultCharset());
            return new File(path);
        }
        if (type.equals("string")) {
            return IOUtils.toString((InputStream)binaryStream, (Charset)StandardCharsets.UTF_8);
        }
        if (type.equals("byte[]")) {
            return IOUtils.toByteArray((InputStream)binaryStream);
        }
        if (type.equals("serializable")) {
            return ByteSerialiser.deserialize((InputStream)binaryStream);
        }
        return binaryStream;
    }

    public void putIfAbsent(String key, Object value) {
        if (!this.exists(key)) {
            this.put(key, value);
        }
    }

    public boolean exists(String key) {
        boolean exists;
        block8: {
            if (key == null) {
                throw new NullPointerException("key cant be null");
            }
            exists = false;
            PreparedStatement s = null;
            ResultSet rs = null;
            try {
                try {
                    s = this.connection.prepareStatement("select 1, type from bigdata where key = ?;");
                    s.setString(1, key);
                    rs = s.executeQuery();
                    if (rs.next()) {
                        exists = true;
                        if (rs.next()) {
                            logger.log(Level.SEVERE, "More than 1 value (row) matching key " + key);
                        }
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to get value for key " + key, e);
                    BigDataEncryptedFileSystem.closeAll(rs, s, null);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                BigDataEncryptedFileSystem.closeAll(rs, s, null);
                throw throwable;
            }
            BigDataEncryptedFileSystem.closeAll(rs, s, null);
        }
        return exists;
    }

    public void put(String key, Object value) {
        String type;
        if (key == null) {
            throw new NullPointerException("key cant be null");
        }
        ByteArrayInputStream is = null;
        if (value == null) {
            is = null;
            type = "null";
        } else if (value instanceof byte[]) {
            is = new ByteArrayInputStream((byte[])value);
            type = "byte[]";
        } else if (value instanceof String) {
            try {
                is = new ByteArrayInputStream(((String)value).getBytes("utf-8"));
                type = "string";
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        } else if (value instanceof File) {
            is = new ByteArrayInputStream(((File)value).getAbsolutePath().getBytes());
            type = "file";
        } else if (value instanceof Serializable) {
            is = new ByteArrayInputStream(ByteSerialiser.serialize((Object)value));
            type = "serializable";
        } else {
            throw new IllegalArgumentException("unsupported value type " + value.getClass().getName());
        }
        logger.log(Level.INFO, "add fs entry " + key + " of type " + type);
        PreparedStatement s = null;
        try {
            try {
                s = this.connection.prepareStatement("merge into bigdata values (?, ?, ?);");
                s.setString(1, key);
                if (is == null) {
                    s.setNull(2, 2004);
                } else {
                    s.setBinaryStream(2, is);
                }
                s.setString(3, type);
                int n = s.executeUpdate();
                if (n != 1) {
                    throw new SQLException("no row affected by insert");
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to insert value for key " + key, e);
                BigDataEncryptedFileSystem.closeAll(null, s, null);
            }
        }
        finally {
            BigDataEncryptedFileSystem.closeAll(null, s, null);
        }
    }

    public boolean remove(String key) {
        block7: {
            logger.log(Level.INFO, "remove fs entry " + key);
            if (key != null) {
                PreparedStatement s;
                block5: {
                    block6: {
                        s = null;
                        try {
                            if (this.connection == null || this.connection.isClosed()) break block5;
                            s = this.connection.prepareStatement("delete from bigdata where key = ?;");
                            s.setString(1, key);
                            int n = s.executeUpdate();
                            if (n > 0) break block6;
                        }
                        catch (Exception e) {
                            try {
                                logger.log(Level.INFO, "Failed to delete value for key " + key, e);
                            }
                            catch (Throwable throwable) {
                                BigDataEncryptedFileSystem.closeAll(null, s, null);
                                throw throwable;
                            }
                            BigDataEncryptedFileSystem.closeAll(null, s, null);
                            break block7;
                        }
                        BigDataEncryptedFileSystem.closeAll(null, s, null);
                        return false;
                    }
                    BigDataEncryptedFileSystem.closeAll(null, s, null);
                    return true;
                }
                BigDataEncryptedFileSystem.closeAll(null, s, null);
            }
        }
        return false;
    }

    public boolean isAlive() {
        try {
            return this.connection != null && !this.connection.isClosed();
        }
        catch (SQLException sQLException) {
            return false;
        }
    }
}

