/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.library.file;

import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.StringUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class ReadExcelFile {
    public static List<HSSFRow> parseFileForSheet(String xlsFile, String sheetname) throws FileNotFoundException, IOException {
        ArrayList<HSSFRow> list = new ArrayList<HSSFRow>();
        InputStream in = ReadExcelFile.class.getClassLoader().getResourceAsStream("ca/infodata/lib/jFreeChart/" + xlsFile + ".xls");
        HSSFWorkbook workbook = new HSSFWorkbook(in);
        HSSFSheet sheet = workbook.getSheet(sheetname);
        int j = 0;
        while (j <= sheet.getLastRowNum()) {
            HSSFRow row = sheet.getRow(j);
            if (row != null) {
                list.add(row);
            }
            ++j;
        }
        return list;
    }

    public static List<HSSFRow> parseFileForSheet(String path, String xlsFile, String sheetname) throws FileNotFoundException, IOException {
        ArrayList<HSSFRow> list = new ArrayList<HSSFRow>();
        FileInputStream in = new FileInputStream(String.valueOf(path) + xlsFile);
        HSSFWorkbook workbook = new HSSFWorkbook((InputStream)in);
        HSSFSheet sheet = workbook.getSheet(sheetname);
        int j = 0;
        while (j <= sheet.getLastRowNum()) {
            HSSFRow row = sheet.getRow(j);
            if (row != null) {
                list.add(row);
            }
            ++j;
        }
        return list;
    }

    public static String[] parseSheetsInFile(String path) throws FileNotFoundException, IOException {
        ArrayList<String> list = new ArrayList<String>();
        POIFSFileSystem poif_fs = new POIFSFileSystem((InputStream)new FileInputStream(URLDecoder.decode(path, "Cp1252")));
        HSSFWorkbook workbook = new HSSFWorkbook(poif_fs);
        int numberSheets = workbook.getNumberOfSheets();
        int i = 0;
        while (i < numberSheets) {
            list.add(workbook.getSheetName(i));
            ++i;
        }
        String[] array = new String[list.size()];
        return list.toArray(array);
    }

    public static List<Map<String, String>> readFileAsString(String fullFillPath) throws FileNotFoundException, IOException {
        if (fullFillPath == null) {
            throw new NullPointerException("fullFillPath");
        }
        ArrayList items = null;
        MiscUtil.showTime((String)"1");
        String xlsFile = fullFillPath;
        String[] sheets = ReadExcelFile.parseSheetsInFile(xlsFile);
        List<HSSFRow> list = ReadExcelFile.parseFileForSheet("", xlsFile, sheets[0]);
        System.out.println(list.size());
        if (list.size() > 0) {
            String headerIndicator = "qwerty";
            boolean headersArePresent = false;
            HashMap<String, Integer> headers = new HashMap<String, Integer>();
            HSSFRow firstRow = list.get(0);
            int firstCellNum = firstRow.getFirstCellNum();
            short lastCellNum = firstRow.getLastCellNum();
            int i = firstCellNum;
            while (i < lastCellNum) {
                HSSFCell cell = firstRow.getCell(i);
                if (cell != null) {
                    String text = cell.getStringCellValue();
                    if (headerIndicator.equals(text)) {
                        headersArePresent = true;
                    } else if (StringUtils.isNotBlank((String)text)) {
                        headers.put(text.trim(), i);
                    }
                }
                ++i;
            }
            if (!headersArePresent) {
                throw new IllegalArgumentException("Le fichier sp\u00e9cifi\u00e9 ne sp\u00e9cifie pas les entetes de colonne dans la prem\u00e8re ligne. Ajoutez une colonne bidon avec l'entete qwerty");
            }
            items = new ArrayList();
            i = 1;
            while (i < list.size()) {
                HSSFRow row = list.get(i);
                HashMap<String, String> item = new HashMap<String, String>(headers.size());
                for (Map.Entry column : headers.entrySet()) {
                    String key = (String)column.getKey();
                    HSSFCell cell = row.getCell(((Integer)column.getValue()).intValue());
                    String value = cell == null ? null : cell.getStringCellValue();
                    item.put(key, value);
                }
                items.add(item);
                ++i;
            }
        } else {
            System.out.println("file is empty");
        }
        MiscUtil.showTime((String)"read");
        return items;
    }
}

