/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.laboresults.editor;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.LaboResultsAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.chat.LINK_TYPE;
import ca.infodata.ofys.data.middle.dataobjects.chat.MessageLink;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XDocumentType;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XDocuments;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XBaseLaboResultsProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLaboResultsProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLaboResultsProfessionnalStatus;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLaboResultsText;
import ca.infodata.ofys.data.middle.dataobjects.patient.IPatientRelated;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.IPrintable;
import ca.infodata.ofys.ui.controls.report2.PrintDialog2;
import ca.infodata.ofys.ui.controls.windows.AskTextQuestionDialog;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.laboresults.editor.BaseLaboResultsEditor;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.date.DateUtil;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;

public class LaboResultsEditor
extends BaseLaboResultsEditor
implements IPrintable,
IPatientRelated {
    private static final String MESSAGE_NULL_DOC = Messages.getString((String)"MESSAGE_NULL_DOC", (String[])new String[0]);
    protected static final String LABO = Messages.getString((String)"documenttype.LABO", (String[])new String[0]);
    private static final String ASSOCIER_DOCUMENT = Messages.getString((String)"ASSOCIER_DOCUMENT", (String[])new String[0]);
    private static final String VEUILLER_ENTRER_DESCR = Messages.getString((String)"VEUILLER_ENTRER_DESCR", (String[])new String[0]);
    private static final String DESCR_NE_PEUT_ETRE_NULL = Messages.getString((String)"DESCR_NE_PEUT_ETRE_NULL", (String[])new String[0]);
    private static final Logger logger = Logger.getLogger(LaboResultsEditor.class.getName());

    public void load() {
    }

    public void print() {
        PrintDialog2 dialog = new PrintDialog2(this.getSite().getShell(), (Serializable)this.getBaseLaboResultsProfessionnal());
        UI.centerComposite((Composite)dialog.getShell(), (Composite)this.getEditorSite().getShell());
        dialog.open();
    }

    public void setToolBarStatus() {
    }

    public void showDataObject() {
        XLaboResultsProfessionnal resultProfessionnal = this.getLaboResultsProfessionnal();
        this.laboViewer.setXlaboResultProfessionnal(resultProfessionnal);
    }

    public Image getEditorTitleImage() {
        return ResourceGetter.getImage((String)"images/pechere.gif");
    }

    public void initDataOverride() {
        IDataObject dataObject = ((EditorInput)this.getEditorInput()).getDataObject();
        if (dataObject instanceof XLaboResultsProfessionnal) {
            XLaboResultsProfessionnal labo = (XLaboResultsProfessionnal)dataObject;
            if (labo.getId() == null) {
                throw new IllegalArgumentException("LaboResultProfessional must have an id != null");
            }
            XLaboResultsProfessionnal labo2 = labo.clone();
            labo2.setSeenDatetime(Long.valueOf(DateUtil.newCalendar().getTimeInMillis()));
            if (labo2.getStatus().contains(XLaboResultsProfessionnalStatus.UNSEEN)) {
                labo2.addXLaboResultsProfessionnalStatus(XLaboResultsProfessionnalStatus.SEEN);
            }
            try {
                LaboResultsAccessorClient.getInstance().saveSync(((Object)((Object)this)).hashCode(), Application.get().getGlobalInstances().getSession(), (Serializable)labo2, false);
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
            }
            this.initializeCompleteDataObject((EditableDataObject)dataObject);
        } else if (dataObject instanceof XBaseLaboResultsProfessionnal) {
            XBaseLaboResultsProfessionnal labo = (XBaseLaboResultsProfessionnal)dataObject;
            if (labo.getId() == null) {
                throw new IllegalArgumentException("LaboResultProfessional must have an id != null");
            }
            JobCallback callback = null;
            try {
                try {
                    callback = new JobCallback(Messages.getString((String)"CHARGEMENT", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

                        public void responseReceived(final ReturnObject response) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    XLaboResultsProfessionnal object = (XLaboResultsProfessionnal)response.getObj();
                                    LaboResultsEditor.this.initializeCompleteDataObject((EditableDataObject)object);
                                }
                            });
                        }
                    };
                    LaboResultsAccessorClient.getInstance().getLaboResultsProfessionnal(Application.get().getGlobalInstances().getSession(), (ICallback)callback, labo);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Erreur", e);
                    if (callback != null) {
                        callback.kill();
                    }
                }
            }
            finally {
                if (callback != null) {
                    callback.kill();
                }
            }
        }
    }

    public BaseAccessorClient getAccessor() throws CannotConnectToServerException {
        return LaboResultsAccessorClient.getInstance();
    }

    public boolean isDataDirty() {
        return this.getLaboResultsProfessionnal() != null && this.getLaboResultsProfessionnal().isDirty();
    }

    @Override
    protected XLaboResultsProfessionnal getLaboResultsProfessionnal() {
        IEditorInput input = this.getEditorInput();
        if (input != null) {
            if (((EditorInput)input).getDataObject() instanceof XLaboResultsProfessionnal) {
                return (XLaboResultsProfessionnal)(input == null ? null : ((EditorInput)input).getDataObject());
            }
            return (XLaboResultsProfessionnal)(input == null ? null : ((EditorInput)input).getCompleteDataObject());
        }
        return null;
    }

    protected XBaseLaboResultsProfessionnal getBaseLaboResultsProfessionnal() {
        IEditorInput input = this.getEditorInput();
        if (input != null && ((EditorInput)input).getDataObject() instanceof XBaseLaboResultsProfessionnal) {
            return (XBaseLaboResultsProfessionnal)((EditorInput)input).getDataObject();
        }
        return null;
    }

    public String getEditorTitle() {
        XLaboResultsText r;
        XLaboResultsProfessionnal p = this.getLaboResultsProfessionnal();
        if (p != null && (r = p.getLaboResults()) != null && r.getPatient() != null) {
            if (Application.get().getGlobalInstances().inDebugMode()) {
                return new JoinList(", ", new Object[]{r.getPatient().getName(), "LaboProf=" + p.getId(), "LabText=" + r.getId()}).toString();
            }
            return r.getPatient().getName();
        }
        return RESULTATS_DE_LABORATOIRE;
    }

    public String getTitleToolTip() {
        XLaboResultsText r;
        XLaboResultsProfessionnal p = this.getLaboResultsProfessionnal();
        if (p != null && (r = p.getLaboResults()) != null) {
            return r.getName();
        }
        return RESULTATS_DE_LABORATOIRE;
    }

    public String getSuperTitleToolTip() {
        return this.getTitleToolTip();
    }

    public IPatient getPatient() {
        XBaseLaboResultsProfessionnal baseLabo;
        XLaboResultsText labo2;
        Object patient = null;
        XLaboResultsProfessionnal labo = this.getLaboResultsProfessionnal();
        patient = labo != null ? ((labo2 = labo.getLaboResults()) == null ? null : labo2.getPatient()) : ((baseLabo = this.getBaseLaboResultsProfessionnal()) == null ? null : baseLabo.getPatient());
        return patient;
    }

    public void initializeCompleteDataObject(EditableDataObject completeDataObject) {
        XLaboResultsProfessionnal labo;
        if (this.laboViewer.getCmbPrevious() != null && !this.laboViewer.getCmbPrevious().isDisposed()) {
            this.laboViewer.getCmbPrevious().removeAll();
            this.currentLaboResultsText = null;
        }
        this.initialNote = (labo = (XLaboResultsProfessionnal)completeDataObject) == null ? null : labo.getNote();
        super.initializeCompleteDataObject(completeDataObject);
    }

    public void saved() {
        XLaboResultsProfessionnal labo = this.getLaboResultsProfessionnal();
        this.initialNote = labo == null ? null : labo.getNote();
        super.saved();
    }

    public MessageLink getMessageLink() {
        MessageLink ml = null;
        if (this.getLaboResultsProfessionnal() != null && this.getLaboResultsProfessionnal().getId() != null) {
            ml = new MessageLink(this.getPatient(), LINK_TYPE.LABO, this.getLaboResultsProfessionnal().getId());
        }
        return ml;
    }

    public XDocuments getDocuments(Integer idPatientAnchor) {
        XLaboResultsProfessionnal xlrp = this.getLaboResultsProfessionnal();
        if (xlrp != null && this.getPatient().getId().equals(idPatientAnchor)) {
            final XDocuments doc = new XDocuments();
            final Boolean[] firstTryAndCanceled = new Boolean[]{true, false};
            while (!(doc.getDescription() != null && doc.getDescription().trim().length() != 0 || firstTryAndCanceled[1].booleanValue())) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        AskTextQuestionDialog diag = null;
                        if (firstTryAndCanceled[0].booleanValue()) {
                            diag = new AskTextQuestionDialog(LaboResultsEditor.this.getShell(), LABO, ASSOCIER_DOCUMENT, new String[]{VEUILLER_ENTRER_DESCR});
                            firstTryAndCanceled[0] = false;
                        } else {
                            diag = new AskTextQuestionDialog(LaboResultsEditor.this.getShell(), LABO, ASSOCIER_DOCUMENT, new String[]{VEUILLER_ENTRER_DESCR, DESCR_NE_PEUT_ETRE_NULL});
                        }
                        diag.open();
                        if (diag.getButtonClicked() == 0) {
                            doc.setDescription(diag.getAnswer());
                        } else {
                            firstTryAndCanceled[1] = true;
                        }
                    }
                });
            }
            if (!firstTryAndCanceled[1].booleanValue()) {
                doc.setIdDocument(xlrp.getId());
                doc.setType(XDocumentType.LABO);
                doc.setIsDeleted(Boolean.FALSE);
                return doc;
            }
        }
        return null;
    }

    public Shell getShell() {
        return this.getSite().getShell();
    }

    public String getMsgOnNullDocuments() {
        return MESSAGE_NULL_DOC;
    }

    public boolean isPrintAllowed() {
        XBaseLaboResultsProfessionnal labo = this.getBaseLaboResultsProfessionnal();
        return labo != null && labo.getId() != null;
    }
}

